/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.store.cassandra.persistence;

import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.cache.store.cassandra.persistence.PojoField;
import org.apache.ignite.cache.store.cassandra.persistence.PojoFieldAccessor;
import org.w3c.dom.Element;

public class PojoValueField
extends PojoField {
    private static final String STATIC_ATTR = "static";
    private static final String INDEX_ATTR = "index";
    private static final String INDEX_CLASS_ATTR = "indexClass";
    private static final String INDEX_OPTIONS_ATTR = "indexOptions";
    private Boolean isIndexed;
    private String idxCls;
    private String idxOptions;
    private Boolean isStatic;

    public PojoValueField(Element element, Class clazz) {
        super(element, clazz);
        if (element.hasAttribute(STATIC_ATTR)) {
            this.isStatic = Boolean.parseBoolean(element.getAttribute(STATIC_ATTR).trim().toLowerCase());
        }
        if (element.hasAttribute(INDEX_ATTR)) {
            this.isIndexed = Boolean.parseBoolean(element.getAttribute(INDEX_ATTR).trim().toLowerCase());
        }
        if (element.hasAttribute(INDEX_CLASS_ATTR)) {
            this.idxCls = element.getAttribute(INDEX_CLASS_ATTR).trim();
        }
        if (element.hasAttribute(INDEX_OPTIONS_ATTR)) {
            this.idxOptions = element.getAttribute(INDEX_OPTIONS_ATTR).trim();
            if (!this.idxOptions.toLowerCase().startsWith("with")) {
                this.idxOptions = this.idxOptions.toLowerCase().startsWith("options") ? "with " + this.idxOptions : "with options = " + this.idxOptions;
            }
        }
    }

    public PojoValueField(PojoFieldAccessor pojoFieldAccessor) {
        super(pojoFieldAccessor);
        QuerySqlField querySqlField = (QuerySqlField)pojoFieldAccessor.getAnnotation(QuerySqlField.class);
        this.isIndexed = querySqlField != null && querySqlField.index();
    }

    public PojoValueField(PojoValueField pojoValueField, Class<?> clazz) {
        super(pojoValueField, clazz);
        this.isStatic = pojoValueField.isStatic;
        this.isIndexed = pojoValueField.isIndexed;
        this.idxCls = pojoValueField.idxCls;
        this.idxOptions = pojoValueField.idxOptions;
    }

    @Override
    public String getColumnDDL() {
        String string = super.getColumnDDL();
        if (this.isStatic != null && this.isStatic.booleanValue()) {
            string = string + " static";
        }
        return string;
    }

    public boolean isIndexed() {
        return this.isIndexed != null && this.isIndexed != false;
    }

    public String getIndexDDL(String string, String string2) {
        if (this.isIndexed == null || !this.isIndexed.booleanValue()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.idxCls != null) {
            stringBuilder.append("create custom index if not exists on \"").append(string).append("\".\"").append(string2).append("\"");
        } else {
            stringBuilder.append("create index if not exists on \"").append(string).append("\".\"").append(string2).append("\"");
        }
        stringBuilder.append(" (\"").append(this.getColumn()).append("\")");
        if (this.idxCls != null) {
            stringBuilder.append(" using '").append(this.idxCls).append("'");
        }
        if (this.idxOptions != null) {
            stringBuilder.append(" ").append(this.idxOptions);
        }
        return stringBuilder.append(";").toString();
    }
}

