/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.store.cassandra.common;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.exceptions.ReadTimeoutException;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.ignite.cache.store.cassandra.common.PropertyMappingHelper;
import org.apache.ignite.internal.util.typedef.internal.U;

public class CassandraHelper {
    private static final Pattern KEYSPACE_EXIST_ERROR1 = Pattern.compile("Keyspace [0-9a-zA-Z_]+ does not exist");
    private static final Pattern KEYSPACE_EXIST_ERROR2 = Pattern.compile("Cannot add table '[0-9a-zA-Z_]+' to non existing keyspace.*");
    private static final Pattern KEYSPACE_EXIST_ERROR3 = Pattern.compile("Error preparing query, got ERROR INVALID: Keyspace [0-9a-zA-Z_]+ does not exist");
    private static final Pattern TABLE_EXIST_ERROR1 = Pattern.compile("unconfigured table [0-9a-zA-Z_]+");
    private static final String TABLE_EXIST_ERROR2 = "Error preparing query, got ERROR INVALID: unconfigured table";
    private static final Pattern TABLE_EXIST_ERROR3 = Pattern.compile("unconfigured columnfamily [0-9a-zA-Z_]+");
    private static final String PREP_STATEMENT_CLUSTER_INSTANCE_ERROR = "You may have used a PreparedStatement that was created with another Cluster instance";

    public static void closeSession(Session session) {
        if (session == null) {
            return;
        }
        Cluster cluster = session.getCluster();
        if (!session.isClosed()) {
            U.closeQuiet((AutoCloseable)session);
        }
        if (!cluster.isClosed()) {
            U.closeQuiet((AutoCloseable)cluster);
        }
    }

    public static boolean isKeyspaceAbsenceError(Throwable throwable) {
        while (throwable != null) {
            if (throwable instanceof InvalidQueryException && (KEYSPACE_EXIST_ERROR1.matcher(throwable.getMessage()).matches() || KEYSPACE_EXIST_ERROR2.matcher(throwable.getMessage()).matches())) {
                return true;
            }
            throwable = throwable.getCause();
        }
        return false;
    }

    public static boolean isTableAbsenceError(Throwable throwable) {
        while (throwable != null) {
            if (throwable instanceof InvalidQueryException && (TABLE_EXIST_ERROR1.matcher(throwable.getMessage()).matches() || TABLE_EXIST_ERROR3.matcher(throwable.getMessage()).matches() || KEYSPACE_EXIST_ERROR1.matcher(throwable.getMessage()).matches() || KEYSPACE_EXIST_ERROR2.matcher(throwable.getMessage()).matches())) {
                return true;
            }
            if (throwable instanceof NoHostAvailableException && ((NoHostAvailableException)throwable).getErrors() != null) {
                NoHostAvailableException noHostAvailableException = (NoHostAvailableException)throwable;
                for (Map.Entry entry : noHostAvailableException.getErrors().entrySet()) {
                    Throwable throwable2 = (Throwable)entry.getValue();
                    if (!(throwable2 instanceof DriverException) || !throwable2.getMessage().contains(TABLE_EXIST_ERROR2) && !KEYSPACE_EXIST_ERROR3.matcher(throwable2.getMessage()).matches()) continue;
                    return true;
                }
            }
            throwable = throwable.getCause();
        }
        return false;
    }

    public static boolean isHostsAvailabilityError(Throwable throwable) {
        while (throwable != null) {
            if (throwable instanceof NoHostAvailableException || throwable instanceof ReadTimeoutException) {
                return true;
            }
            throwable = throwable.getCause();
        }
        return false;
    }

    public static boolean isPreparedStatementClusterError(Throwable throwable) {
        while (throwable != null) {
            if (throwable instanceof InvalidQueryException && throwable.getMessage().contains(PREP_STATEMENT_CLUSTER_INSTANCE_ERROR)) {
                return true;
            }
            throwable = throwable.getCause();
        }
        return false;
    }

    public static boolean isCassandraCompatibleTypes(Class clazz, Class clazz2) {
        if (clazz == null || clazz2 == null) {
            return false;
        }
        DataType.Name name = PropertyMappingHelper.getCassandraType(clazz);
        DataType.Name name2 = PropertyMappingHelper.getCassandraType(clazz2);
        return name != null && name2 != null && name.equals((Object)name2);
    }
}

