/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.spark.SparkV2Filters;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.connector.expressions.filter.Predicate;
import org.apache.spark.sql.execution.datasources.SparkExpressionConverter;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Strategy$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.collection.Seq;

public final class SparkExpressionConverter$ {
    public static SparkExpressionConverter$ MODULE$;

    static {
        new SparkExpressionConverter$();
    }

    public Expression convertToIcebergExpression(org.apache.spark.sql.catalyst.expressions.Expression sparkExpression) {
        Option option = DataSourceV2Strategy$.MODULE$.translateFilterV2(sparkExpression);
        if (option instanceof Some) {
            Some some = (Some)option;
            Predicate filter = (Predicate)some.value();
            Expression converted = SparkV2Filters.convert(filter);
            if (converted == null) {
                throw new IllegalArgumentException(new StringBuilder(51).append("Cannot convert Spark filter: ").append(filter).append(" to Iceberg expression").toString());
            }
            return converted;
        }
        throw new IllegalArgumentException(new StringBuilder(57).append("Cannot translate Spark expression: ").append(sparkExpression).append(" to data source filter").toString());
    }

    public org.apache.spark.sql.catalyst.expressions.Expression collectResolvedSparkExpression(SparkSession session, String tableName, String where) throws AnalysisException {
        Seq tableAttrs = session.table(tableName).queryExecution().analyzed().output();
        org.apache.spark.sql.catalyst.expressions.Expression unresolvedExpression = session.sessionState().sqlParser().parseExpression(where);
        Filter filter = new Filter(unresolvedExpression, (LogicalPlan)new SparkExpressionConverter.DummyRelation((Seq<Attribute>)tableAttrs));
        LogicalPlan optimizedLogicalPlan = session.sessionState().executePlan((LogicalPlan)filter, session.sessionState().executePlan$default$2()).optimizedPlan();
        return (org.apache.spark.sql.catalyst.expressions.Expression)optimizedLogicalPlan.collectFirst((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof Filter) {
                    Filter filter = (Filter)A1;
                    return (B1)filter.condition();
                }
                if (A1 instanceof SparkExpressionConverter.DummyRelation) {
                    return (B1)Literal$.MODULE$.TrueLiteral();
                }
                if (A1 instanceof LocalRelation) {
                    return (B1)Literal$.MODULE$.FalseLiteral();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                if (logicalPlan instanceof Filter) {
                    return true;
                }
                if (logicalPlan instanceof SparkExpressionConverter.DummyRelation) {
                    return true;
                }
                return logicalPlan instanceof LocalRelation;
            }
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new AnalysisException("Failed to find filter expression", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7(), AnalysisException$.MODULE$.$lessinit$greater$default$8());
        });
    }

    private SparkExpressionConverter$() {
        MODULE$ = this;
    }
}

