/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.IsolationLevel;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.PartitionKey;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Partitioning;
import org.apache.iceberg.RowDelta;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SnapshotUpdate;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.deletes.DeleteGranularity;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.exceptions.CleanableFailure;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.True;
import org.apache.iceberg.io.BasePositionDeltaWriter;
import org.apache.iceberg.io.ClusteredDataWriter;
import org.apache.iceberg.io.ClusteredPositionDeleteWriter;
import org.apache.iceberg.io.DataWriteResult;
import org.apache.iceberg.io.DeleteWriteResult;
import org.apache.iceberg.io.FanoutDataWriter;
import org.apache.iceberg.io.FanoutPositionOnlyDeleteWriter;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.FileWriterFactory;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.io.PartitioningWriter;
import org.apache.iceberg.io.PositionDeltaWriter;
import org.apache.iceberg.io.WriteResult;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.spark.CommitMetadata;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.SparkWriteConf;
import org.apache.iceberg.spark.SparkWriteRequirements;
import org.apache.iceberg.spark.source.InternalRowWrapper;
import org.apache.iceberg.spark.source.SerializableTableWithSize;
import org.apache.iceberg.spark.source.SparkBatchQueryScan;
import org.apache.iceberg.spark.source.SparkCleanupUtil;
import org.apache.iceberg.spark.source.SparkFileWriterFactory;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.CharSequenceSet;
import org.apache.iceberg.util.StructProjection;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.distributions.Distribution;
import org.apache.spark.sql.connector.expressions.SortOrder;
import org.apache.spark.sql.connector.write.DeltaBatchWrite;
import org.apache.spark.sql.connector.write.DeltaWrite;
import org.apache.spark.sql.connector.write.DeltaWriter;
import org.apache.spark.sql.connector.write.DeltaWriterFactory;
import org.apache.spark.sql.connector.write.LogicalWriteInfo;
import org.apache.spark.sql.connector.write.PhysicalWriteInfo;
import org.apache.spark.sql.connector.write.RequiresDistributionAndOrdering;
import org.apache.spark.sql.connector.write.RowLevelOperation;
import org.apache.spark.sql.connector.write.WriterCommitMessage;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SparkPositionDeltaWrite
implements DeltaWrite,
RequiresDistributionAndOrdering {
    private static final Logger LOG = LoggerFactory.getLogger(SparkPositionDeltaWrite.class);
    private final JavaSparkContext sparkContext;
    private final Table table;
    private final RowLevelOperation.Command command;
    private final SparkBatchQueryScan scan;
    private final IsolationLevel isolationLevel;
    private final String applicationId;
    private final boolean wapEnabled;
    private final String wapId;
    private final String branch;
    private final Map<String, String> extraSnapshotMetadata;
    private final SparkWriteRequirements writeRequirements;
    private final Context context;
    private final Map<String, String> writeProperties;
    private boolean cleanupOnAbort = false;

    SparkPositionDeltaWrite(SparkSession spark, Table table, RowLevelOperation.Command command, SparkBatchQueryScan scan, IsolationLevel isolationLevel, SparkWriteConf writeConf, LogicalWriteInfo info, Schema dataSchema) {
        this.sparkContext = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        this.table = table;
        this.command = command;
        this.scan = scan;
        this.isolationLevel = isolationLevel;
        this.applicationId = spark.sparkContext().applicationId();
        this.wapEnabled = writeConf.wapEnabled();
        this.wapId = writeConf.wapId();
        this.branch = writeConf.branch();
        this.extraSnapshotMetadata = writeConf.extraSnapshotMetadata();
        this.writeRequirements = writeConf.positionDeltaRequirements(command);
        this.context = new Context(dataSchema, writeConf, info, this.writeRequirements);
        this.writeProperties = writeConf.writeProperties();
    }

    public Distribution requiredDistribution() {
        return this.writeRequirements.distribution();
    }

    public boolean distributionStrictlyRequired() {
        return false;
    }

    public SortOrder[] requiredOrdering() {
        return this.writeRequirements.ordering();
    }

    public DeltaBatchWrite toBatch() {
        return new PositionDeltaBatchWrite();
    }

    private static class Context
    implements Serializable {
        private final Schema dataSchema;
        private final StructType dataSparkType;
        private final FileFormat dataFileFormat;
        private final long targetDataFileSize;
        private final StructType deleteSparkType;
        private final StructType metadataSparkType;
        private final FileFormat deleteFileFormat;
        private final long targetDeleteFileSize;
        private final DeleteGranularity deleteGranularity;
        private final String queryId;
        private final boolean fanoutWriterEnabled;
        private final boolean inputOrdered;

        Context(Schema dataSchema, SparkWriteConf writeConf, LogicalWriteInfo info, SparkWriteRequirements writeRequirements) {
            this.dataSchema = dataSchema;
            this.dataSparkType = info.schema();
            this.dataFileFormat = writeConf.dataFileFormat();
            this.targetDataFileSize = writeConf.targetDataFileSize();
            this.deleteSparkType = (StructType)info.rowIdSchema().get();
            this.deleteFileFormat = writeConf.deleteFileFormat();
            this.targetDeleteFileSize = writeConf.targetDeleteFileSize();
            this.deleteGranularity = writeConf.deleteGranularity();
            this.metadataSparkType = (StructType)info.metadataSchema().get();
            this.queryId = info.queryId();
            this.fanoutWriterEnabled = writeConf.fanoutWriterEnabled();
            this.inputOrdered = writeRequirements.hasOrdering();
        }

        Schema dataSchema() {
            return this.dataSchema;
        }

        StructType dataSparkType() {
            return this.dataSparkType;
        }

        FileFormat dataFileFormat() {
            return this.dataFileFormat;
        }

        long targetDataFileSize() {
            return this.targetDataFileSize;
        }

        StructType deleteSparkType() {
            return this.deleteSparkType;
        }

        FileFormat deleteFileFormat() {
            return this.deleteFileFormat;
        }

        long targetDeleteFileSize() {
            return this.targetDeleteFileSize;
        }

        DeleteGranularity deleteGranularity() {
            return this.deleteGranularity;
        }

        String queryId() {
            return this.queryId;
        }

        boolean fanoutWriterEnabled() {
            return this.fanoutWriterEnabled;
        }

        boolean inputOrdered() {
            return this.inputOrdered;
        }

        int specIdOrdinal() {
            return this.metadataSparkType.fieldIndex(MetadataColumns.SPEC_ID.name());
        }

        int partitionOrdinal() {
            return this.metadataSparkType.fieldIndex("_partition");
        }

        int fileOrdinal() {
            return this.deleteSparkType.fieldIndex(MetadataColumns.FILE_PATH.name());
        }

        int positionOrdinal() {
            return this.deleteSparkType.fieldIndex(MetadataColumns.ROW_POSITION.name());
        }
    }

    private static class PartitionedDeltaWriter
    extends DeleteAndDataDeltaWriter {
        private final PartitionSpec dataSpec;
        private final PartitionKey dataPartitionKey;
        private final InternalRowWrapper internalRowDataWrapper;

        PartitionedDeltaWriter(Table table, SparkFileWriterFactory writerFactory, OutputFileFactory dataFileFactory, OutputFileFactory deleteFileFactory, Context context) {
            super(table, writerFactory, dataFileFactory, deleteFileFactory, context);
            this.dataSpec = table.spec();
            this.dataPartitionKey = new PartitionKey(this.dataSpec, context.dataSchema());
            this.internalRowDataWrapper = new InternalRowWrapper(context.dataSparkType(), context.dataSchema().asStruct());
        }

        public void update(InternalRow meta, InternalRow id, InternalRow row) throws IOException {
            throw new UnsupportedOperationException("Update must be represented as delete and insert");
        }

        public void insert(InternalRow row) throws IOException {
            this.dataPartitionKey.partition((StructLike)this.internalRowDataWrapper.wrap(row));
            this.delegate.insert((Object)row, this.dataSpec, (StructLike)this.dataPartitionKey);
        }
    }

    private static class UnpartitionedDeltaWriter
    extends DeleteAndDataDeltaWriter {
        private final PartitionSpec dataSpec;

        UnpartitionedDeltaWriter(Table table, SparkFileWriterFactory writerFactory, OutputFileFactory dataFileFactory, OutputFileFactory deleteFileFactory, Context context) {
            super(table, writerFactory, dataFileFactory, deleteFileFactory, context);
            this.dataSpec = table.spec();
        }

        public void update(InternalRow meta, InternalRow id, InternalRow row) throws IOException {
            throw new UnsupportedOperationException("Update must be represented as delete and insert");
        }

        public void insert(InternalRow row) throws IOException {
            this.delegate.insert((Object)row, this.dataSpec, null);
        }
    }

    private static abstract class DeleteAndDataDeltaWriter
    extends BaseDeltaWriter {
        protected final PositionDeltaWriter<InternalRow> delegate;
        private final FileIO io;
        private final Map<Integer, PartitionSpec> specs;
        private final InternalRowWrapper deletePartitionRowWrapper;
        private final Map<Integer, StructProjection> deletePartitionProjections;
        private final int specIdOrdinal;
        private final int partitionOrdinal;
        private final int fileOrdinal;
        private final int positionOrdinal;
        private boolean closed = false;

        DeleteAndDataDeltaWriter(Table table, SparkFileWriterFactory writerFactory, OutputFileFactory dataFileFactory, OutputFileFactory deleteFileFactory, Context context) {
            this.delegate = new BasePositionDeltaWriter(this.newDataWriter(table, writerFactory, dataFileFactory, context), this.newDeleteWriter(table, writerFactory, deleteFileFactory, context));
            this.io = table.io();
            this.specs = table.specs();
            Types.StructType partitionType = Partitioning.partitionType((Table)table);
            this.deletePartitionRowWrapper = this.initPartitionRowWrapper(partitionType);
            this.deletePartitionProjections = this.buildPartitionProjections(partitionType, this.specs);
            this.specIdOrdinal = context.specIdOrdinal();
            this.partitionOrdinal = context.partitionOrdinal();
            this.fileOrdinal = context.fileOrdinal();
            this.positionOrdinal = context.positionOrdinal();
        }

        public void delete(InternalRow meta, InternalRow id) throws IOException {
            int specId = meta.getInt(this.specIdOrdinal);
            PartitionSpec spec = this.specs.get(specId);
            InternalRow partition = meta.getStruct(this.partitionOrdinal, this.deletePartitionRowWrapper.size());
            StructProjection partitionProjection = this.deletePartitionProjections.get(specId);
            partitionProjection.wrap((StructLike)this.deletePartitionRowWrapper.wrap(partition));
            String file = id.getString(this.fileOrdinal);
            long position = id.getLong(this.positionOrdinal);
            this.delegate.delete((CharSequence)file, position, spec, (StructLike)partitionProjection);
        }

        public WriterCommitMessage commit() throws IOException {
            this.close();
            WriteResult result = this.delegate.result();
            return new DeltaTaskCommit(result);
        }

        public void abort() throws IOException {
            this.close();
            WriteResult result = this.delegate.result();
            SparkCleanupUtil.deleteTaskFiles(this.io, this.files(result));
        }

        private List<ContentFile<?>> files(WriteResult result) {
            ArrayList files = Lists.newArrayList();
            files.addAll(Arrays.asList(result.dataFiles()));
            files.addAll(Arrays.asList(result.deleteFiles()));
            return files;
        }

        public void close() throws IOException {
            if (!this.closed) {
                this.delegate.close();
                this.closed = true;
            }
        }
    }

    private static class DeleteOnlyDeltaWriter
    extends BaseDeltaWriter {
        private final PartitioningWriter<PositionDelete<InternalRow>, DeleteWriteResult> delegate;
        private final PositionDelete<InternalRow> positionDelete;
        private final FileIO io;
        private final Map<Integer, PartitionSpec> specs;
        private final InternalRowWrapper partitionRowWrapper;
        private final Map<Integer, StructProjection> partitionProjections;
        private final int specIdOrdinal;
        private final int partitionOrdinal;
        private final int fileOrdinal;
        private final int positionOrdinal;
        private boolean closed = false;

        DeleteOnlyDeltaWriter(Table table, SparkFileWriterFactory writerFactory, OutputFileFactory deleteFileFactory, Context context) {
            this.delegate = this.newDeleteWriter(table, writerFactory, deleteFileFactory, context);
            this.positionDelete = PositionDelete.create();
            this.io = table.io();
            this.specs = table.specs();
            Types.StructType partitionType = Partitioning.partitionType((Table)table);
            this.partitionRowWrapper = this.initPartitionRowWrapper(partitionType);
            this.partitionProjections = this.buildPartitionProjections(partitionType, this.specs);
            this.specIdOrdinal = context.specIdOrdinal();
            this.partitionOrdinal = context.partitionOrdinal();
            this.fileOrdinal = context.fileOrdinal();
            this.positionOrdinal = context.positionOrdinal();
        }

        public void delete(InternalRow metadata, InternalRow id) throws IOException {
            int specId = metadata.getInt(this.specIdOrdinal);
            PartitionSpec spec = this.specs.get(specId);
            InternalRow partition = metadata.getStruct(this.partitionOrdinal, this.partitionRowWrapper.size());
            StructProjection partitionProjection = this.partitionProjections.get(specId);
            partitionProjection.wrap((StructLike)this.partitionRowWrapper.wrap(partition));
            String file = id.getString(this.fileOrdinal);
            long position = id.getLong(this.positionOrdinal);
            this.positionDelete.set((CharSequence)file, position, null);
            this.delegate.write(this.positionDelete, spec, (StructLike)partitionProjection);
        }

        public void update(InternalRow metadata, InternalRow id, InternalRow row) {
            throw new UnsupportedOperationException(this.getClass().getName() + " does not implement update");
        }

        public void insert(InternalRow row) throws IOException {
            throw new UnsupportedOperationException(this.getClass().getName() + " does not implement insert");
        }

        public WriterCommitMessage commit() throws IOException {
            this.close();
            DeleteWriteResult result = (DeleteWriteResult)this.delegate.result();
            return new DeltaTaskCommit(result);
        }

        public void abort() throws IOException {
            this.close();
            DeleteWriteResult result = (DeleteWriteResult)this.delegate.result();
            SparkCleanupUtil.deleteTaskFiles(this.io, result.deleteFiles());
        }

        public void close() throws IOException {
            if (!this.closed) {
                this.delegate.close();
                this.closed = true;
            }
        }
    }

    private static abstract class BaseDeltaWriter
    implements DeltaWriter<InternalRow> {
        private BaseDeltaWriter() {
        }

        protected InternalRowWrapper initPartitionRowWrapper(Types.StructType partitionType) {
            StructType sparkPartitionType = (StructType)SparkSchemaUtil.convert((Type)partitionType);
            return new InternalRowWrapper(sparkPartitionType, partitionType);
        }

        protected Map<Integer, StructProjection> buildPartitionProjections(Types.StructType partitionType, Map<Integer, PartitionSpec> specs) {
            HashMap partitionProjections = Maps.newHashMap();
            for (int specId : specs.keySet()) {
                PartitionSpec spec = specs.get(specId);
                StructProjection projection = StructProjection.create((Types.StructType)partitionType, (Types.StructType)spec.partitionType());
                partitionProjections.put(specId, projection);
            }
            return partitionProjections;
        }

        protected PartitioningWriter<InternalRow, DataWriteResult> newDataWriter(Table table, SparkFileWriterFactory writers, OutputFileFactory files, Context context) {
            FileIO io = table.io();
            boolean fanoutEnabled = context.fanoutWriterEnabled();
            boolean inputOrdered = context.inputOrdered();
            long targetFileSize = context.targetDataFileSize();
            if (table.spec().isPartitioned() && fanoutEnabled && !inputOrdered) {
                return new FanoutDataWriter((FileWriterFactory)writers, files, io, targetFileSize);
            }
            return new ClusteredDataWriter((FileWriterFactory)writers, files, io, targetFileSize);
        }

        protected PartitioningWriter<PositionDelete<InternalRow>, DeleteWriteResult> newDeleteWriter(Table table, SparkFileWriterFactory writers, OutputFileFactory files, Context context) {
            FileIO io = table.io();
            boolean inputOrdered = context.inputOrdered();
            long targetFileSize = context.targetDeleteFileSize();
            DeleteGranularity deleteGranularity = context.deleteGranularity();
            if (inputOrdered) {
                return new ClusteredPositionDeleteWriter((FileWriterFactory)writers, files, io, targetFileSize, deleteGranularity);
            }
            return new FanoutPositionOnlyDeleteWriter((FileWriterFactory)writers, files, io, targetFileSize, deleteGranularity);
        }
    }

    private static class PositionDeltaWriteFactory
    implements DeltaWriterFactory {
        private final Broadcast<Table> tableBroadcast;
        private final RowLevelOperation.Command command;
        private final Context context;
        private final Map<String, String> writeProperties;

        PositionDeltaWriteFactory(Broadcast<Table> tableBroadcast, RowLevelOperation.Command command, Context context, Map<String, String> writeProperties) {
            this.tableBroadcast = tableBroadcast;
            this.command = command;
            this.context = context;
            this.writeProperties = writeProperties;
        }

        public DeltaWriter<InternalRow> createWriter(int partitionId, long taskId) {
            Table table = (Table)this.tableBroadcast.value();
            OutputFileFactory dataFileFactory = OutputFileFactory.builderFor((Table)table, (int)partitionId, (long)taskId).format(this.context.dataFileFormat()).operationId(this.context.queryId()).build();
            OutputFileFactory deleteFileFactory = OutputFileFactory.builderFor((Table)table, (int)partitionId, (long)taskId).format(this.context.deleteFileFormat()).operationId(this.context.queryId()).suffix("deletes").build();
            SparkFileWriterFactory writerFactory = SparkFileWriterFactory.builderFor(table).dataFileFormat(this.context.dataFileFormat()).dataSchema(this.context.dataSchema()).dataSparkType(this.context.dataSparkType()).deleteFileFormat(this.context.deleteFileFormat()).positionDeleteSparkType(this.context.deleteSparkType()).writeProperties(this.writeProperties).build();
            if (this.command == RowLevelOperation.Command.DELETE) {
                return new DeleteOnlyDeltaWriter(table, writerFactory, deleteFileFactory, this.context);
            }
            if (table.spec().isUnpartitioned()) {
                return new UnpartitionedDeltaWriter(table, writerFactory, dataFileFactory, deleteFileFactory, this.context);
            }
            return new PartitionedDeltaWriter(table, writerFactory, dataFileFactory, deleteFileFactory, this.context);
        }
    }

    public static class DeltaTaskCommit
    implements WriterCommitMessage {
        private final DataFile[] dataFiles;
        private final DeleteFile[] deleteFiles;
        private final CharSequence[] referencedDataFiles;

        DeltaTaskCommit(WriteResult result) {
            this.dataFiles = result.dataFiles();
            this.deleteFiles = result.deleteFiles();
            this.referencedDataFiles = result.referencedDataFiles();
        }

        DeltaTaskCommit(DeleteWriteResult result) {
            this.dataFiles = new DataFile[0];
            this.deleteFiles = result.deleteFiles().toArray(new DeleteFile[0]);
            this.referencedDataFiles = (CharSequence[])result.referencedDataFiles().toArray((Object[])new CharSequence[0]);
        }

        DataFile[] dataFiles() {
            return this.dataFiles;
        }

        DeleteFile[] deleteFiles() {
            return this.deleteFiles;
        }

        CharSequence[] referencedDataFiles() {
            return this.referencedDataFiles;
        }
    }

    private class PositionDeltaBatchWrite
    implements DeltaBatchWrite {
        private PositionDeltaBatchWrite() {
        }

        public DeltaWriterFactory createBatchWriterFactory(PhysicalWriteInfo info) {
            Broadcast tableBroadcast = SparkPositionDeltaWrite.this.sparkContext.broadcast((Object)SerializableTableWithSize.copyOf(SparkPositionDeltaWrite.this.table));
            return new PositionDeltaWriteFactory((Broadcast<Table>)tableBroadcast, SparkPositionDeltaWrite.this.command, SparkPositionDeltaWrite.this.context, SparkPositionDeltaWrite.this.writeProperties);
        }

        public boolean useCommitCoordinator() {
            return false;
        }

        public void commit(WriterCommitMessage[] messages) {
            RowDelta rowDelta = SparkPositionDeltaWrite.this.table.newRowDelta();
            CharSequenceSet referencedDataFiles = CharSequenceSet.empty();
            int addedDataFilesCount = 0;
            int addedDeleteFilesCount = 0;
            for (WriterCommitMessage message : messages) {
                DeltaTaskCommit taskCommit = (DeltaTaskCommit)message;
                for (DataFile dataFile : taskCommit.dataFiles()) {
                    rowDelta.addRows(dataFile);
                    ++addedDataFilesCount;
                }
                for (DataFile dataFile : taskCommit.deleteFiles()) {
                    rowDelta.addDeletes((DeleteFile)dataFile);
                    ++addedDeleteFilesCount;
                }
                referencedDataFiles.addAll(Arrays.asList(taskCommit.referencedDataFiles()));
            }
            if (SparkPositionDeltaWrite.this.scan != null) {
                Expression conflictDetectionFilter = this.conflictDetectionFilter(SparkPositionDeltaWrite.this.scan);
                rowDelta.conflictDetectionFilter(conflictDetectionFilter);
                rowDelta.validateDataFilesExist((Iterable)referencedDataFiles);
                if (SparkPositionDeltaWrite.this.scan.snapshotId() != null) {
                    rowDelta.validateFromSnapshot(SparkPositionDeltaWrite.this.scan.snapshotId().longValue());
                }
                if (SparkPositionDeltaWrite.this.command == RowLevelOperation.Command.UPDATE || SparkPositionDeltaWrite.this.command == RowLevelOperation.Command.MERGE) {
                    rowDelta.validateDeletedFiles();
                    rowDelta.validateNoConflictingDeleteFiles();
                }
                if (SparkPositionDeltaWrite.this.isolationLevel == IsolationLevel.SERIALIZABLE) {
                    rowDelta.validateNoConflictingDataFiles();
                }
                String commitMsg = String.format("position delta with %d data files and %d delete files (scanSnapshotId: %d, conflictDetectionFilter: %s, isolationLevel: %s)", addedDataFilesCount, addedDeleteFilesCount, SparkPositionDeltaWrite.this.scan.snapshotId(), conflictDetectionFilter, SparkPositionDeltaWrite.this.isolationLevel);
                this.commitOperation((SnapshotUpdate<?>)rowDelta, commitMsg);
            } else {
                String commitMsg = String.format("position delta with %d data files and %d delete files (no validation required)", addedDataFilesCount, addedDeleteFilesCount);
                this.commitOperation((SnapshotUpdate<?>)rowDelta, commitMsg);
            }
        }

        private Expression conflictDetectionFilter(SparkBatchQueryScan queryScan) {
            True filter = Expressions.alwaysTrue();
            for (Expression expr : queryScan.filterExpressions()) {
                filter = Expressions.and((Expression)filter, (Expression)expr);
            }
            return filter;
        }

        public void abort(WriterCommitMessage[] messages) {
            if (SparkPositionDeltaWrite.this.cleanupOnAbort) {
                SparkCleanupUtil.deleteFiles("job abort", SparkPositionDeltaWrite.this.table.io(), this.files(messages));
            } else {
                LOG.warn("Skipping cleanup of written files");
            }
        }

        private List<ContentFile<?>> files(WriterCommitMessage[] messages) {
            ArrayList files = Lists.newArrayList();
            for (WriterCommitMessage message : messages) {
                if (message == null) continue;
                DeltaTaskCommit taskCommit = (DeltaTaskCommit)message;
                files.addAll(Arrays.asList(taskCommit.dataFiles()));
                files.addAll(Arrays.asList(taskCommit.deleteFiles()));
            }
            return files;
        }

        private void commitOperation(SnapshotUpdate<?> operation, String description) {
            LOG.info("Committing {} to table {}", (Object)description, (Object)SparkPositionDeltaWrite.this.table);
            if (SparkPositionDeltaWrite.this.applicationId != null) {
                operation.set("spark.app.id", SparkPositionDeltaWrite.this.applicationId);
            }
            SparkPositionDeltaWrite.this.extraSnapshotMetadata.forEach((arg_0, arg_1) -> operation.set(arg_0, arg_1));
            CommitMetadata.commitProperties().forEach((arg_0, arg_1) -> operation.set(arg_0, arg_1));
            if (SparkPositionDeltaWrite.this.wapEnabled && SparkPositionDeltaWrite.this.wapId != null) {
                operation.set("wap.id", SparkPositionDeltaWrite.this.wapId);
                operation.stageOnly();
            }
            if (SparkPositionDeltaWrite.this.branch != null) {
                operation.toBranch(SparkPositionDeltaWrite.this.branch);
            }
            try {
                long start = System.currentTimeMillis();
                operation.commit();
                long duration = System.currentTimeMillis() - start;
                LOG.info("Committed in {} ms", (Object)duration);
            }
            catch (Exception e) {
                SparkPositionDeltaWrite.this.cleanupOnAbort = e instanceof CleanableFailure;
                throw e;
            }
        }
    }
}

