/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import org.apache.iceberg.IsolationLevel;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Table;
import org.apache.iceberg.spark.source.SparkPositionDeltaWriteBuilder;
import org.apache.iceberg.spark.source.SparkScanBuilder;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connector.expressions.Expressions;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.connector.write.DeltaWriteBuilder;
import org.apache.spark.sql.connector.write.LogicalWriteInfo;
import org.apache.spark.sql.connector.write.RowLevelOperation;
import org.apache.spark.sql.connector.write.RowLevelOperationInfo;
import org.apache.spark.sql.connector.write.SupportsDelta;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;

class SparkPositionDeltaOperation
implements RowLevelOperation,
SupportsDelta {
    private final SparkSession spark;
    private final Table table;
    private final String branch;
    private final RowLevelOperation.Command command;
    private final IsolationLevel isolationLevel;
    private ScanBuilder lazyScanBuilder;
    private Scan configuredScan;
    private DeltaWriteBuilder lazyWriteBuilder;

    SparkPositionDeltaOperation(SparkSession spark, Table table, String branch, RowLevelOperationInfo info, IsolationLevel isolationLevel) {
        this.spark = spark;
        this.table = table;
        this.branch = branch;
        this.command = info.command();
        this.isolationLevel = isolationLevel;
    }

    public RowLevelOperation.Command command() {
        return this.command;
    }

    public ScanBuilder newScanBuilder(CaseInsensitiveStringMap options) {
        if (this.lazyScanBuilder == null) {
            this.lazyScanBuilder = new SparkScanBuilder(this.spark, this.table, this.branch, options){

                @Override
                public Scan build() {
                    Scan scan;
                    SparkPositionDeltaOperation.this.configuredScan = scan = super.buildMergeOnReadScan();
                    return scan;
                }
            };
        }
        return this.lazyScanBuilder;
    }

    public DeltaWriteBuilder newWriteBuilder(LogicalWriteInfo info) {
        if (this.lazyWriteBuilder == null) {
            this.lazyWriteBuilder = new SparkPositionDeltaWriteBuilder(this.spark, this.table, this.branch, this.command, this.configuredScan, this.isolationLevel, info);
        }
        return this.lazyWriteBuilder;
    }

    public NamedReference[] requiredMetadataAttributes() {
        NamedReference specId = Expressions.column((String)MetadataColumns.SPEC_ID.name());
        NamedReference partition = Expressions.column((String)"_partition");
        return new NamedReference[]{specId, partition};
    }

    public NamedReference[] rowId() {
        NamedReference file = Expressions.column((String)MetadataColumns.FILE_PATH.name());
        NamedReference pos = Expressions.column((String)MetadataColumns.ROW_POSITION.name());
        return new NamedReference[]{file, pos};
    }
}

