/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.Map;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.data.BaseFileWriterFactory;
import org.apache.iceberg.io.DeleteSchemaUtil;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.data.SparkAvroWriter;
import org.apache.iceberg.spark.data.SparkOrcWriter;
import org.apache.iceberg.spark.data.SparkParquetWriters;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;

class SparkFileWriterFactory
extends BaseFileWriterFactory<InternalRow> {
    private StructType dataSparkType;
    private StructType equalityDeleteSparkType;
    private StructType positionDeleteSparkType;
    private final Map<String, String> writeProperties;

    SparkFileWriterFactory(Table table, FileFormat dataFileFormat, Schema dataSchema, StructType dataSparkType, SortOrder dataSortOrder, FileFormat deleteFileFormat, int[] equalityFieldIds, Schema equalityDeleteRowSchema, StructType equalityDeleteSparkType, SortOrder equalityDeleteSortOrder, Schema positionDeleteRowSchema, StructType positionDeleteSparkType, Map<String, String> writeProperties) {
        super(table, dataFileFormat, dataSchema, dataSortOrder, deleteFileFormat, equalityFieldIds, equalityDeleteRowSchema, equalityDeleteSortOrder, positionDeleteRowSchema);
        this.dataSparkType = dataSparkType;
        this.equalityDeleteSparkType = equalityDeleteSparkType;
        this.positionDeleteSparkType = positionDeleteSparkType;
        this.writeProperties = writeProperties != null ? writeProperties : ImmutableMap.of();
    }

    static Builder builderFor(Table table) {
        return new Builder(table);
    }

    protected void configureDataWrite(Avro.DataWriteBuilder builder) {
        builder.createWriterFunc(ignored -> new SparkAvroWriter(this.dataSparkType()));
        builder.setAll(this.writeProperties);
    }

    protected void configureEqualityDelete(Avro.DeleteWriteBuilder builder) {
        builder.createWriterFunc(ignored -> new SparkAvroWriter(this.equalityDeleteSparkType()));
        builder.setAll(this.writeProperties);
    }

    protected void configurePositionDelete(Avro.DeleteWriteBuilder builder) {
        boolean withRow = this.positionDeleteSparkType().getFieldIndex("row").isDefined();
        if (withRow) {
            StructField rowField = this.positionDeleteSparkType().apply("row");
            StructType positionDeleteRowSparkType = (StructType)rowField.dataType();
            builder.createWriterFunc(ignored -> new SparkAvroWriter(positionDeleteRowSparkType));
        }
        builder.setAll(this.writeProperties);
    }

    protected void configureDataWrite(Parquet.DataWriteBuilder builder) {
        builder.createWriterFunc(msgType -> SparkParquetWriters.buildWriter(this.dataSparkType(), msgType));
        builder.setAll(this.writeProperties);
    }

    protected void configureEqualityDelete(Parquet.DeleteWriteBuilder builder) {
        builder.createWriterFunc(msgType -> SparkParquetWriters.buildWriter(this.equalityDeleteSparkType(), msgType));
        builder.setAll(this.writeProperties);
    }

    protected void configurePositionDelete(Parquet.DeleteWriteBuilder builder) {
        builder.createWriterFunc(msgType -> SparkParquetWriters.buildWriter(this.positionDeleteSparkType(), msgType));
        builder.transformPaths(path -> UTF8String.fromString((String)path.toString()));
        builder.setAll(this.writeProperties);
    }

    protected void configureDataWrite(ORC.DataWriteBuilder builder) {
        builder.createWriterFunc(SparkOrcWriter::new);
        builder.setAll(this.writeProperties);
    }

    protected void configureEqualityDelete(ORC.DeleteWriteBuilder builder) {
        builder.createWriterFunc(SparkOrcWriter::new);
        builder.setAll(this.writeProperties);
    }

    protected void configurePositionDelete(ORC.DeleteWriteBuilder builder) {
        builder.createWriterFunc(SparkOrcWriter::new);
        builder.transformPaths(path -> UTF8String.fromString((String)path.toString()));
        builder.setAll(this.writeProperties);
    }

    private StructType dataSparkType() {
        if (this.dataSparkType == null) {
            Preconditions.checkNotNull((Object)this.dataSchema(), (Object)"Data schema must not be null");
            this.dataSparkType = SparkSchemaUtil.convert(this.dataSchema());
        }
        return this.dataSparkType;
    }

    private StructType equalityDeleteSparkType() {
        if (this.equalityDeleteSparkType == null) {
            Preconditions.checkNotNull((Object)this.equalityDeleteRowSchema(), (Object)"Equality delete schema must not be null");
            this.equalityDeleteSparkType = SparkSchemaUtil.convert(this.equalityDeleteRowSchema());
        }
        return this.equalityDeleteSparkType;
    }

    private StructType positionDeleteSparkType() {
        if (this.positionDeleteSparkType == null) {
            Schema positionDeleteSchema = DeleteSchemaUtil.posDeleteSchema((Schema)this.positionDeleteRowSchema());
            this.positionDeleteSparkType = SparkSchemaUtil.convert(positionDeleteSchema);
        }
        return this.positionDeleteSparkType;
    }

    static class Builder {
        private final Table table;
        private FileFormat dataFileFormat;
        private Schema dataSchema;
        private StructType dataSparkType;
        private SortOrder dataSortOrder;
        private FileFormat deleteFileFormat;
        private int[] equalityFieldIds;
        private Schema equalityDeleteRowSchema;
        private StructType equalityDeleteSparkType;
        private SortOrder equalityDeleteSortOrder;
        private Schema positionDeleteRowSchema;
        private StructType positionDeleteSparkType;
        private Map<String, String> writeProperties;

        Builder(Table table) {
            this.table = table;
            Map properties = table.properties();
            String dataFileFormatName = properties.getOrDefault("write.format.default", "parquet");
            this.dataFileFormat = FileFormat.fromString((String)dataFileFormatName);
            String deleteFileFormatName = properties.getOrDefault("write.delete.format.default", dataFileFormatName);
            this.deleteFileFormat = FileFormat.fromString((String)deleteFileFormatName);
        }

        Builder dataFileFormat(FileFormat newDataFileFormat) {
            this.dataFileFormat = newDataFileFormat;
            return this;
        }

        Builder dataSchema(Schema newDataSchema) {
            this.dataSchema = newDataSchema;
            return this;
        }

        Builder dataSparkType(StructType newDataSparkType) {
            this.dataSparkType = newDataSparkType;
            return this;
        }

        Builder dataSortOrder(SortOrder newDataSortOrder) {
            this.dataSortOrder = newDataSortOrder;
            return this;
        }

        Builder deleteFileFormat(FileFormat newDeleteFileFormat) {
            this.deleteFileFormat = newDeleteFileFormat;
            return this;
        }

        Builder equalityFieldIds(int[] newEqualityFieldIds) {
            this.equalityFieldIds = newEqualityFieldIds;
            return this;
        }

        Builder equalityDeleteRowSchema(Schema newEqualityDeleteRowSchema) {
            this.equalityDeleteRowSchema = newEqualityDeleteRowSchema;
            return this;
        }

        Builder equalityDeleteSparkType(StructType newEqualityDeleteSparkType) {
            this.equalityDeleteSparkType = newEqualityDeleteSparkType;
            return this;
        }

        Builder equalityDeleteSortOrder(SortOrder newEqualityDeleteSortOrder) {
            this.equalityDeleteSortOrder = newEqualityDeleteSortOrder;
            return this;
        }

        Builder positionDeleteRowSchema(Schema newPositionDeleteRowSchema) {
            this.positionDeleteRowSchema = newPositionDeleteRowSchema;
            return this;
        }

        Builder positionDeleteSparkType(StructType newPositionDeleteSparkType) {
            this.positionDeleteSparkType = newPositionDeleteSparkType;
            return this;
        }

        Builder writeProperties(Map<String, String> properties) {
            this.writeProperties = properties;
            return this;
        }

        SparkFileWriterFactory build() {
            boolean noEqualityDeleteConf = this.equalityFieldIds == null && this.equalityDeleteRowSchema == null;
            boolean fullEqualityDeleteConf = this.equalityFieldIds != null && this.equalityDeleteRowSchema != null;
            Preconditions.checkArgument((noEqualityDeleteConf || fullEqualityDeleteConf ? 1 : 0) != 0, (Object)"Equality field IDs and equality delete row schema must be set together");
            return new SparkFileWriterFactory(this.table, this.dataFileFormat, this.dataSchema, this.dataSparkType, this.dataSortOrder, this.deleteFileFormat, this.equalityFieldIds, this.equalityDeleteRowSchema, this.equalityDeleteSparkType, this.equalityDeleteSortOrder, this.positionDeleteRowSchema, this.positionDeleteSparkType, this.writeProperties);
        }
    }
}

