/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import org.apache.iceberg.IsolationLevel;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Table;
import org.apache.iceberg.spark.source.SparkScanBuilder;
import org.apache.iceberg.spark.source.SparkWriteBuilder;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connector.expressions.Expressions;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.connector.write.LogicalWriteInfo;
import org.apache.spark.sql.connector.write.RowLevelOperation;
import org.apache.spark.sql.connector.write.RowLevelOperationInfo;
import org.apache.spark.sql.connector.write.WriteBuilder;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;

class SparkCopyOnWriteOperation
implements RowLevelOperation {
    private final SparkSession spark;
    private final Table table;
    private final String branch;
    private final RowLevelOperation.Command command;
    private final IsolationLevel isolationLevel;
    private ScanBuilder lazyScanBuilder;
    private Scan configuredScan;
    private WriteBuilder lazyWriteBuilder;

    SparkCopyOnWriteOperation(SparkSession spark, Table table, String branch, RowLevelOperationInfo info, IsolationLevel isolationLevel) {
        this.spark = spark;
        this.table = table;
        this.branch = branch;
        this.command = info.command();
        this.isolationLevel = isolationLevel;
    }

    public RowLevelOperation.Command command() {
        return this.command;
    }

    public ScanBuilder newScanBuilder(CaseInsensitiveStringMap options) {
        if (this.lazyScanBuilder == null) {
            this.lazyScanBuilder = new SparkScanBuilder(this.spark, this.table, this.branch, options){

                @Override
                public Scan build() {
                    Scan scan;
                    SparkCopyOnWriteOperation.this.configuredScan = scan = super.buildCopyOnWriteScan();
                    return scan;
                }
            };
        }
        return this.lazyScanBuilder;
    }

    public WriteBuilder newWriteBuilder(LogicalWriteInfo info) {
        if (this.lazyWriteBuilder == null) {
            SparkWriteBuilder writeBuilder = new SparkWriteBuilder(this.spark, this.table, this.branch, info);
            this.lazyWriteBuilder = writeBuilder.overwriteFiles(this.configuredScan, this.command, this.isolationLevel);
        }
        return this.lazyWriteBuilder;
    }

    public NamedReference[] requiredMetadataAttributes() {
        NamedReference file = Expressions.column((String)MetadataColumns.FILE_PATH.name());
        NamedReference pos = Expressions.column((String)MetadataColumns.ROW_POSITION.name());
        if (this.command == RowLevelOperation.Command.DELETE || this.command == RowLevelOperation.Command.UPDATE) {
            return new NamedReference[]{file, pos};
        }
        return new NamedReference[]{file};
    }
}

