/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.Set;
import org.apache.iceberg.ChangelogUtil;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Partitioning;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.source.SparkMetadataColumn;
import org.apache.iceberg.spark.source.SparkScanBuilder;
import org.apache.iceberg.types.Type;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connector.catalog.MetadataColumn;
import org.apache.spark.sql.connector.catalog.SupportsMetadataColumns;
import org.apache.spark.sql.connector.catalog.SupportsRead;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;

public class SparkChangelogTable
implements org.apache.spark.sql.connector.catalog.Table,
SupportsRead,
SupportsMetadataColumns {
    public static final String TABLE_NAME = "changes";
    private static final Set<TableCapability> CAPABILITIES = ImmutableSet.of((Object)TableCapability.BATCH_READ);
    private final Table icebergTable;
    private final boolean refreshEagerly;
    private SparkSession lazySpark = null;
    private StructType lazyTableSparkType = null;
    private Schema lazyChangelogSchema = null;

    public SparkChangelogTable(Table icebergTable, boolean refreshEagerly) {
        this.icebergTable = icebergTable;
        this.refreshEagerly = refreshEagerly;
    }

    public String name() {
        return this.icebergTable.name() + ".changes";
    }

    public StructType schema() {
        if (this.lazyTableSparkType == null) {
            this.lazyTableSparkType = SparkSchemaUtil.convert(this.changelogSchema());
        }
        return this.lazyTableSparkType;
    }

    public Set<TableCapability> capabilities() {
        return CAPABILITIES;
    }

    public ScanBuilder newScanBuilder(CaseInsensitiveStringMap options) {
        if (this.refreshEagerly) {
            this.icebergTable.refresh();
        }
        return new SparkScanBuilder(this.spark(), this.icebergTable, this.changelogSchema(), options){

            @Override
            public Scan build() {
                return this.buildChangelogScan();
            }
        };
    }

    private Schema changelogSchema() {
        if (this.lazyChangelogSchema == null) {
            this.lazyChangelogSchema = ChangelogUtil.changelogSchema((Schema)this.icebergTable.schema());
        }
        return this.lazyChangelogSchema;
    }

    private SparkSession spark() {
        if (this.lazySpark == null) {
            this.lazySpark = SparkSession.active();
        }
        return this.lazySpark;
    }

    public MetadataColumn[] metadataColumns() {
        DataType sparkPartitionType = SparkSchemaUtil.convert((Type)Partitioning.partitionType((Table)this.icebergTable));
        return new MetadataColumn[]{new SparkMetadataColumn(MetadataColumns.SPEC_ID.name(), DataTypes.IntegerType, false), new SparkMetadataColumn("_partition", sparkPartitionType, true), new SparkMetadataColumn(MetadataColumns.FILE_PATH.name(), DataTypes.StringType, false), new SparkMetadataColumn(MetadataColumns.ROW_POSITION.name(), DataTypes.LongType, false), new SparkMetadataColumn(MetadataColumns.IS_DELETED.name(), DataTypes.BooleanType, false)};
    }
}

