/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import org.apache.iceberg.BaseMetadataTable;
import org.apache.iceberg.SerializableTable;
import org.apache.iceberg.Table;
import org.apache.iceberg.spark.SparkExecutorCache;
import org.apache.spark.util.KnownSizeEstimation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializableTableWithSize
extends SerializableTable
implements KnownSizeEstimation,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(SerializableTableWithSize.class);
    private static final long SIZE_ESTIMATE = 32768L;
    private final transient Object serializationMarker = new Object();

    protected SerializableTableWithSize(Table table) {
        super(table);
    }

    public long estimatedSize() {
        return 32768L;
    }

    public static Table copyOf(Table table) {
        if (table instanceof BaseMetadataTable) {
            return new SerializableMetadataTableWithSize((BaseMetadataTable)table);
        }
        return new SerializableTableWithSize(table);
    }

    @Override
    public void close() throws Exception {
        if (this.serializationMarker == null) {
            LOG.info("Releasing resources");
            this.io().close();
        }
        SerializableTableWithSize.invalidateCache(this.name());
    }

    private static void invalidateCache(String name) {
        SparkExecutorCache cache = SparkExecutorCache.get();
        if (cache != null) {
            cache.invalidate(name);
        }
    }

    public static class SerializableMetadataTableWithSize
    extends SerializableTable.SerializableMetadataTable
    implements KnownSizeEstimation,
    AutoCloseable {
        private static final Logger LOG = LoggerFactory.getLogger(SerializableMetadataTableWithSize.class);
        private final transient Object serializationMarker = new Object();

        protected SerializableMetadataTableWithSize(BaseMetadataTable metadataTable) {
            super(metadataTable);
        }

        public long estimatedSize() {
            return 32768L;
        }

        @Override
        public void close() throws Exception {
            if (this.serializationMarker == null) {
                LOG.info("Releasing resources");
                this.io().close();
            }
            SerializableTableWithSize.invalidateCache(this.name());
        }
    }
}

