/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.Map;
import java.util.stream.Stream;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.ContentScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.spark.source.BaseReader;
import org.apache.iceberg.spark.source.BaseRowReader;
import org.apache.iceberg.spark.source.SparkInputPartition;
import org.apache.iceberg.spark.source.StructInternalRow;
import org.apache.iceberg.spark.source.metrics.TaskNumDeletes;
import org.apache.iceberg.spark.source.metrics.TaskNumSplits;
import org.apache.iceberg.util.SnapshotUtil;
import org.apache.spark.rdd.InputFileBlockHolder;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.metric.CustomTaskMetric;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RowDataReader
extends BaseRowReader<FileScanTask>
implements PartitionReader<InternalRow> {
    private static final Logger LOG = LoggerFactory.getLogger(RowDataReader.class);
    private final long numSplits;

    RowDataReader(SparkInputPartition partition) {
        this(partition.table(), (ScanTaskGroup<FileScanTask>)partition.taskGroup(), SnapshotUtil.schemaFor((Table)partition.table(), (String)partition.branch()), partition.expectedSchema(), partition.isCaseSensitive());
    }

    RowDataReader(Table table, ScanTaskGroup<FileScanTask> taskGroup, Schema tableSchema, Schema expectedSchema, boolean caseSensitive) {
        super(table, taskGroup, tableSchema, expectedSchema, caseSensitive);
        this.numSplits = taskGroup.tasks().size();
        LOG.debug("Reading {} file split(s) for table {}", (Object)this.numSplits, (Object)table.name());
    }

    public CustomTaskMetric[] currentMetricsValues() {
        return new CustomTaskMetric[]{new TaskNumSplits(this.numSplits), new TaskNumDeletes(this.counter().get())};
    }

    @Override
    protected Stream<ContentFile<?>> referencedFiles(FileScanTask task) {
        return Stream.concat(Stream.of((DataFile)task.file()), task.deletes().stream());
    }

    @Override
    protected CloseableIterator<InternalRow> open(FileScanTask task) {
        String filePath = ((DataFile)task.file()).path().toString();
        LOG.debug("Opening data file {}", (Object)filePath);
        BaseReader.SparkDeleteFilter deleteFilter = new BaseReader.SparkDeleteFilter(filePath, task.deletes(), this.counter());
        Schema requiredSchema = deleteFilter.requiredSchema();
        Map<Integer, ?> idToConstant = this.constantsMap((ContentScanTask<?>)task, requiredSchema);
        InputFileBlockHolder.set((String)filePath, (long)task.start(), (long)task.length());
        return deleteFilter.filter(this.open(task, requiredSchema, idToConstant)).iterator();
    }

    protected CloseableIterable<InternalRow> open(FileScanTask task, Schema readSchema, Map<Integer, ?> idToConstant) {
        if (task.isDataTask()) {
            return this.newDataIterable(task.asDataTask(), readSchema);
        }
        InputFile inputFile = this.getInputFile(((DataFile)task.file()).path().toString());
        Preconditions.checkNotNull((Object)inputFile, (Object)"Could not find InputFile associated with FileScanTask");
        return this.newIterable(inputFile, ((DataFile)task.file()).format(), task.start(), task.length(), task.residual(), readSchema, idToConstant);
    }

    private CloseableIterable<InternalRow> newDataIterable(DataTask task, Schema readSchema) {
        StructInternalRow row = new StructInternalRow(readSchema.asStruct());
        return CloseableIterable.transform((CloseableIterable)task.asDataTask().rows(), row::setStruct);
    }
}

