/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.procedures;

import java.util.Optional;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.spark.procedures.BaseProcedure;
import org.apache.iceberg.spark.procedures.SparkProcedures;
import org.apache.iceberg.util.WapUtil;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.iceberg.catalog.ProcedureParameter;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

class PublishChangesProcedure
extends BaseProcedure {
    private static final ProcedureParameter[] PARAMETERS = new ProcedureParameter[]{ProcedureParameter.required("table", DataTypes.StringType), ProcedureParameter.required("wap_id", DataTypes.StringType)};
    private static final StructType OUTPUT_TYPE = new StructType(new StructField[]{new StructField("source_snapshot_id", DataTypes.LongType, false, Metadata.empty()), new StructField("current_snapshot_id", DataTypes.LongType, false, Metadata.empty())});

    public static SparkProcedures.ProcedureBuilder builder() {
        return new BaseProcedure.Builder<PublishChangesProcedure>(){

            @Override
            protected PublishChangesProcedure doBuild() {
                return new PublishChangesProcedure(this.tableCatalog());
            }
        };
    }

    private PublishChangesProcedure(TableCatalog catalog) {
        super(catalog);
    }

    @Override
    public ProcedureParameter[] parameters() {
        return PARAMETERS;
    }

    @Override
    public StructType outputType() {
        return OUTPUT_TYPE;
    }

    @Override
    public InternalRow[] call(InternalRow args) {
        Identifier tableIdent = this.toIdentifier(args.getString(0), PARAMETERS[0].name());
        String wapId = args.getString(1);
        return this.modifyIcebergTable(tableIdent, table -> {
            Optional<Snapshot> wapSnapshot = Optional.ofNullable((Snapshot)Iterables.find((Iterable)table.snapshots(), snapshot -> wapId.equals(WapUtil.stagedWapId((Snapshot)snapshot)), null));
            if (!wapSnapshot.isPresent()) {
                throw new ValidationException(String.format("Cannot apply unknown WAP ID '%s'", wapId), new Object[0]);
            }
            long wapSnapshotId = wapSnapshot.get().snapshotId();
            table.manageSnapshots().cherrypick(wapSnapshotId).commit();
            Snapshot currentSnapshot = table.currentSnapshot();
            InternalRow outputRow = this.newInternalRow(wapSnapshotId, currentSnapshot.snapshotId());
            return new InternalRow[]{outputRow};
        });
    }

    @Override
    public String description() {
        return "ApplyWapChangesProcedure";
    }
}

