/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.functions;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Set;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.spark.functions.BaseScalarFunction;
import org.apache.iceberg.util.BinaryUtil;
import org.apache.iceberg.util.ByteBuffers;
import org.apache.iceberg.util.TruncateUtil;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.functions.BoundFunction;
import org.apache.spark.sql.connector.catalog.functions.UnboundFunction;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;

public class TruncateFunction
implements UnboundFunction {
    private static final int WIDTH_ORDINAL = 0;
    private static final int VALUE_ORDINAL = 1;
    private static final Set<DataType> SUPPORTED_WIDTH_TYPES = ImmutableSet.of((Object)DataTypes.ByteType, (Object)DataTypes.ShortType, (Object)DataTypes.IntegerType);

    public BoundFunction bind(StructType inputType) {
        if (inputType.size() != 2) {
            throw new UnsupportedOperationException("Wrong number of inputs (expected width and value)");
        }
        StructField widthField = inputType.fields()[0];
        StructField valueField = inputType.fields()[1];
        if (!SUPPORTED_WIDTH_TYPES.contains(widthField.dataType())) {
            throw new UnsupportedOperationException("Expected truncation width to be tinyint, shortint or int");
        }
        DataType valueType = valueField.dataType();
        if (valueType instanceof ByteType) {
            return new TruncateTinyInt();
        }
        if (valueType instanceof ShortType) {
            return new TruncateSmallInt();
        }
        if (valueType instanceof IntegerType) {
            return new TruncateInt();
        }
        if (valueType instanceof LongType) {
            return new TruncateBigInt();
        }
        if (valueType instanceof DecimalType) {
            return new TruncateDecimal(((DecimalType)valueType).precision(), ((DecimalType)valueType).scale());
        }
        if (valueType instanceof StringType) {
            return new TruncateString();
        }
        if (valueType instanceof BinaryType) {
            return new TruncateBinary();
        }
        throw new UnsupportedOperationException("Expected truncation col to be tinyint, shortint, int, bigint, decimal, string, or binary");
    }

    public String description() {
        return this.name() + "(width, col) - Call Iceberg's truncate transform\n  width :: width for truncation, e.g. truncate(10, 255) -> 250 (must be an integer)\n  col :: column to truncate (must be an integer, decimal, string, or binary)";
    }

    public String name() {
        return "truncate";
    }

    public static class TruncateDecimal
    extends TruncateBase<Decimal> {
        private final int precision;
        private final int scale;

        public TruncateDecimal(int precision, int scale) {
            this.precision = precision;
            this.scale = scale;
        }

        public static Decimal invoke(int width, Decimal value) {
            if (value == null) {
                return null;
            }
            return Decimal.apply((BigDecimal)TruncateUtil.truncateDecimal((BigInteger)BigInteger.valueOf(width), (BigDecimal)value.toJavaBigDecimal()));
        }

        public DataType[] inputTypes() {
            return new DataType[]{DataTypes.IntegerType, DataTypes.createDecimalType((int)this.precision, (int)this.scale)};
        }

        public DataType resultType() {
            return DataTypes.createDecimalType((int)this.precision, (int)this.scale);
        }

        public String canonicalName() {
            return String.format("iceberg.truncate(decimal(%d,%d))", this.precision, this.scale);
        }

        public Decimal produceResult(InternalRow input) {
            if (input.isNullAt(0) || input.isNullAt(1)) {
                return null;
            }
            int width = input.getInt(0);
            Decimal value = input.getDecimal(1, this.precision, this.scale);
            return TruncateDecimal.invoke(width, value);
        }
    }

    public static class TruncateBinary
    extends TruncateBase<byte[]> {
        public static byte[] invoke(int width, byte[] value) {
            if (value == null) {
                return null;
            }
            return ByteBuffers.toByteArray((ByteBuffer)BinaryUtil.truncateBinaryUnsafe((ByteBuffer)ByteBuffer.wrap(value), (int)width));
        }

        public DataType[] inputTypes() {
            return new DataType[]{DataTypes.IntegerType, DataTypes.BinaryType};
        }

        public DataType resultType() {
            return DataTypes.BinaryType;
        }

        public String canonicalName() {
            return "iceberg.truncate(binary)";
        }

        public byte[] produceResult(InternalRow input) {
            if (input.isNullAt(0) || input.isNullAt(1)) {
                return null;
            }
            return TruncateBinary.invoke(input.getInt(0), input.getBinary(1));
        }
    }

    public static class TruncateString
    extends TruncateBase<UTF8String> {
        public static UTF8String invoke(int width, UTF8String value) {
            if (value == null) {
                return null;
            }
            return value.substring(0, width);
        }

        public DataType[] inputTypes() {
            return new DataType[]{DataTypes.IntegerType, DataTypes.StringType};
        }

        public DataType resultType() {
            return DataTypes.StringType;
        }

        public String canonicalName() {
            return "iceberg.truncate(string)";
        }

        public UTF8String produceResult(InternalRow input) {
            if (input.isNullAt(0) || input.isNullAt(1)) {
                return null;
            }
            return TruncateString.invoke(input.getInt(0), input.getUTF8String(1));
        }
    }

    public static class TruncateBigInt
    extends TruncateBase<Long> {
        public static long invoke(int width, long value) {
            return TruncateUtil.truncateLong((int)width, (long)value);
        }

        public DataType[] inputTypes() {
            return new DataType[]{DataTypes.IntegerType, DataTypes.LongType};
        }

        public DataType resultType() {
            return DataTypes.LongType;
        }

        public String canonicalName() {
            return "iceberg.truncate(bigint)";
        }

        public Long produceResult(InternalRow input) {
            if (input.isNullAt(0) || input.isNullAt(1)) {
                return null;
            }
            return TruncateBigInt.invoke(input.getInt(0), input.getLong(1));
        }
    }

    public static class TruncateInt
    extends TruncateBase<Integer> {
        public static int invoke(int width, int value) {
            return TruncateUtil.truncateInt((int)width, (int)value);
        }

        public DataType[] inputTypes() {
            return new DataType[]{DataTypes.IntegerType, DataTypes.IntegerType};
        }

        public DataType resultType() {
            return DataTypes.IntegerType;
        }

        public String canonicalName() {
            return "iceberg.truncate(int)";
        }

        public Integer produceResult(InternalRow input) {
            if (input.isNullAt(0) || input.isNullAt(1)) {
                return null;
            }
            return TruncateInt.invoke(input.getInt(0), input.getInt(1));
        }
    }

    public static class TruncateSmallInt
    extends TruncateBase<Short> {
        public static short invoke(int width, short value) {
            return TruncateUtil.truncateShort((int)width, (short)value);
        }

        public DataType[] inputTypes() {
            return new DataType[]{DataTypes.IntegerType, DataTypes.ShortType};
        }

        public DataType resultType() {
            return DataTypes.ShortType;
        }

        public String canonicalName() {
            return "iceberg.truncate(smallint)";
        }

        public Short produceResult(InternalRow input) {
            if (input.isNullAt(0) || input.isNullAt(1)) {
                return null;
            }
            return TruncateSmallInt.invoke(input.getInt(0), input.getShort(1));
        }
    }

    public static class TruncateTinyInt
    extends TruncateBase<Byte> {
        public static byte invoke(int width, byte value) {
            return TruncateUtil.truncateByte((int)width, (byte)value);
        }

        public DataType[] inputTypes() {
            return new DataType[]{DataTypes.IntegerType, DataTypes.ByteType};
        }

        public DataType resultType() {
            return DataTypes.ByteType;
        }

        public String canonicalName() {
            return "iceberg.truncate(tinyint)";
        }

        public Byte produceResult(InternalRow input) {
            if (input.isNullAt(0) || input.isNullAt(1)) {
                return null;
            }
            return TruncateTinyInt.invoke(input.getInt(0), input.getByte(1));
        }
    }

    public static abstract class TruncateBase<T>
    extends BaseScalarFunction<T> {
        public String name() {
            return "truncate";
        }
    }
}

