/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.functions;

import org.apache.iceberg.spark.functions.BaseScalarFunction;
import org.apache.iceberg.spark.functions.UnaryUnboundFunction;
import org.apache.iceberg.util.DateTimeUtil;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.functions.BoundFunction;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.TimestampNTZType;
import org.apache.spark.sql.types.TimestampType;

public class HoursFunction
extends UnaryUnboundFunction {
    @Override
    protected BoundFunction doBind(DataType valueType) {
        if (valueType instanceof TimestampType) {
            return new TimestampToHoursFunction();
        }
        if (valueType instanceof TimestampNTZType) {
            return new TimestampNtzToHoursFunction();
        }
        throw new UnsupportedOperationException("Expected value to be timestamp: " + valueType.catalogString());
    }

    public String description() {
        return this.name() + "(col) - Call Iceberg's hour transform\n  col :: source column (must be timestamp)";
    }

    public String name() {
        return "hours";
    }

    public static class TimestampNtzToHoursFunction
    extends BaseScalarFunction<Integer> {
        public static int invoke(long micros) {
            return DateTimeUtil.microsToHours((long)micros);
        }

        public String name() {
            return "hours";
        }

        public DataType[] inputTypes() {
            return new DataType[]{DataTypes.TimestampNTZType};
        }

        public DataType resultType() {
            return DataTypes.IntegerType;
        }

        public String canonicalName() {
            return "iceberg.hours(timestamp_ntz)";
        }

        public Integer produceResult(InternalRow input) {
            return input.isNullAt(0) ? null : Integer.valueOf(TimestampNtzToHoursFunction.invoke(input.getLong(0)));
        }
    }

    public static class TimestampToHoursFunction
    extends BaseScalarFunction<Integer> {
        public static int invoke(long micros) {
            return DateTimeUtil.microsToHours((long)micros);
        }

        public String name() {
            return "hours";
        }

        public DataType[] inputTypes() {
            return new DataType[]{DataTypes.TimestampType};
        }

        public DataType resultType() {
            return DataTypes.IntegerType;
        }

        public String canonicalName() {
            return "iceberg.hours(timestamp)";
        }

        public Integer produceResult(InternalRow input) {
            return input.isNullAt(0) ? null : Integer.valueOf(TimestampToHoursFunction.invoke(input.getLong(0)));
        }
    }
}

