/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.functions;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Set;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.spark.functions.BaseScalarFunction;
import org.apache.iceberg.util.BucketUtil;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.functions.BoundFunction;
import org.apache.spark.sql.connector.catalog.functions.UnboundFunction;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.unsafe.types.UTF8String;

public class BucketFunction
implements UnboundFunction {
    private static final int NUM_BUCKETS_ORDINAL = 0;
    private static final int VALUE_ORDINAL = 1;
    private static final Set<DataType> SUPPORTED_NUM_BUCKETS_TYPES = ImmutableSet.of((Object)DataTypes.ByteType, (Object)DataTypes.ShortType, (Object)DataTypes.IntegerType);

    public BoundFunction bind(StructType inputType) {
        if (inputType.size() != 2) {
            throw new UnsupportedOperationException("Wrong number of inputs (expected numBuckets and value)");
        }
        StructField numBucketsField = inputType.fields()[0];
        StructField valueField = inputType.fields()[1];
        if (!SUPPORTED_NUM_BUCKETS_TYPES.contains(numBucketsField.dataType())) {
            throw new UnsupportedOperationException("Expected number of buckets to be tinyint, shortint or int");
        }
        DataType type = valueField.dataType();
        if (type instanceof DateType) {
            return new BucketInt(type);
        }
        if (type instanceof ByteType || type instanceof ShortType || type instanceof IntegerType) {
            return new BucketInt(DataTypes.IntegerType);
        }
        if (type instanceof LongType) {
            return new BucketLong(type);
        }
        if (type instanceof TimestampType) {
            return new BucketLong(type);
        }
        if (type instanceof TimestampNTZType) {
            return new BucketLong(type);
        }
        if (type instanceof DecimalType) {
            return new BucketDecimal(type);
        }
        if (type instanceof StringType) {
            return new BucketString();
        }
        if (type instanceof BinaryType) {
            return new BucketBinary();
        }
        throw new UnsupportedOperationException("Expected column to be date, tinyint, smallint, int, bigint, decimal, timestamp, string, or binary");
    }

    public String description() {
        return this.name() + "(numBuckets, col) - Call Iceberg's bucket transform\n  numBuckets :: number of buckets to divide the rows into, e.g. bucket(100, 34) -> 79 (must be a tinyint, smallint, or int)\n  col :: column to bucket (must be a date, integer, long, timestamp, decimal, string, or binary)";
    }

    public String name() {
        return "bucket";
    }

    public static class BucketDecimal
    extends BucketBase {
        private final DataType sqlType;
        private final int precision;
        private final int scale;

        public static Integer invoke(int numBuckets, Decimal value) {
            if (value == null) {
                return null;
            }
            return BucketDecimal.apply(numBuckets, BucketDecimal.hash(value.toJavaBigDecimal()));
        }

        public static int hash(BigDecimal value) {
            return BucketUtil.hash((BigDecimal)value);
        }

        public BucketDecimal(DataType sqlType) {
            this.sqlType = sqlType;
            this.precision = ((DecimalType)sqlType).precision();
            this.scale = ((DecimalType)sqlType).scale();
        }

        public DataType[] inputTypes() {
            return new DataType[]{DataTypes.IntegerType, this.sqlType};
        }

        public Integer produceResult(InternalRow input) {
            if (input.isNullAt(0) || input.isNullAt(1)) {
                return null;
            }
            int numBuckets = input.getInt(0);
            Decimal value = input.getDecimal(1, this.precision, this.scale);
            return BucketDecimal.invoke(numBuckets, value);
        }

        public String canonicalName() {
            return "iceberg.bucket(decimal)";
        }
    }

    public static class BucketBinary
    extends BucketBase {
        public static Integer invoke(int numBuckets, byte[] value) {
            if (value == null) {
                return null;
            }
            return BucketBinary.apply(numBuckets, BucketBinary.hash(ByteBuffer.wrap(value)));
        }

        public static int hash(ByteBuffer value) {
            return BucketUtil.hash((ByteBuffer)value);
        }

        public DataType[] inputTypes() {
            return new DataType[]{DataTypes.IntegerType, DataTypes.BinaryType};
        }

        public Integer produceResult(InternalRow input) {
            if (input.isNullAt(0) || input.isNullAt(1)) {
                return null;
            }
            return BucketBinary.invoke(input.getInt(0), input.getBinary(1));
        }

        public String canonicalName() {
            return "iceberg.bucket(binary)";
        }
    }

    public static class BucketString
    extends BucketBase {
        public static Integer invoke(int numBuckets, UTF8String value) {
            if (value == null) {
                return null;
            }
            return BucketString.apply(numBuckets, BucketString.hash(value.toString()));
        }

        public static int hash(String value) {
            return BucketUtil.hash((CharSequence)value);
        }

        public DataType[] inputTypes() {
            return new DataType[]{DataTypes.IntegerType, DataTypes.StringType};
        }

        public String canonicalName() {
            return "iceberg.bucket(string)";
        }

        public Integer produceResult(InternalRow input) {
            if (input.isNullAt(0) || input.isNullAt(1)) {
                return null;
            }
            return BucketString.invoke(input.getInt(0), input.getUTF8String(1));
        }
    }

    public static class BucketLong
    extends BucketBase {
        private final DataType sqlType;

        public static int invoke(int numBuckets, long value) {
            return BucketLong.apply(numBuckets, BucketLong.hash(value));
        }

        public static int hash(long value) {
            return BucketUtil.hash((long)value);
        }

        public BucketLong(DataType sqlType) {
            this.sqlType = sqlType;
        }

        public DataType[] inputTypes() {
            return new DataType[]{DataTypes.IntegerType, this.sqlType};
        }

        public String canonicalName() {
            return String.format("iceberg.bucket(%s)", this.sqlType.catalogString());
        }

        public Integer produceResult(InternalRow input) {
            if (input.isNullAt(0) || input.isNullAt(1)) {
                return null;
            }
            return BucketLong.invoke(input.getInt(0), input.getLong(1));
        }
    }

    public static class BucketInt
    extends BucketBase {
        private final DataType sqlType;

        public static int invoke(int numBuckets, int value) {
            return BucketInt.apply(numBuckets, BucketInt.hash(value));
        }

        public static int hash(int value) {
            return BucketUtil.hash((int)value);
        }

        public BucketInt(DataType sqlType) {
            this.sqlType = sqlType;
        }

        public DataType[] inputTypes() {
            return new DataType[]{DataTypes.IntegerType, this.sqlType};
        }

        public String canonicalName() {
            return String.format("iceberg.bucket(%s)", this.sqlType.catalogString());
        }

        public Integer produceResult(InternalRow input) {
            if (input.isNullAt(0) || input.isNullAt(1)) {
                return null;
            }
            return BucketInt.invoke(input.getInt(0), input.getInt(1));
        }
    }

    public static abstract class BucketBase
    extends BaseScalarFunction<Integer> {
        public static int apply(int numBuckets, int hashedValue) {
            return (hashedValue & Integer.MAX_VALUE) % numBuckets;
        }

        public String name() {
            return "bucket";
        }

        public DataType resultType() {
            return DataTypes.IntegerType;
        }
    }
}

