/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.actions;

import org.apache.iceberg.Table;
import org.apache.iceberg.actions.ActionsProvider;
import org.apache.iceberg.actions.ComputeTableStats;
import org.apache.iceberg.actions.RemoveDanglingDeleteFiles;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.iceberg.spark.actions.ComputeTableStatsSparkAction;
import org.apache.iceberg.spark.actions.DeleteOrphanFilesSparkAction;
import org.apache.iceberg.spark.actions.DeleteReachableFilesSparkAction;
import org.apache.iceberg.spark.actions.ExpireSnapshotsSparkAction;
import org.apache.iceberg.spark.actions.MigrateTableSparkAction;
import org.apache.iceberg.spark.actions.RemoveDanglingDeletesSparkAction;
import org.apache.iceberg.spark.actions.RewriteDataFilesSparkAction;
import org.apache.iceberg.spark.actions.RewriteManifestsSparkAction;
import org.apache.iceberg.spark.actions.RewritePositionDeleteFilesSparkAction;
import org.apache.iceberg.spark.actions.SnapshotTableSparkAction;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;

public class SparkActions
implements ActionsProvider {
    private final SparkSession spark;

    private SparkActions(SparkSession spark) {
        this.spark = spark;
    }

    public static SparkActions get(SparkSession spark) {
        return new SparkActions(spark);
    }

    public static SparkActions get() {
        return new SparkActions(SparkSession.active());
    }

    public SnapshotTableSparkAction snapshotTable(String tableIdent) {
        String ctx = "snapshot source";
        CatalogPlugin defaultCatalog = this.spark.sessionState().catalogManager().currentCatalog();
        Spark3Util.CatalogAndIdentifier catalogAndIdent = Spark3Util.catalogAndIdentifier(ctx, this.spark, tableIdent, defaultCatalog);
        return new SnapshotTableSparkAction(this.spark, catalogAndIdent.catalog(), catalogAndIdent.identifier());
    }

    public MigrateTableSparkAction migrateTable(String tableIdent) {
        String ctx = "migrate target";
        CatalogPlugin defaultCatalog = this.spark.sessionState().catalogManager().currentCatalog();
        Spark3Util.CatalogAndIdentifier catalogAndIdent = Spark3Util.catalogAndIdentifier(ctx, this.spark, tableIdent, defaultCatalog);
        return new MigrateTableSparkAction(this.spark, catalogAndIdent.catalog(), catalogAndIdent.identifier());
    }

    public RewriteDataFilesSparkAction rewriteDataFiles(Table table) {
        return new RewriteDataFilesSparkAction(this.spark, table);
    }

    public DeleteOrphanFilesSparkAction deleteOrphanFiles(Table table) {
        return new DeleteOrphanFilesSparkAction(this.spark, table);
    }

    public RewriteManifestsSparkAction rewriteManifests(Table table) {
        return new RewriteManifestsSparkAction(this.spark, table);
    }

    public ExpireSnapshotsSparkAction expireSnapshots(Table table) {
        return new ExpireSnapshotsSparkAction(this.spark, table);
    }

    public DeleteReachableFilesSparkAction deleteReachableFiles(String metadataLocation) {
        return new DeleteReachableFilesSparkAction(this.spark, metadataLocation);
    }

    public RewritePositionDeleteFilesSparkAction rewritePositionDeletes(Table table) {
        return new RewritePositionDeleteFilesSparkAction(this.spark, table);
    }

    public ComputeTableStats computeTableStats(Table table) {
        return new ComputeTableStatsSparkAction(this.spark, table);
    }

    public RemoveDanglingDeleteFiles removeDanglingDeleteFiles(Table table) {
        return new RemoveDanglingDeletesSparkAction(this.spark, table);
    }
}

