/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.actions;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.Sketch;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.puffin.Blob;
import org.apache.iceberg.puffin.PuffinCompressionCodec;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.SparkTableUtil;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.stats.ThetaSketchAgg;

public class NDVSketchUtil {
    public static final String APACHE_DATASKETCHES_THETA_V1_NDV_PROPERTY = "ndv";

    private NDVSketchUtil() {
    }

    static List<Blob> generateBlobs(SparkSession spark, Table table, Snapshot snapshot, List<String> columns) {
        Row sketches = NDVSketchUtil.computeNDVSketches(spark, table, snapshot, columns);
        Schema schema = (Schema)table.schemas().get(snapshot.schemaId());
        ArrayList blobs = Lists.newArrayList();
        for (int i = 0; i < columns.size(); ++i) {
            Types.NestedField field = schema.findField(columns.get(i));
            CompactSketch sketch = CompactSketch.wrap((Memory)Memory.wrap((byte[])((byte[])sketches.get(i))));
            blobs.add(NDVSketchUtil.toBlob(field, (Sketch)sketch, snapshot));
        }
        return blobs;
    }

    private static Blob toBlob(Types.NestedField field, Sketch sketch, Snapshot snapshot) {
        return new Blob("apache-datasketches-theta-v1", (List)ImmutableList.of((Object)field.fieldId()), snapshot.snapshotId(), snapshot.sequenceNumber(), ByteBuffer.wrap(sketch.toByteArray()), PuffinCompressionCodec.ZSTD, (Map)ImmutableMap.of((Object)APACHE_DATASKETCHES_THETA_V1_NDV_PROPERTY, (Object)String.valueOf((long)sketch.getEstimate())));
    }

    private static Row computeNDVSketches(SparkSession spark, Table table, Snapshot snapshot, List<String> colNames) {
        Dataset<Row> inputDF = SparkTableUtil.loadTable(spark, table, snapshot.snapshotId());
        return (Row)inputDF.select(NDVSketchUtil.toAggColumns(colNames)).first();
    }

    private static Column[] toAggColumns(List<String> colNames) {
        return (Column[])colNames.stream().map(NDVSketchUtil::toAggColumn).toArray(Column[]::new);
    }

    private static Column toAggColumn(String colName) {
        ThetaSketchAgg agg = new ThetaSketchAgg(colName);
        return new Column((Expression)agg.toAggregateExpression());
    }
}

