/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.actions;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.iceberg.GenericBlobMetadata;
import org.apache.iceberg.GenericStatisticsFile;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.IcebergBuild;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StatisticsFile;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.actions.ComputeTableStats;
import org.apache.iceberg.actions.ImmutableComputeTableStats;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.puffin.Blob;
import org.apache.iceberg.puffin.Puffin;
import org.apache.iceberg.puffin.PuffinWriter;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.spark.JobGroupInfo;
import org.apache.iceberg.spark.actions.BaseSparkAction;
import org.apache.iceberg.spark.actions.NDVSketchUtil;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputeTableStatsSparkAction
extends BaseSparkAction<ComputeTableStatsSparkAction>
implements ComputeTableStats {
    private static final Logger LOG = LoggerFactory.getLogger(ComputeTableStatsSparkAction.class);
    private static final ComputeTableStats.Result EMPTY_RESULT = ImmutableComputeTableStats.Result.builder().build();
    private final Table table;
    private List<String> columns;
    private Snapshot snapshot;

    ComputeTableStatsSparkAction(SparkSession spark, Table table) {
        super(spark);
        this.table = table;
        this.snapshot = table.currentSnapshot();
    }

    @Override
    protected ComputeTableStatsSparkAction self() {
        return this;
    }

    public ComputeTableStats columns(String ... newColumns) {
        Preconditions.checkArgument((newColumns != null && newColumns.length > 0 ? 1 : 0) != 0, (Object)"Columns cannot be null/empty");
        this.columns = ImmutableList.copyOf((Collection)ImmutableSet.copyOf((Object[])newColumns));
        return this;
    }

    public ComputeTableStats snapshot(long newSnapshotId) {
        Snapshot newSnapshot = this.table.snapshot(newSnapshotId);
        Preconditions.checkArgument((newSnapshot != null ? 1 : 0) != 0, (String)"Snapshot not found: %s", (long)newSnapshotId);
        this.snapshot = newSnapshot;
        return this;
    }

    public ComputeTableStats.Result execute() {
        if (this.snapshot == null) {
            LOG.info("No snapshot to compute stats for table {}", (Object)this.table.name());
            return EMPTY_RESULT;
        }
        this.validateColumns();
        JobGroupInfo info = this.newJobGroupInfo("COMPUTE-TABLE-STATS", this.jobDesc());
        return this.withJobGroupInfo(info, this::doExecute);
    }

    private ComputeTableStats.Result doExecute() {
        LOG.info("Computing stats for columns {} in {} (snapshot {})", new Object[]{this.columns(), this.table.name(), this.snapshotId()});
        List<Blob> blobs = this.generateNDVBlobs();
        StatisticsFile statisticsFile = this.writeStatsFile(blobs);
        this.table.updateStatistics().setStatistics(this.snapshotId(), statisticsFile).commit();
        return ImmutableComputeTableStats.Result.builder().statisticsFile(statisticsFile).build();
    }

    private StatisticsFile writeStatsFile(List<Blob> blobs) {
        GenericStatisticsFile genericStatisticsFile;
        block8: {
            LOG.info("Writing stats for table {} for snapshot {}", (Object)this.table.name(), (Object)this.snapshotId());
            OutputFile outputFile = this.table.io().newOutputFile(this.outputPath());
            PuffinWriter writer = Puffin.write((OutputFile)outputFile).createdBy(this.appIdentifier()).build();
            try {
                blobs.forEach(arg_0 -> ((PuffinWriter)writer).add(arg_0));
                writer.finish();
                genericStatisticsFile = new GenericStatisticsFile(this.snapshotId(), outputFile.location(), writer.fileSize(), writer.footerSize(), GenericBlobMetadata.from((Collection)writer.writtenBlobsMetadata()));
                if (writer == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e);
                }
            }
            writer.close();
        }
        return genericStatisticsFile;
    }

    private List<Blob> generateNDVBlobs() {
        return NDVSketchUtil.generateBlobs(this.spark(), this.table, this.snapshot, this.columns());
    }

    private List<String> columns() {
        if (this.columns == null) {
            Schema schema = (Schema)this.table.schemas().get(this.snapshot.schemaId());
            this.columns = schema.columns().stream().filter(nestedField -> nestedField.type().isPrimitiveType()).map(Types.NestedField::name).collect(Collectors.toList());
        }
        return this.columns;
    }

    private void validateColumns() {
        Schema schema = (Schema)this.table.schemas().get(this.snapshot.schemaId());
        Preconditions.checkArgument((!this.columns().isEmpty() ? 1 : 0) != 0, (Object)"No columns found to compute stats");
        for (String columnName : this.columns()) {
            Types.NestedField field = schema.findField(columnName);
            Preconditions.checkArgument((field != null ? 1 : 0) != 0, (String)"Can't find column %s in %s", (Object)columnName, (Object)schema);
            Preconditions.checkArgument((boolean)field.type().isPrimitiveType(), (String)"Can't compute stats on non-primitive type column: %s (%s)", (Object)columnName, (Object)field.type());
        }
    }

    private String appIdentifier() {
        String icebergVersion = IcebergBuild.fullVersion();
        String sparkVersion = this.spark().version();
        return String.format("Iceberg %s Spark %s", icebergVersion, sparkVersion);
    }

    private long snapshotId() {
        return this.snapshot.snapshotId();
    }

    private String jobDesc() {
        return String.format("Computing table stats for %s (snapshot_id=%s, columns=%s)", this.table.name(), this.snapshotId(), this.columns());
    }

    private String outputPath() {
        TableOperations operations = ((HasTableOperations)this.table).operations();
        String fileName = String.format("%s-%s.stats", this.snapshotId(), UUID.randomUUID());
        return operations.metadataFileLocation(fileName);
    }
}

