/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import org.apache.iceberg.spark.functions.SparkFunctions;
import org.apache.spark.sql.catalyst.analysis.NoSuchFunctionException;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.connector.catalog.FunctionCatalog;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.functions.UnboundFunction;
import scala.Option;

interface SupportsFunctions
extends FunctionCatalog {
    default public boolean isFunctionNamespace(String[] namespace) {
        return namespace.length == 0;
    }

    default public boolean isExistingNamespace(String[] namespace) {
        return namespace.length == 0;
    }

    default public Identifier[] listFunctions(String[] namespace) throws NoSuchNamespaceException {
        if (this.isFunctionNamespace(namespace)) {
            return (Identifier[])SparkFunctions.list().stream().map(name -> Identifier.of((String[])namespace, (String)name)).toArray(Identifier[]::new);
        }
        if (this.isExistingNamespace(namespace)) {
            return new Identifier[0];
        }
        throw new NoSuchNamespaceException(namespace);
    }

    default public UnboundFunction loadFunction(Identifier ident) throws NoSuchFunctionException {
        UnboundFunction func;
        String[] namespace = ident.namespace();
        String name = ident.name();
        if (this.isFunctionNamespace(namespace) && (func = SparkFunctions.load(name)) != null) {
            return func;
        }
        throw new NoSuchFunctionException(String.format("Cannot load function: %s.%s", this.name(), ident), Option.empty());
    }
}

