/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.util.Arrays;
import org.apache.iceberg.DistributionMode;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.collect.ObjectArrays;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.iceberg.spark.SparkWriteRequirements;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.SortOrderUtil;
import org.apache.spark.sql.connector.distributions.Distribution;
import org.apache.spark.sql.connector.distributions.Distributions;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.Expressions;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.SortDirection;
import org.apache.spark.sql.connector.expressions.SortOrder;
import org.apache.spark.sql.connector.write.RowLevelOperation;

public class SparkWriteUtil {
    private static final NamedReference SPEC_ID = SparkWriteUtil.ref(MetadataColumns.SPEC_ID);
    private static final NamedReference PARTITION = SparkWriteUtil.ref("_partition");
    private static final NamedReference FILE_PATH = SparkWriteUtil.ref(MetadataColumns.FILE_PATH);
    private static final NamedReference ROW_POSITION = SparkWriteUtil.ref(MetadataColumns.ROW_POSITION);
    private static final Expression[] FILE_CLUSTERING = SparkWriteUtil.clusterBy(new Expression[]{FILE_PATH});
    private static final Expression[] PARTITION_CLUSTERING = SparkWriteUtil.clusterBy(new Expression[]{SPEC_ID, PARTITION});
    private static final Expression[] PARTITION_FILE_CLUSTERING = SparkWriteUtil.clusterBy(new Expression[]{SPEC_ID, PARTITION, FILE_PATH});
    private static final SortOrder[] EMPTY_ORDERING = new SortOrder[0];
    private static final SortOrder[] EXISTING_ROW_ORDERING = SparkWriteUtil.orderBy(new Expression[]{FILE_PATH, ROW_POSITION});
    private static final SortOrder[] PARTITION_ORDERING = SparkWriteUtil.orderBy(new Expression[]{SPEC_ID, PARTITION});
    private static final SortOrder[] PARTITION_FILE_ORDERING = SparkWriteUtil.orderBy(new Expression[]{SPEC_ID, PARTITION, FILE_PATH});
    private static final SortOrder[] POSITION_DELETE_ORDERING = SparkWriteUtil.orderBy(new Expression[]{SPEC_ID, PARTITION, FILE_PATH, ROW_POSITION});

    private SparkWriteUtil() {
    }

    public static SparkWriteRequirements writeRequirements(Table table, DistributionMode mode, boolean fanoutEnabled) {
        Distribution distribution = SparkWriteUtil.writeDistribution(table, mode);
        SortOrder[] ordering = SparkWriteUtil.writeOrdering(table, fanoutEnabled);
        return new SparkWriteRequirements(distribution, ordering);
    }

    private static Distribution writeDistribution(Table table, DistributionMode mode) {
        switch (mode) {
            case NONE: {
                return Distributions.unspecified();
            }
            case HASH: {
                return Distributions.clustered((Expression[])SparkWriteUtil.clustering(table));
            }
            case RANGE: {
                return Distributions.ordered((SortOrder[])SparkWriteUtil.ordering(table));
            }
        }
        throw new IllegalArgumentException("Unsupported distribution mode: " + mode);
    }

    public static SparkWriteRequirements copyOnWriteRequirements(Table table, RowLevelOperation.Command command, DistributionMode mode, boolean fanoutEnabled) {
        if (command == RowLevelOperation.Command.DELETE || command == RowLevelOperation.Command.UPDATE) {
            Distribution distribution = SparkWriteUtil.copyOnWriteDeleteUpdateDistribution(table, mode);
            SortOrder[] ordering = SparkWriteUtil.writeOrdering(table, fanoutEnabled);
            return new SparkWriteRequirements(distribution, ordering);
        }
        return SparkWriteUtil.writeRequirements(table, mode, fanoutEnabled);
    }

    private static Distribution copyOnWriteDeleteUpdateDistribution(Table table, DistributionMode mode) {
        switch (mode) {
            case NONE: {
                return Distributions.unspecified();
            }
            case HASH: {
                if (table.spec().isPartitioned()) {
                    return Distributions.clustered((Expression[])SparkWriteUtil.clustering(table));
                }
                return Distributions.clustered((Expression[])FILE_CLUSTERING);
            }
            case RANGE: {
                if (table.spec().isPartitioned() || table.sortOrder().isSorted()) {
                    return Distributions.ordered((SortOrder[])SparkWriteUtil.ordering(table));
                }
                return Distributions.ordered((SortOrder[])EXISTING_ROW_ORDERING);
            }
        }
        throw new IllegalArgumentException("Unexpected distribution mode: " + mode);
    }

    public static SparkWriteRequirements positionDeltaRequirements(Table table, RowLevelOperation.Command command, DistributionMode mode, boolean fanoutEnabled) {
        if (command == RowLevelOperation.Command.UPDATE || command == RowLevelOperation.Command.MERGE) {
            Distribution distribution = SparkWriteUtil.positionDeltaUpdateMergeDistribution(table, mode);
            SortOrder[] ordering = SparkWriteUtil.positionDeltaUpdateMergeOrdering(table, fanoutEnabled);
            return new SparkWriteRequirements(distribution, ordering);
        }
        Distribution distribution = SparkWriteUtil.positionDeltaDeleteDistribution(table, mode);
        SortOrder[] ordering = fanoutEnabled ? EMPTY_ORDERING : POSITION_DELETE_ORDERING;
        return new SparkWriteRequirements(distribution, ordering);
    }

    private static Distribution positionDeltaUpdateMergeDistribution(Table table, DistributionMode mode) {
        switch (mode) {
            case NONE: {
                return Distributions.unspecified();
            }
            case HASH: {
                if (table.spec().isUnpartitioned()) {
                    return Distributions.clustered((Expression[])SparkWriteUtil.concat(PARTITION_FILE_CLUSTERING, SparkWriteUtil.clustering(table)));
                }
                return Distributions.clustered((Expression[])SparkWriteUtil.concat(PARTITION_CLUSTERING, SparkWriteUtil.clustering(table)));
            }
            case RANGE: {
                if (table.spec().isUnpartitioned()) {
                    return Distributions.ordered((SortOrder[])SparkWriteUtil.concat(PARTITION_FILE_ORDERING, SparkWriteUtil.ordering(table)));
                }
                return Distributions.ordered((SortOrder[])SparkWriteUtil.concat(PARTITION_ORDERING, SparkWriteUtil.ordering(table)));
            }
        }
        throw new IllegalArgumentException("Unsupported distribution mode: " + mode);
    }

    private static SortOrder[] positionDeltaUpdateMergeOrdering(Table table, boolean fanoutEnabled) {
        if (fanoutEnabled && table.sortOrder().isUnsorted()) {
            return EMPTY_ORDERING;
        }
        return SparkWriteUtil.concat(POSITION_DELETE_ORDERING, SparkWriteUtil.ordering(table));
    }

    private static Distribution positionDeltaDeleteDistribution(Table table, DistributionMode mode) {
        switch (mode) {
            case NONE: {
                return Distributions.unspecified();
            }
            case HASH: {
                if (table.spec().isUnpartitioned()) {
                    return Distributions.clustered((Expression[])PARTITION_FILE_CLUSTERING);
                }
                return Distributions.clustered((Expression[])PARTITION_CLUSTERING);
            }
            case RANGE: {
                if (table.spec().isUnpartitioned()) {
                    return Distributions.ordered((SortOrder[])PARTITION_FILE_ORDERING);
                }
                return Distributions.ordered((SortOrder[])PARTITION_ORDERING);
            }
        }
        throw new IllegalArgumentException("Unsupported distribution mode: " + mode);
    }

    private static SortOrder[] writeOrdering(Table table, boolean fanoutEnabled) {
        if (fanoutEnabled && table.sortOrder().isUnsorted()) {
            return EMPTY_ORDERING;
        }
        return SparkWriteUtil.ordering(table);
    }

    private static Expression[] clustering(Table table) {
        return Spark3Util.toTransforms(table.spec());
    }

    private static SortOrder[] ordering(Table table) {
        return Spark3Util.toOrdering(SortOrderUtil.buildSortOrder((Table)table));
    }

    private static Expression[] concat(Expression[] clustering, Expression ... otherClustering) {
        return (Expression[])ObjectArrays.concat((Object[])clustering, (Object[])otherClustering, Expression.class);
    }

    private static SortOrder[] concat(SortOrder[] ordering, SortOrder ... otherOrdering) {
        return (SortOrder[])ObjectArrays.concat((Object[])ordering, (Object[])otherOrdering, SortOrder.class);
    }

    private static NamedReference ref(Types.NestedField field) {
        return Expressions.column((String)field.name());
    }

    private static NamedReference ref(String name) {
        return Expressions.column((String)name);
    }

    private static Expression[] clusterBy(Expression ... exprs) {
        return exprs;
    }

    private static SortOrder[] orderBy(Expression ... exprs) {
        return (SortOrder[])Arrays.stream(exprs).map(SparkWriteUtil::sort).toArray(SortOrder[]::new);
    }

    private static SortOrder sort(Expression expr) {
        return Expressions.sort((Expression)expr, (SortDirection)SortDirection.ASCENDING);
    }
}

