/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.True;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.expressions.UnboundTerm;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.spark.SparkUtil;
import org.apache.iceberg.util.NaNUtil;
import org.apache.iceberg.util.Pair;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.Literal;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.UserDefinedScalarFunc;
import org.apache.spark.sql.connector.expressions.filter.And;
import org.apache.spark.sql.connector.expressions.filter.Not;
import org.apache.spark.sql.connector.expressions.filter.Or;
import org.apache.spark.sql.connector.expressions.filter.Predicate;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.unsafe.types.UTF8String;

public class SparkV2Filters {
    public static final Set<String> SUPPORTED_FUNCTIONS = ImmutableSet.of((Object)"years", (Object)"months", (Object)"days", (Object)"hours", (Object)"bucket", (Object)"truncate", (Object[])new String[0]);
    private static final String TRUE = "ALWAYS_TRUE";
    private static final String FALSE = "ALWAYS_FALSE";
    private static final String EQ = "=";
    private static final String EQ_NULL_SAFE = "<=>";
    private static final String NOT_EQ = "<>";
    private static final String GT = ">";
    private static final String GT_EQ = ">=";
    private static final String LT = "<";
    private static final String LT_EQ = "<=";
    private static final String IN = "IN";
    private static final String IS_NULL = "IS_NULL";
    private static final String NOT_NULL = "IS_NOT_NULL";
    private static final String AND = "AND";
    private static final String OR = "OR";
    private static final String NOT = "NOT";
    private static final String STARTS_WITH = "STARTS_WITH";
    private static final Map<String, Expression.Operation> FILTERS = ImmutableMap.builder().put((Object)"ALWAYS_TRUE", (Object)Expression.Operation.TRUE).put((Object)"ALWAYS_FALSE", (Object)Expression.Operation.FALSE).put((Object)"=", (Object)Expression.Operation.EQ).put((Object)"<=>", (Object)Expression.Operation.EQ).put((Object)"<>", (Object)Expression.Operation.NOT_EQ).put((Object)">", (Object)Expression.Operation.GT).put((Object)">=", (Object)Expression.Operation.GT_EQ).put((Object)"<", (Object)Expression.Operation.LT).put((Object)"<=", (Object)Expression.Operation.LT_EQ).put((Object)"IN", (Object)Expression.Operation.IN).put((Object)"IS_NULL", (Object)Expression.Operation.IS_NULL).put((Object)"IS_NOT_NULL", (Object)Expression.Operation.NOT_NULL).put((Object)"AND", (Object)Expression.Operation.AND).put((Object)"OR", (Object)Expression.Operation.OR).put((Object)"NOT", (Object)Expression.Operation.NOT).put((Object)"STARTS_WITH", (Object)Expression.Operation.STARTS_WITH).buildOrThrow();

    private SparkV2Filters() {
    }

    public static org.apache.iceberg.expressions.Expression convert(Predicate[] predicates) {
        True expression = Expressions.alwaysTrue();
        for (Predicate predicate : predicates) {
            org.apache.iceberg.expressions.Expression converted = SparkV2Filters.convert(predicate);
            Preconditions.checkArgument((converted != null ? 1 : 0) != 0, (String)"Cannot convert Spark predicate to Iceberg expression: %s", (Object)predicate);
            expression = Expressions.and((org.apache.iceberg.expressions.Expression)expression, (org.apache.iceberg.expressions.Expression)converted);
        }
        return expression;
    }

    public static org.apache.iceberg.expressions.Expression convert(Predicate predicate) {
        Expression.Operation op = FILTERS.get(predicate.name());
        if (op != null) {
            switch (op) {
                case TRUE: {
                    return Expressions.alwaysTrue();
                }
                case FALSE: {
                    return Expressions.alwaysFalse();
                }
                case IS_NULL: {
                    if (SparkV2Filters.canConvertToTerm((Expression)SparkV2Filters.child(predicate))) {
                        UnboundTerm<Object> term = SparkV2Filters.toTerm(SparkV2Filters.child(predicate));
                        return term != null ? Expressions.isNull(term) : null;
                    }
                    return null;
                }
                case NOT_NULL: {
                    if (SparkV2Filters.canConvertToTerm((Expression)SparkV2Filters.child(predicate))) {
                        UnboundTerm<Object> term = SparkV2Filters.toTerm(SparkV2Filters.child(predicate));
                        return term != null ? Expressions.notNull(term) : null;
                    }
                    return null;
                }
                case LT: {
                    if (SparkV2Filters.canConvertToTerm((Expression)SparkV2Filters.leftChild(predicate)) && SparkV2Filters.isLiteral((Expression)SparkV2Filters.rightChild(predicate))) {
                        UnboundTerm<Object> term = SparkV2Filters.toTerm(SparkV2Filters.leftChild(predicate));
                        return term != null ? Expressions.lessThan(term, (Object)SparkV2Filters.convertLiteral((Literal)SparkV2Filters.rightChild(predicate))) : null;
                    }
                    if (SparkV2Filters.canConvertToTerm((Expression)SparkV2Filters.rightChild(predicate)) && SparkV2Filters.isLiteral((Expression)SparkV2Filters.leftChild(predicate))) {
                        UnboundTerm<Object> term = SparkV2Filters.toTerm(SparkV2Filters.rightChild(predicate));
                        return term != null ? Expressions.greaterThan(term, (Object)SparkV2Filters.convertLiteral((Literal)SparkV2Filters.leftChild(predicate))) : null;
                    }
                    return null;
                }
                case LT_EQ: {
                    if (SparkV2Filters.canConvertToTerm((Expression)SparkV2Filters.leftChild(predicate)) && SparkV2Filters.isLiteral((Expression)SparkV2Filters.rightChild(predicate))) {
                        UnboundTerm<Object> term = SparkV2Filters.toTerm(SparkV2Filters.leftChild(predicate));
                        return term != null ? Expressions.lessThanOrEqual(term, (Object)SparkV2Filters.convertLiteral((Literal)SparkV2Filters.rightChild(predicate))) : null;
                    }
                    if (SparkV2Filters.canConvertToTerm((Expression)SparkV2Filters.rightChild(predicate)) && SparkV2Filters.isLiteral((Expression)SparkV2Filters.leftChild(predicate))) {
                        UnboundTerm<Object> term = SparkV2Filters.toTerm(SparkV2Filters.rightChild(predicate));
                        return term != null ? Expressions.greaterThanOrEqual(term, (Object)SparkV2Filters.convertLiteral((Literal)SparkV2Filters.leftChild(predicate))) : null;
                    }
                    return null;
                }
                case GT: {
                    if (SparkV2Filters.canConvertToTerm((Expression)SparkV2Filters.leftChild(predicate)) && SparkV2Filters.isLiteral((Expression)SparkV2Filters.rightChild(predicate))) {
                        UnboundTerm<Object> term = SparkV2Filters.toTerm(SparkV2Filters.leftChild(predicate));
                        return term != null ? Expressions.greaterThan(term, (Object)SparkV2Filters.convertLiteral((Literal)SparkV2Filters.rightChild(predicate))) : null;
                    }
                    if (SparkV2Filters.canConvertToTerm((Expression)SparkV2Filters.rightChild(predicate)) && SparkV2Filters.isLiteral((Expression)SparkV2Filters.leftChild(predicate))) {
                        UnboundTerm<Object> term = SparkV2Filters.toTerm(SparkV2Filters.rightChild(predicate));
                        return term != null ? Expressions.lessThan(term, (Object)SparkV2Filters.convertLiteral((Literal)SparkV2Filters.leftChild(predicate))) : null;
                    }
                    return null;
                }
                case GT_EQ: {
                    if (SparkV2Filters.canConvertToTerm((Expression)SparkV2Filters.leftChild(predicate)) && SparkV2Filters.isLiteral((Expression)SparkV2Filters.rightChild(predicate))) {
                        UnboundTerm<Object> term = SparkV2Filters.toTerm(SparkV2Filters.leftChild(predicate));
                        return term != null ? Expressions.greaterThanOrEqual(term, (Object)SparkV2Filters.convertLiteral((Literal)SparkV2Filters.rightChild(predicate))) : null;
                    }
                    if (SparkV2Filters.canConvertToTerm((Expression)SparkV2Filters.rightChild(predicate)) && SparkV2Filters.isLiteral((Expression)SparkV2Filters.leftChild(predicate))) {
                        UnboundTerm<Object> term = SparkV2Filters.toTerm(SparkV2Filters.rightChild(predicate));
                        return term != null ? Expressions.lessThanOrEqual(term, (Object)SparkV2Filters.convertLiteral((Literal)SparkV2Filters.leftChild(predicate))) : null;
                    }
                    return null;
                }
                case EQ: {
                    Pair<UnboundTerm<Object>, Object> eqChildren = SparkV2Filters.predicateChildren(predicate);
                    if (eqChildren == null) {
                        return null;
                    }
                    if (predicate.name().equals(EQ)) {
                        Preconditions.checkNotNull((Object)eqChildren.second(), (String)"Expression is always false (eq is not null-safe): %s", (Object)predicate);
                    }
                    return SparkV2Filters.handleEqual((UnboundTerm<Object>)((UnboundTerm)eqChildren.first()), eqChildren.second());
                }
                case NOT_EQ: {
                    Pair<UnboundTerm<Object>, Object> notEqChildren = SparkV2Filters.predicateChildren(predicate);
                    if (notEqChildren == null) {
                        return null;
                    }
                    Preconditions.checkNotNull((Object)notEqChildren.second(), (String)"Expression is always false (notEq is not null-safe): %s", (Object)predicate);
                    return SparkV2Filters.handleNotEqual((UnboundTerm<Object>)((UnboundTerm)notEqChildren.first()), notEqChildren.second());
                }
                case IN: {
                    if (SparkV2Filters.isSupportedInPredicate(predicate)) {
                        UnboundTerm<Object> term = SparkV2Filters.toTerm(SparkV2Filters.childAtIndex(predicate, 0));
                        return term != null ? Expressions.in(term, (Iterable)Arrays.stream(predicate.children()).skip(1L).map(val -> SparkV2Filters.convertLiteral((Literal)val)).filter(Objects::nonNull).collect(Collectors.toList())) : null;
                    }
                    return null;
                }
                case NOT: {
                    org.apache.iceberg.expressions.Expression child;
                    Not notPredicate = (Not)predicate;
                    Predicate childPredicate = notPredicate.child();
                    if (childPredicate.name().equals(IN) && SparkV2Filters.isSupportedInPredicate(childPredicate)) {
                        UnboundTerm<Object> term = SparkV2Filters.toTerm(SparkV2Filters.childAtIndex(childPredicate, 0));
                        if (term == null) {
                            return null;
                        }
                        UnboundPredicate notIn = Expressions.notIn(term, (Iterable)Arrays.stream(childPredicate.children()).skip(1L).map(val -> SparkV2Filters.convertLiteral((Literal)val)).filter(Objects::nonNull).collect(Collectors.toList()));
                        return Expressions.and((org.apache.iceberg.expressions.Expression)Expressions.notNull(term), (org.apache.iceberg.expressions.Expression)notIn);
                    }
                    if (SparkV2Filters.hasNoInFilter(childPredicate) && (child = SparkV2Filters.convert(childPredicate)) != null) {
                        return Expressions.not((org.apache.iceberg.expressions.Expression)child);
                    }
                    return null;
                }
                case AND: {
                    And andPredicate = (And)predicate;
                    org.apache.iceberg.expressions.Expression left = SparkV2Filters.convert(andPredicate.left());
                    org.apache.iceberg.expressions.Expression right = SparkV2Filters.convert(andPredicate.right());
                    if (left != null && right != null) {
                        return Expressions.and((org.apache.iceberg.expressions.Expression)left, (org.apache.iceberg.expressions.Expression)right);
                    }
                    return null;
                }
                case OR: {
                    Or orPredicate = (Or)predicate;
                    org.apache.iceberg.expressions.Expression left = SparkV2Filters.convert(orPredicate.left());
                    org.apache.iceberg.expressions.Expression right = SparkV2Filters.convert(orPredicate.right());
                    if (left != null && right != null) {
                        return Expressions.or((org.apache.iceberg.expressions.Expression)left, (org.apache.iceberg.expressions.Expression)right);
                    }
                    return null;
                }
                case STARTS_WITH: {
                    String colName = SparkUtil.toColumnName((NamedReference)SparkV2Filters.leftChild(predicate));
                    return Expressions.startsWith((String)colName, (String)SparkV2Filters.convertLiteral((Literal)SparkV2Filters.rightChild(predicate)).toString());
                }
            }
        }
        return null;
    }

    private static Pair<UnboundTerm<Object>, Object> predicateChildren(Predicate predicate) {
        if (SparkV2Filters.canConvertToTerm((Expression)SparkV2Filters.leftChild(predicate)) && SparkV2Filters.isLiteral((Expression)SparkV2Filters.rightChild(predicate))) {
            UnboundTerm<Object> term = SparkV2Filters.toTerm(SparkV2Filters.leftChild(predicate));
            return term != null ? Pair.of(term, (Object)SparkV2Filters.convertLiteral((Literal)SparkV2Filters.rightChild(predicate))) : null;
        }
        if (SparkV2Filters.canConvertToTerm((Expression)SparkV2Filters.rightChild(predicate)) && SparkV2Filters.isLiteral((Expression)SparkV2Filters.leftChild(predicate))) {
            UnboundTerm<Object> term = SparkV2Filters.toTerm(SparkV2Filters.rightChild(predicate));
            return term != null ? Pair.of(term, (Object)SparkV2Filters.convertLiteral((Literal)SparkV2Filters.leftChild(predicate))) : null;
        }
        return null;
    }

    private static <T> T child(Predicate predicate) {
        Expression[] children = predicate.children();
        Preconditions.checkArgument((children.length == 1 ? 1 : 0) != 0, (String)"Predicate should have one child: %s", (Object)predicate);
        return (T)children[0];
    }

    private static <T> T leftChild(Predicate predicate) {
        Expression[] children = predicate.children();
        Preconditions.checkArgument((children.length == 2 ? 1 : 0) != 0, (String)"Predicate should have two children: %s", (Object)predicate);
        return (T)children[0];
    }

    private static <T> T rightChild(Predicate predicate) {
        Expression[] children = predicate.children();
        Preconditions.checkArgument((children.length == 2 ? 1 : 0) != 0, (String)"Predicate should have two children: %s", (Object)predicate);
        return (T)children[1];
    }

    private static <T> T childAtIndex(Predicate predicate, int index) {
        return (T)predicate.children()[index];
    }

    private static boolean canConvertToTerm(Expression expr) {
        return SparkV2Filters.isRef(expr) || SparkV2Filters.isSystemFunc(expr);
    }

    private static boolean isRef(Expression expr) {
        return expr instanceof NamedReference;
    }

    private static boolean isSystemFunc(Expression expr) {
        if (expr instanceof UserDefinedScalarFunc) {
            UserDefinedScalarFunc udf = (UserDefinedScalarFunc)expr;
            return udf.canonicalName().startsWith("iceberg") && SUPPORTED_FUNCTIONS.contains(udf.name()) && Arrays.stream(udf.children()).allMatch(child -> SparkV2Filters.isLiteral(child) || SparkV2Filters.isRef(child));
        }
        return false;
    }

    private static boolean isLiteral(Expression expr) {
        return expr instanceof Literal;
    }

    private static Object convertLiteral(Literal<?> literal) {
        if (literal.value() instanceof UTF8String) {
            return ((UTF8String)literal.value()).toString();
        }
        if (literal.value() instanceof Decimal) {
            return ((Decimal)literal.value()).toJavaBigDecimal();
        }
        return literal.value();
    }

    private static UnboundPredicate<Object> handleEqual(UnboundTerm<Object> term, Object value) {
        if (value == null) {
            return Expressions.isNull(term);
        }
        if (NaNUtil.isNaN((Object)value)) {
            return Expressions.isNaN(term);
        }
        return Expressions.equal(term, (Object)value);
    }

    private static UnboundPredicate<Object> handleNotEqual(UnboundTerm<Object> term, Object value) {
        if (NaNUtil.isNaN((Object)value)) {
            return Expressions.notNaN(term);
        }
        return Expressions.notEqual(term, (Object)value);
    }

    private static boolean hasNoInFilter(Predicate predicate) {
        Expression.Operation op = FILTERS.get(predicate.name());
        if (op != null) {
            switch (op) {
                case AND: {
                    And andPredicate = (And)predicate;
                    return SparkV2Filters.hasNoInFilter(andPredicate.left()) && SparkV2Filters.hasNoInFilter(andPredicate.right());
                }
                case OR: {
                    Or orPredicate = (Or)predicate;
                    return SparkV2Filters.hasNoInFilter(orPredicate.left()) && SparkV2Filters.hasNoInFilter(orPredicate.right());
                }
                case NOT: {
                    Not notPredicate = (Not)predicate;
                    return SparkV2Filters.hasNoInFilter(notPredicate.child());
                }
                case IN: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private static boolean isSupportedInPredicate(Predicate predicate) {
        if (!SparkV2Filters.canConvertToTerm((Expression)SparkV2Filters.childAtIndex(predicate, 0))) {
            return false;
        }
        return Arrays.stream(predicate.children()).skip(1L).allMatch(SparkV2Filters::isLiteral);
    }

    private static <T> UnboundTerm<Object> toTerm(T input) {
        if (input instanceof NamedReference) {
            return Expressions.ref((String)SparkUtil.toColumnName((NamedReference)input));
        }
        if (input instanceof UserDefinedScalarFunc) {
            return SparkV2Filters.udfToTerm((UserDefinedScalarFunc)input);
        }
        return null;
    }

    private static UnboundTerm<Object> udfToTerm(UserDefinedScalarFunc udf) {
        Expression[] children = udf.children();
        String udfName = udf.name().toLowerCase(Locale.ROOT);
        if (children.length == 1) {
            Expression child = children[0];
            if (SparkV2Filters.isRef(child)) {
                String column = SparkUtil.toColumnName((NamedReference)child);
                switch (udfName) {
                    case "years": {
                        return Expressions.year((String)column);
                    }
                    case "months": {
                        return Expressions.month((String)column);
                    }
                    case "days": {
                        return Expressions.day((String)column);
                    }
                    case "hours": {
                        return Expressions.hour((String)column);
                    }
                }
            }
        } else if (children.length == 2 && SparkV2Filters.isLiteral(children[0]) && SparkV2Filters.isRef(children[1])) {
            String column = SparkUtil.toColumnName((NamedReference)children[1]);
            switch (udfName) {
                case "bucket": {
                    int numBuckets = (Integer)SparkV2Filters.convertLiteral((Literal)children[0]);
                    return Expressions.bucket((String)column, (int)numBuckets);
                }
                case "truncate": {
                    int width = (Integer)SparkV2Filters.convertLiteral((Literal)children[0]);
                    return Expressions.truncate((String)column, (int)width);
                }
            }
        }
        return null;
    }
}

