/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.transforms.UnknownTransform;
import org.apache.iceberg.util.Pair;
import org.apache.spark.SparkEnv;
import org.apache.spark.scheduler.ExecutorCacheTaskLocation;
import org.apache.spark.sql.RuntimeConfig;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.BlockManagerMaster;
import org.joda.time.DateTime;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class SparkUtil {
    private static final String SPARK_CATALOG_CONF_PREFIX = "spark.sql.catalog";
    private static final String SPARK_CATALOG_HADOOP_CONF_OVERRIDE_FMT_STR = "spark.sql.catalog.%s.hadoop.";
    private static final Joiner DOT = Joiner.on((String)".");

    private SparkUtil() {
    }

    public static void validatePartitionTransforms(PartitionSpec spec) {
        if (spec.fields().stream().anyMatch(field -> field.transform() instanceof UnknownTransform)) {
            String unsupported = spec.fields().stream().map(PartitionField::transform).filter(transform -> transform instanceof UnknownTransform).map(Object::toString).collect(Collectors.joining(", "));
            throw new UnsupportedOperationException(String.format("Cannot write using unsupported transforms: %s", unsupported));
        }
    }

    public static <C, T> Pair<C, T> catalogAndIdentifier(List<String> nameParts, Function<String, C> catalogProvider, BiFunction<String[], String, T> identiferProvider, C currentCatalog, String[] currentNamespace) {
        Preconditions.checkArgument((!nameParts.isEmpty() ? 1 : 0) != 0, (Object)"Cannot determine catalog and identifier from empty name");
        int lastElementIndex = nameParts.size() - 1;
        String name = nameParts.get(lastElementIndex);
        if (nameParts.size() == 1) {
            return Pair.of(currentCatalog, identiferProvider.apply(currentNamespace, name));
        }
        C catalog = catalogProvider.apply(nameParts.get(0));
        if (catalog == null) {
            String[] namespace = nameParts.subList(0, lastElementIndex).toArray(new String[0]);
            return Pair.of(currentCatalog, identiferProvider.apply(namespace, name));
        }
        String[] namespace = nameParts.subList(1, lastElementIndex).toArray(new String[0]);
        return Pair.of(catalog, identiferProvider.apply(namespace, name));
    }

    public static Configuration hadoopConfCatalogOverrides(SparkSession spark, String catalogName) {
        String hadoopConfCatalogPrefix = SparkUtil.hadoopConfPrefixForCatalog(catalogName);
        Configuration conf = spark.sessionState().newHadoopConf();
        spark.sqlContext().conf().settings().forEach((k, v) -> {
            if (v != null && k != null && k.startsWith(hadoopConfCatalogPrefix)) {
                conf.set(k.substring(hadoopConfCatalogPrefix.length()), v);
            }
        });
        return conf;
    }

    private static String hadoopConfPrefixForCatalog(String catalogName) {
        return String.format(SPARK_CATALOG_HADOOP_CONF_OVERRIDE_FMT_STR, catalogName);
    }

    public static void validateTimestampWithoutTimezoneConfig(RuntimeConfig conf) {
        SparkUtil.validateTimestampWithoutTimezoneConfig(conf, (Map<String, String>)ImmutableMap.of());
    }

    public static void validateTimestampWithoutTimezoneConfig(RuntimeConfig conf, Map<String, String> options) {
        if (conf.contains("spark.sql.iceberg.handle-timestamp-without-timezone")) {
            throw new UnsupportedOperationException("Spark configuration spark.sql.iceberg.handle-timestamp-without-timezone is not supported in Spark 3.4 due to the introduction of native support for timestamp without timezone.");
        }
        if (options.containsKey("handle-timestamp-without-timezone")) {
            throw new UnsupportedOperationException("Option handle-timestamp-without-timezone is not supported in Spark 3.4 due to the introduction of native support for timestamp without timezone.");
        }
        if (conf.contains("spark.sql.iceberg.use-timestamp-without-timezone-in-new-tables")) {
            throw new UnsupportedOperationException("Spark configuration spark.sql.iceberg.use-timestamp-without-timezone-in-new-tables is not supported in Spark 3.4 due to the introduction of native support for timestamp without timezone.");
        }
    }

    public static List<Expression> partitionMapToExpression(StructType schema, Map<String, String> filters) {
        ArrayList filterExpressions = Lists.newArrayList();
        for (Map.Entry<String, String> entry : filters.entrySet()) {
            try {
                int index = schema.fieldIndex(entry.getKey());
                DataType dataType = schema.fields()[index].dataType();
                BoundReference ref = new BoundReference(index, dataType, true);
                switch (dataType.typeName()) {
                    case "integer": {
                        filterExpressions.add(new EqualTo((Expression)ref, (Expression)Literal.create((Object)Integer.parseInt(entry.getValue()), (DataType)DataTypes.IntegerType)));
                        break;
                    }
                    case "string": {
                        filterExpressions.add(new EqualTo((Expression)ref, (Expression)Literal.create((Object)entry.getValue(), (DataType)DataTypes.StringType)));
                        break;
                    }
                    case "short": {
                        filterExpressions.add(new EqualTo((Expression)ref, (Expression)Literal.create((Object)Short.parseShort(entry.getValue()), (DataType)DataTypes.ShortType)));
                        break;
                    }
                    case "long": {
                        filterExpressions.add(new EqualTo((Expression)ref, (Expression)Literal.create((Object)Long.parseLong(entry.getValue()), (DataType)DataTypes.LongType)));
                        break;
                    }
                    case "float": {
                        filterExpressions.add(new EqualTo((Expression)ref, (Expression)Literal.create((Object)Float.valueOf(Float.parseFloat(entry.getValue())), (DataType)DataTypes.FloatType)));
                        break;
                    }
                    case "double": {
                        filterExpressions.add(new EqualTo((Expression)ref, (Expression)Literal.create((Object)Double.parseDouble(entry.getValue()), (DataType)DataTypes.DoubleType)));
                        break;
                    }
                    case "date": {
                        filterExpressions.add(new EqualTo((Expression)ref, (Expression)Literal.create((Object)new Date(DateTime.parse((String)entry.getValue()).getMillis()), (DataType)DataTypes.DateType)));
                        break;
                    }
                    case "timestamp": {
                        filterExpressions.add(new EqualTo((Expression)ref, (Expression)Literal.create((Object)new Timestamp(DateTime.parse((String)entry.getValue()).getMillis()), (DataType)DataTypes.TimestampType)));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected data type in partition filters: " + dataType);
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return filterExpressions;
    }

    public static String toColumnName(NamedReference ref) {
        return DOT.join((Object[])ref.fieldNames());
    }

    public static boolean caseSensitive(SparkSession spark) {
        return Boolean.parseBoolean(spark.conf().get("spark.sql.caseSensitive"));
    }

    public static List<String> executorLocations() {
        BlockManager driverBlockManager = SparkEnv.get().blockManager();
        List<BlockManagerId> executorBlockManagerIds = SparkUtil.fetchPeers(driverBlockManager);
        return executorBlockManagerIds.stream().map(SparkUtil::toExecutorLocation).sorted().collect(Collectors.toList());
    }

    private static List<BlockManagerId> fetchPeers(BlockManager blockManager) {
        BlockManagerMaster master = blockManager.master();
        BlockManagerId id = blockManager.blockManagerId();
        return SparkUtil.toJavaList(master.getPeers(id));
    }

    private static <T> List<T> toJavaList(Seq<T> seq) {
        return (List)JavaConverters.seqAsJavaListConverter(seq).asJava();
    }

    private static String toExecutorLocation(BlockManagerId id) {
        return ExecutorCacheTaskLocation.apply((String)id.host(), (String)id.executorId()).toString();
    }
}

