/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.util.Map;
import org.apache.iceberg.PlanningMode;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableProperties;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.hadoop.Util;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.spark.SparkConfParser;
import org.apache.iceberg.spark.SparkUtil;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SparkSession;

public class SparkReadConf {
    private static final String DRIVER_MAX_RESULT_SIZE = "spark.driver.maxResultSize";
    private static final String DRIVER_MAX_RESULT_SIZE_DEFAULT = "1G";
    private static final long DISTRIBUTED_PLANNING_MIN_RESULT_SIZE = 0x10000000L;
    private final SparkSession spark;
    private final Table table;
    private final String branch;
    private final Map<String, String> readOptions;
    private final SparkConfParser confParser;

    public SparkReadConf(SparkSession spark, Table table, Map<String, String> readOptions) {
        this(spark, table, null, readOptions);
    }

    public SparkReadConf(SparkSession spark, Table table, String branch, Map<String, String> readOptions) {
        this.spark = spark;
        this.table = table;
        this.branch = branch;
        this.readOptions = readOptions;
        this.confParser = new SparkConfParser(spark, table, readOptions);
        SparkUtil.validateTimestampWithoutTimezoneConfig(spark.conf(), readOptions);
    }

    public boolean caseSensitive() {
        return SparkUtil.caseSensitive(this.spark);
    }

    public boolean localityEnabled() {
        boolean defaultValue = Util.mayHaveBlockLocations((FileIO)this.table.io(), (String)this.table.location());
        return ((SparkConfParser.BooleanConfParser)((SparkConfParser.BooleanConfParser)this.confParser.booleanConf().option("locality")).sessionConf("spark.sql.iceberg.locality.enabled")).defaultValue(defaultValue).parse();
    }

    public Long snapshotId() {
        return ((SparkConfParser.LongConfParser)this.confParser.longConf().option("snapshot-id")).parseOptional();
    }

    public Long asOfTimestamp() {
        return ((SparkConfParser.LongConfParser)this.confParser.longConf().option("as-of-timestamp")).parseOptional();
    }

    public Long startSnapshotId() {
        return ((SparkConfParser.LongConfParser)this.confParser.longConf().option("start-snapshot-id")).parseOptional();
    }

    public Long endSnapshotId() {
        return ((SparkConfParser.LongConfParser)this.confParser.longConf().option("end-snapshot-id")).parseOptional();
    }

    public String branch() {
        String wapBranch;
        String inputBranch;
        String optionBranch = ((SparkConfParser.StringConfParser)this.confParser.stringConf().option("branch")).parseOptional();
        ValidationException.check((this.branch == null || optionBranch == null || optionBranch.equals(this.branch) ? 1 : 0) != 0, (String)"Must not specify different branches in both table identifier and read option, got [%s] in identifier and [%s] in options", (Object[])new Object[]{this.branch, optionBranch});
        String string = inputBranch = this.branch != null ? this.branch : optionBranch;
        if (inputBranch != null) {
            return inputBranch;
        }
        boolean wapEnabled = PropertyUtil.propertyAsBoolean((Map)this.table.properties(), (String)"write.wap.enabled", (boolean)false);
        if (wapEnabled && (wapBranch = this.spark.conf().get("spark.wap.branch", null)) != null && this.table.refs().containsKey(wapBranch)) {
            return wapBranch;
        }
        return null;
    }

    public String tag() {
        return ((SparkConfParser.StringConfParser)this.confParser.stringConf().option("tag")).parseOptional();
    }

    public String scanTaskSetId() {
        return ((SparkConfParser.StringConfParser)this.confParser.stringConf().option("scan-task-set-id")).parseOptional();
    }

    public boolean streamingSkipDeleteSnapshots() {
        return ((SparkConfParser.BooleanConfParser)this.confParser.booleanConf().option("streaming-skip-delete-snapshots")).defaultValue(false).parse();
    }

    public boolean streamingSkipOverwriteSnapshots() {
        return ((SparkConfParser.BooleanConfParser)this.confParser.booleanConf().option("streaming-skip-overwrite-snapshots")).defaultValue(false).parse();
    }

    public boolean parquetVectorizationEnabled() {
        return ((SparkConfParser.BooleanConfParser)((SparkConfParser.BooleanConfParser)((SparkConfParser.BooleanConfParser)this.confParser.booleanConf().option("vectorization-enabled")).sessionConf("spark.sql.iceberg.vectorization.enabled")).tableProperty("read.parquet.vectorization.enabled")).defaultValue(true).parse();
    }

    public int parquetBatchSize() {
        return ((SparkConfParser.IntConfParser)((SparkConfParser.IntConfParser)this.confParser.intConf().option("batch-size")).tableProperty("read.parquet.vectorization.batch-size")).defaultValue(5000).parse();
    }

    public boolean orcVectorizationEnabled() {
        return ((SparkConfParser.BooleanConfParser)((SparkConfParser.BooleanConfParser)((SparkConfParser.BooleanConfParser)this.confParser.booleanConf().option("vectorization-enabled")).sessionConf("spark.sql.iceberg.vectorization.enabled")).tableProperty("read.orc.vectorization.enabled")).defaultValue(false).parse();
    }

    public int orcBatchSize() {
        return ((SparkConfParser.IntConfParser)((SparkConfParser.IntConfParser)this.confParser.intConf().option("batch-size")).tableProperty("read.orc.vectorization.batch-size")).defaultValue(5000).parse();
    }

    public Long splitSizeOption() {
        return ((SparkConfParser.LongConfParser)this.confParser.longConf().option("split-size")).parseOptional();
    }

    public long splitSize() {
        return ((SparkConfParser.LongConfParser)((SparkConfParser.LongConfParser)this.confParser.longConf().option("split-size")).tableProperty("read.split.target-size")).defaultValue(0x8000000L).parse();
    }

    public Integer splitLookbackOption() {
        return ((SparkConfParser.IntConfParser)this.confParser.intConf().option("lookback")).parseOptional();
    }

    public int splitLookback() {
        return ((SparkConfParser.IntConfParser)((SparkConfParser.IntConfParser)this.confParser.intConf().option("lookback")).tableProperty("read.split.planning-lookback")).defaultValue(10).parse();
    }

    public Long splitOpenFileCostOption() {
        return ((SparkConfParser.LongConfParser)this.confParser.longConf().option("file-open-cost")).parseOptional();
    }

    public long splitOpenFileCost() {
        return ((SparkConfParser.LongConfParser)((SparkConfParser.LongConfParser)this.confParser.longConf().option("file-open-cost")).tableProperty("read.split.open-file-cost")).defaultValue(0x400000L).parse();
    }

    public long streamFromTimestamp() {
        return ((SparkConfParser.LongConfParser)this.confParser.longConf().option("stream-from-timestamp")).defaultValue(Long.MIN_VALUE).parse();
    }

    public Long startTimestamp() {
        return ((SparkConfParser.LongConfParser)this.confParser.longConf().option("start-timestamp")).parseOptional();
    }

    public Long endTimestamp() {
        return ((SparkConfParser.LongConfParser)this.confParser.longConf().option("end-timestamp")).parseOptional();
    }

    public int maxFilesPerMicroBatch() {
        return ((SparkConfParser.IntConfParser)this.confParser.intConf().option("streaming-max-files-per-micro-batch")).defaultValue(Integer.MAX_VALUE).parse();
    }

    public int maxRecordsPerMicroBatch() {
        return ((SparkConfParser.IntConfParser)this.confParser.intConf().option("streaming-max-rows-per-micro-batch")).defaultValue(Integer.MAX_VALUE).parse();
    }

    public boolean preserveDataGrouping() {
        return ((SparkConfParser.BooleanConfParser)this.confParser.booleanConf().sessionConf("spark.sql.iceberg.planning.preserve-data-grouping")).defaultValue(false).parse();
    }

    public boolean aggregatePushDownEnabled() {
        return ((SparkConfParser.BooleanConfParser)((SparkConfParser.BooleanConfParser)this.confParser.booleanConf().option("aggregate-push-down-enabled")).sessionConf("spark.sql.iceberg.aggregate-push-down.enabled")).defaultValue(true).parse();
    }

    public boolean adaptiveSplitSizeEnabled() {
        return ((SparkConfParser.BooleanConfParser)this.confParser.booleanConf().tableProperty("read.split.adaptive-size.enabled")).defaultValue(true).parse();
    }

    public int parallelism() {
        int defaultParallelism = this.spark.sparkContext().defaultParallelism();
        int numShufflePartitions = this.spark.sessionState().conf().numShufflePartitions();
        return Math.max(defaultParallelism, numShufflePartitions);
    }

    public boolean distributedPlanningEnabled() {
        return this.dataPlanningMode() != PlanningMode.LOCAL || this.deletePlanningMode() != PlanningMode.LOCAL;
    }

    public PlanningMode dataPlanningMode() {
        if (this.driverMaxResultSize() < 0x10000000L) {
            return PlanningMode.LOCAL;
        }
        return (PlanningMode)((SparkConfParser.EnumConfParser)((SparkConfParser.EnumConfParser)this.confParser.enumConf(PlanningMode::fromName).sessionConf("spark.sql.iceberg.data-planning-mode")).tableProperty("read.data-planning-mode")).defaultValue(TableProperties.PLANNING_MODE_DEFAULT).parse();
    }

    public PlanningMode deletePlanningMode() {
        if (this.driverMaxResultSize() < 0x10000000L) {
            return PlanningMode.LOCAL;
        }
        String modeName = ((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)this.confParser.stringConf().sessionConf("spark.sql.iceberg.delete-planning-mode")).tableProperty("read.delete-planning-mode")).defaultValue(TableProperties.PLANNING_MODE_DEFAULT).parse();
        return PlanningMode.fromName((String)modeName);
    }

    private long driverMaxResultSize() {
        SparkConf sparkConf = this.spark.sparkContext().conf();
        return sparkConf.getSizeAsBytes(DRIVER_MAX_RESULT_SIZE, DRIVER_MAX_RESULT_SIZE_DEFAULT);
    }

    public boolean executorCacheLocalityEnabled() {
        return this.executorCacheEnabled() && this.executorCacheLocalityEnabledInternal();
    }

    private boolean executorCacheEnabled() {
        return ((SparkConfParser.BooleanConfParser)this.confParser.booleanConf().sessionConf("spark.sql.iceberg.executor-cache.enabled")).defaultValue(true).parse();
    }

    private boolean executorCacheLocalityEnabledInternal() {
        return ((SparkConfParser.BooleanConfParser)this.confParser.booleanConf().sessionConf("spark.sql.iceberg.executor-cache.locality.enabled")).defaultValue(false).parse();
    }
}

