/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.spark.SparkConfParser;
import org.apache.iceberg.spark.SparkSQLProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkExecutorCache {
    private static final Logger LOG = LoggerFactory.getLogger(SparkExecutorCache.class);
    private static volatile SparkExecutorCache instance = null;
    private final Duration timeout;
    private final long maxEntrySize;
    private final long maxTotalSize;
    private volatile Cache<String, CacheValue> state;

    private SparkExecutorCache(Conf conf) {
        this.timeout = conf.timeout();
        this.maxEntrySize = conf.maxEntrySize();
        this.maxTotalSize = conf.maxTotalSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SparkExecutorCache getOrCreate() {
        Conf conf;
        if (instance != null || !(conf = new Conf()).cacheEnabled()) return instance;
        Class<SparkExecutorCache> clazz = SparkExecutorCache.class;
        synchronized (SparkExecutorCache.class) {
            if (instance != null) return instance;
            instance = new SparkExecutorCache(conf);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public static SparkExecutorCache get() {
        return instance;
    }

    public long maxEntrySize() {
        return this.maxEntrySize;
    }

    public <V> V getOrLoad(String group, String key, Supplier<V> valueSupplier, long valueSize) {
        if (valueSize > this.maxEntrySize) {
            LOG.debug("{} exceeds max entry size: {} > {}", new Object[]{key, valueSize, this.maxEntrySize});
            return valueSupplier.get();
        }
        String internalKey = group + "_" + key;
        CacheValue value = (CacheValue)this.state().get((Object)internalKey, this.loadFunc(valueSupplier, valueSize));
        Preconditions.checkNotNull((Object)value, (Object)"Loaded value must not be null");
        return value.get();
    }

    private <V> Function<String, CacheValue> loadFunc(Supplier<V> valueSupplier, long valueSize) {
        return key -> {
            long start = System.currentTimeMillis();
            Object value = valueSupplier.get();
            long end = System.currentTimeMillis();
            LOG.debug("Loaded {} with size {} in {} ms", new Object[]{key, valueSize, end - start});
            return new CacheValue(value, valueSize);
        };
    }

    public void invalidate(String group) {
        if (this.state != null) {
            List<String> internalKeys = this.findInternalKeys(group);
            LOG.info("Invalidating {} keys associated with {}", (Object)internalKeys.size(), (Object)group);
            internalKeys.forEach(internalKey -> this.state.invalidate(internalKey));
            LOG.info("Current cache stats {}", (Object)this.state.stats());
        }
    }

    private List<String> findInternalKeys(String group) {
        return this.state.asMap().keySet().stream().filter(internalKey -> internalKey.startsWith(group)).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cache<String, CacheValue> state() {
        if (this.state == null) {
            SparkExecutorCache sparkExecutorCache = this;
            synchronized (sparkExecutorCache) {
                if (this.state == null) {
                    LOG.info("Initializing cache state");
                    this.state = this.initState();
                }
            }
        }
        return this.state;
    }

    private Cache<String, CacheValue> initState() {
        return Caffeine.newBuilder().expireAfterAccess(this.timeout).maximumWeight(this.maxTotalSize).weigher((key, value) -> ((CacheValue)value).weight()).recordStats().removalListener((key, value, cause) -> LOG.debug("Evicted {} ({})", key, (Object)cause)).build();
    }

    @VisibleForTesting
    static class Conf {
        private final SparkConfParser confParser = new SparkConfParser();

        Conf() {
        }

        public boolean cacheEnabled() {
            return ((SparkConfParser.BooleanConfParser)this.confParser.booleanConf().sessionConf("spark.sql.iceberg.executor-cache.enabled")).defaultValue(true).parse();
        }

        public Duration timeout() {
            return ((SparkConfParser.DurationConfParser)this.confParser.durationConf().sessionConf("spark.sql.iceberg.executor-cache.timeout")).defaultValue(SparkSQLProperties.EXECUTOR_CACHE_TIMEOUT_DEFAULT).parse();
        }

        public long maxEntrySize() {
            return ((SparkConfParser.LongConfParser)this.confParser.longConf().sessionConf("spark.sql.iceberg.executor-cache.max-entry-size")).defaultValue(0x4000000L).parse();
        }

        public long maxTotalSize() {
            return ((SparkConfParser.LongConfParser)this.confParser.longConf().sessionConf("spark.sql.iceberg.executor-cache.max-total-size")).defaultValue(0x8000000L).parse();
        }
    }

    @VisibleForTesting
    static class CacheValue {
        private final Object value;
        private final long size;

        CacheValue(Object value, long size) {
            this.value = value;
            this.size = size;
        }

        public <V> V get() {
            return (V)this.value;
        }

        public int weight() {
            return (int)Math.min(this.size, Integer.MAX_VALUE);
        }
    }
}

