/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.time.Duration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.JavaUtils;
import org.apache.spark.sql.RuntimeConfig;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.internal.SQLConf;

class SparkConfParser {
    private final Map<String, String> properties;
    private final RuntimeConfig sessionConf;
    private final Map<String, String> options;

    SparkConfParser() {
        this.properties = ImmutableMap.of();
        this.sessionConf = new RuntimeConfig(SQLConf.get());
        this.options = ImmutableMap.of();
    }

    SparkConfParser(SparkSession spark, Table table, Map<String, String> options) {
        this.properties = table.properties();
        this.sessionConf = spark.conf();
        this.options = options;
    }

    public BooleanConfParser booleanConf() {
        return new BooleanConfParser();
    }

    public IntConfParser intConf() {
        return new IntConfParser();
    }

    public LongConfParser longConf() {
        return new LongConfParser();
    }

    public StringConfParser stringConf() {
        return new StringConfParser();
    }

    public DurationConfParser durationConf() {
        return new DurationConfParser();
    }

    public <T extends Enum<T>> EnumConfParser<T> enumConf(Function<String, T> toEnum) {
        return new EnumConfParser<T>(toEnum);
    }

    abstract class ConfParser<ThisT, T> {
        private final List<String> optionNames = Lists.newArrayList();
        private String sessionConfName;
        private String tablePropertyName;

        ConfParser() {
        }

        protected abstract ThisT self();

        public ThisT option(String name) {
            this.optionNames.add(name);
            return this.self();
        }

        public ThisT sessionConf(String name) {
            this.sessionConfName = name;
            return this.self();
        }

        public ThisT tableProperty(String name) {
            this.tablePropertyName = name;
            return this.self();
        }

        protected T parse(Function<String, T> conversion, T defaultValue) {
            String propertyValue;
            String sessionConfValue;
            if (!this.optionNames.isEmpty()) {
                for (String optionName : this.optionNames) {
                    String optionValue = SparkConfParser.this.options.get(optionName.toLowerCase(Locale.ROOT));
                    if (optionValue == null) continue;
                    return conversion.apply(optionValue);
                }
            }
            if (this.sessionConfName != null && (sessionConfValue = SparkConfParser.this.sessionConf.get(this.sessionConfName, null)) != null) {
                return conversion.apply(sessionConfValue);
            }
            if (this.tablePropertyName != null && (propertyValue = SparkConfParser.this.properties.get(this.tablePropertyName)) != null) {
                return conversion.apply(propertyValue);
            }
            return defaultValue;
        }
    }

    class EnumConfParser<T extends Enum<T>>
    extends ConfParser<EnumConfParser<T>, T> {
        private final Function<String, T> toEnum;
        private T defaultValue;

        EnumConfParser(Function<String, T> toEnum) {
            this.toEnum = toEnum;
        }

        @Override
        protected EnumConfParser<T> self() {
            return this;
        }

        public EnumConfParser<T> defaultValue(T value) {
            this.defaultValue = value;
            return this.self();
        }

        public EnumConfParser<T> defaultValue(String value) {
            this.defaultValue = (Enum)this.toEnum.apply(value);
            return this.self();
        }

        public T parse() {
            Preconditions.checkArgument((this.defaultValue != null ? 1 : 0) != 0, (Object)"Default value cannot be null");
            return (T)((Enum)this.parse(this.toEnum, this.defaultValue));
        }

        public T parseOptional() {
            return (T)((Enum)this.parse(this.toEnum, this.defaultValue));
        }
    }

    class DurationConfParser
    extends ConfParser<DurationConfParser, Duration> {
        private Duration defaultValue;

        DurationConfParser() {
        }

        @Override
        protected DurationConfParser self() {
            return this;
        }

        public DurationConfParser defaultValue(Duration value) {
            this.defaultValue = value;
            return this.self();
        }

        public Duration parse() {
            Preconditions.checkArgument((this.defaultValue != null ? 1 : 0) != 0, (Object)"Default value cannot be null");
            return this.parse(this::toDuration, this.defaultValue);
        }

        public Duration parseOptional() {
            return this.parse(this::toDuration, this.defaultValue);
        }

        private Duration toDuration(String time) {
            return Duration.ofSeconds(JavaUtils.timeStringAsSec(time));
        }
    }

    class StringConfParser
    extends ConfParser<StringConfParser, String> {
        private String defaultValue;

        StringConfParser() {
        }

        @Override
        protected StringConfParser self() {
            return this;
        }

        public StringConfParser defaultValue(String value) {
            this.defaultValue = value;
            return this.self();
        }

        public String parse() {
            Preconditions.checkArgument((this.defaultValue != null ? 1 : 0) != 0, (Object)"Default value cannot be null");
            return this.parse(Function.identity(), this.defaultValue);
        }

        public String parseOptional() {
            return this.parse(Function.identity(), null);
        }
    }

    class LongConfParser
    extends ConfParser<LongConfParser, Long> {
        private Long defaultValue;

        LongConfParser() {
        }

        @Override
        protected LongConfParser self() {
            return this;
        }

        public LongConfParser defaultValue(long value) {
            this.defaultValue = value;
            return this.self();
        }

        public long parse() {
            Preconditions.checkArgument((this.defaultValue != null ? 1 : 0) != 0, (Object)"Default value cannot be null");
            return this.parse(Long::parseLong, this.defaultValue);
        }

        public Long parseOptional() {
            return this.parse(Long::parseLong, null);
        }
    }

    class IntConfParser
    extends ConfParser<IntConfParser, Integer> {
        private Integer defaultValue;

        IntConfParser() {
        }

        @Override
        protected IntConfParser self() {
            return this;
        }

        public IntConfParser defaultValue(int value) {
            this.defaultValue = value;
            return this.self();
        }

        public int parse() {
            Preconditions.checkArgument((this.defaultValue != null ? 1 : 0) != 0, (Object)"Default value cannot be null");
            return this.parse(Integer::parseInt, this.defaultValue);
        }

        public Integer parseOptional() {
            return this.parse(Integer::parseInt, null);
        }
    }

    class BooleanConfParser
    extends ConfParser<BooleanConfParser, Boolean> {
        private Boolean defaultValue;
        private boolean negate = false;

        BooleanConfParser() {
        }

        @Override
        protected BooleanConfParser self() {
            return this;
        }

        public BooleanConfParser defaultValue(boolean value) {
            this.defaultValue = value;
            return this.self();
        }

        public BooleanConfParser defaultValue(String value) {
            this.defaultValue = Boolean.parseBoolean(value);
            return this.self();
        }

        public BooleanConfParser negate() {
            this.negate = true;
            return this.self();
        }

        public boolean parse() {
            Preconditions.checkArgument((this.defaultValue != null ? 1 : 0) != 0, (Object)"Default value cannot be null");
            boolean value = this.parse(Boolean::parseBoolean, this.defaultValue);
            return this.negate ? !value : value;
        }
    }
}

