/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.base.Splitter;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.spark.SparkTableCache;
import org.apache.iceberg.spark.SupportsFunctions;
import org.apache.iceberg.spark.source.SparkTable;
import org.apache.iceberg.util.Pair;
import org.apache.iceberg.util.SnapshotUtil;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;

public class SparkCachedTableCatalog
implements TableCatalog,
SupportsFunctions {
    private static final String CLASS_NAME = SparkCachedTableCatalog.class.getName();
    private static final Splitter COMMA = Splitter.on((String)",");
    private static final Pattern AT_TIMESTAMP = Pattern.compile("at_timestamp_(\\d+)");
    private static final Pattern SNAPSHOT_ID = Pattern.compile("snapshot_id_(\\d+)");
    private static final Pattern BRANCH = Pattern.compile("branch_(.*)");
    private static final Pattern TAG = Pattern.compile("tag_(.*)");
    private static final SparkTableCache TABLE_CACHE = SparkTableCache.get();
    private String name = null;

    public Identifier[] listTables(String[] namespace) {
        throw new UnsupportedOperationException(CLASS_NAME + " does not support listing tables");
    }

    public SparkTable loadTable(Identifier ident) throws NoSuchTableException {
        Pair<Table, Long> table = this.load(ident);
        return new SparkTable((Table)table.first(), (Long)table.second(), false);
    }

    public SparkTable loadTable(Identifier ident, String version) throws NoSuchTableException {
        Pair<Table, Long> table = this.load(ident);
        Preconditions.checkArgument((table.second() == null ? 1 : 0) != 0, (Object)"Cannot time travel based on both table identifier and AS OF");
        return new SparkTable((Table)table.first(), Long.parseLong(version), false);
    }

    public SparkTable loadTable(Identifier ident, long timestampMicros) throws NoSuchTableException {
        Pair<Table, Long> table = this.load(ident);
        Preconditions.checkArgument((table.second() == null ? 1 : 0) != 0, (Object)"Cannot time travel based on both table identifier and AS OF");
        long timestampMillis = TimeUnit.MICROSECONDS.toMillis(timestampMicros);
        long snapshotId = SnapshotUtil.snapshotIdAsOfTime((Table)((Table)table.first()), (long)timestampMillis);
        return new SparkTable((Table)table.first(), snapshotId, false);
    }

    public void invalidateTable(Identifier ident) {
        throw new UnsupportedOperationException(CLASS_NAME + " does not support table invalidation");
    }

    public SparkTable createTable(Identifier ident, StructType schema, Transform[] partitions, Map<String, String> properties) throws TableAlreadyExistsException {
        throw new UnsupportedOperationException(CLASS_NAME + " does not support creating tables");
    }

    public SparkTable alterTable(Identifier ident, TableChange ... changes) {
        throw new UnsupportedOperationException(CLASS_NAME + " does not support altering tables");
    }

    public boolean dropTable(Identifier ident) {
        throw new UnsupportedOperationException(CLASS_NAME + " does not support dropping tables");
    }

    public boolean purgeTable(Identifier ident) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(CLASS_NAME + " does not support purging tables");
    }

    public void renameTable(Identifier oldIdent, Identifier newIdent) {
        throw new UnsupportedOperationException(CLASS_NAME + " does not support renaming tables");
    }

    public void initialize(String catalogName, CaseInsensitiveStringMap options) {
        this.name = catalogName;
    }

    public String name() {
        return this.name;
    }

    private Pair<Table, Long> load(Identifier ident) throws NoSuchTableException {
        Preconditions.checkArgument((ident.namespace().length == 0 ? 1 : 0) != 0, (Object)(CLASS_NAME + " does not support namespaces"));
        Pair<String, List<String>> parsedIdent = this.parseIdent(ident);
        String key = (String)parsedIdent.first();
        List metadata = (List)parsedIdent.second();
        Long asOfTimestamp = null;
        Long snapshotId = null;
        String branch = null;
        String tag = null;
        for (String meta : metadata) {
            Matcher timeBasedMatcher = AT_TIMESTAMP.matcher(meta);
            if (timeBasedMatcher.matches()) {
                asOfTimestamp = Long.parseLong(timeBasedMatcher.group(1));
                continue;
            }
            Matcher snapshotBasedMatcher = SNAPSHOT_ID.matcher(meta);
            if (snapshotBasedMatcher.matches()) {
                snapshotId = Long.parseLong(snapshotBasedMatcher.group(1));
                continue;
            }
            Matcher branchBasedMatcher = BRANCH.matcher(meta);
            if (branchBasedMatcher.matches()) {
                branch = branchBasedMatcher.group(1);
                continue;
            }
            Matcher tagBasedMatcher = TAG.matcher(meta);
            if (!tagBasedMatcher.matches()) continue;
            tag = tagBasedMatcher.group(1);
        }
        Preconditions.checkArgument((Stream.of(snapshotId, asOfTimestamp, branch, tag).filter(x$0 -> Objects.nonNull(x$0)).count() <= 1L ? 1 : 0) != 0, (String)"Can specify only one of snapshot-id (%s), as-of-timestamp (%s), branch (%s), tag (%s)", (Object)snapshotId, (Object)asOfTimestamp, (Object)branch, tag);
        Table table = TABLE_CACHE.get(key);
        if (table == null) {
            throw new NoSuchTableException(ident);
        }
        if (snapshotId != null) {
            return Pair.of((Object)table, (Object)snapshotId);
        }
        if (asOfTimestamp != null) {
            return Pair.of((Object)table, (Object)SnapshotUtil.snapshotIdAsOfTime((Table)table, (long)asOfTimestamp));
        }
        if (branch != null) {
            Snapshot branchSnapshot = table.snapshot(branch);
            Preconditions.checkArgument((branchSnapshot != null ? 1 : 0) != 0, (String)"Cannot find snapshot associated with branch name: %s", (Object)branch);
            return Pair.of((Object)table, (Object)branchSnapshot.snapshotId());
        }
        if (tag != null) {
            Snapshot tagSnapshot = table.snapshot(tag);
            Preconditions.checkArgument((tagSnapshot != null ? 1 : 0) != 0, (String)"Cannot find snapshot associated with tag name: %s", (Object)tag);
            return Pair.of((Object)table, (Object)tagSnapshot.snapshotId());
        }
        return Pair.of((Object)table, null);
    }

    private Pair<String, List<String>> parseIdent(Identifier ident) {
        int hashIndex = ident.name().lastIndexOf(35);
        if (hashIndex != -1 && !ident.name().endsWith("#")) {
            String key = ident.name().substring(0, hashIndex);
            List metadata = COMMA.splitToList((CharSequence)ident.name().substring(hashIndex + 1));
            return Pair.of((Object)key, (Object)metadata);
        }
        return Pair.of((Object)ident.name(), (Object)ImmutableList.of());
    }
}

