/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.iceberg.Schema;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;

public class PruneColumnsWithReordering
extends TypeUtil.CustomOrderSchemaVisitor<Type> {
    private final StructType requestedType;
    private final Set<Integer> filterRefs;
    private DataType current = null;
    private static final ImmutableMap<Type.TypeID, Set<Class<? extends DataType>>> TYPES = ImmutableMap.builder().put((Object)Type.TypeID.BOOLEAN, (Object)ImmutableSet.of(BooleanType$.class)).put((Object)Type.TypeID.INTEGER, (Object)ImmutableSet.of(IntegerType$.class)).put((Object)Type.TypeID.LONG, (Object)ImmutableSet.of(LongType$.class)).put((Object)Type.TypeID.FLOAT, (Object)ImmutableSet.of(FloatType$.class)).put((Object)Type.TypeID.DOUBLE, (Object)ImmutableSet.of(DoubleType$.class)).put((Object)Type.TypeID.DATE, (Object)ImmutableSet.of(DateType$.class)).put((Object)Type.TypeID.TIMESTAMP, (Object)ImmutableSet.of(TimestampType$.class, TimestampNTZType$.class)).put((Object)Type.TypeID.DECIMAL, (Object)ImmutableSet.of(DecimalType.class)).put((Object)Type.TypeID.UUID, (Object)ImmutableSet.of(StringType$.class)).put((Object)Type.TypeID.STRING, (Object)ImmutableSet.of(StringType$.class)).put((Object)Type.TypeID.FIXED, (Object)ImmutableSet.of(BinaryType$.class)).put((Object)Type.TypeID.BINARY, (Object)ImmutableSet.of(BinaryType.class)).buildOrThrow();

    PruneColumnsWithReordering(StructType requestedType, Set<Integer> filterRefs) {
        this.requestedType = requestedType;
        this.filterRefs = filterRefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type schema(Schema schema, Supplier<Type> structResult) {
        this.current = this.requestedType;
        try {
            Type type = structResult.get();
            return type;
        }
        finally {
            this.current = null;
        }
    }

    public Type struct(Types.StructType struct, Iterable<Type> fieldResults) {
        Preconditions.checkNotNull((Object)struct, (Object)"Cannot prune null struct. Pruning must start with a schema.");
        Preconditions.checkArgument((boolean)(this.current instanceof StructType), (String)"Not a struct: %s", (Object)this.current);
        StructType requestedStruct = (StructType)this.current;
        List fields = struct.fields();
        ArrayList types = Lists.newArrayList(fieldResults);
        boolean changed = false;
        LinkedHashMap projectedFields = Maps.newLinkedHashMap();
        for (int i = 0; i < fields.size(); ++i) {
            Types.NestedField field = (Types.NestedField)fields.get(i);
            Type type = (Type)types.get(i);
            if (type == null) {
                changed = true;
                continue;
            }
            if (field.type() == type) {
                projectedFields.put(field.name(), field);
                continue;
            }
            if (field.isOptional()) {
                changed = true;
                projectedFields.put(field.name(), Types.NestedField.optional((int)field.fieldId(), (String)field.name(), (Type)type));
                continue;
            }
            changed = true;
            projectedFields.put(field.name(), Types.NestedField.required((int)field.fieldId(), (String)field.name(), (Type)type));
        }
        boolean reordered = false;
        StructField[] requestedFields = requestedStruct.fields();
        ArrayList newFields = Lists.newArrayListWithExpectedSize((int)requestedFields.length);
        for (int i = 0; i < requestedFields.length; ++i) {
            String name = requestedFields[i].name();
            if (!((Types.NestedField)fields.get(i)).name().equals(name)) {
                reordered = true;
            }
            newFields.add((Types.NestedField)projectedFields.remove(name));
        }
        if (!projectedFields.isEmpty()) {
            newFields.addAll(projectedFields.values());
            changed = true;
        }
        if (reordered || changed) {
            return Types.StructType.of((List)newFields);
        }
        return struct;
    }

    public Type field(Types.NestedField field, Supplier<Type> fieldResult) {
        Preconditions.checkArgument((boolean)(this.current instanceof StructType), (String)"Not a struct: %s", (Object)this.current);
        StructType requestedStruct = (StructType)this.current;
        if (requestedStruct.getFieldIndex(field.name()).isEmpty()) {
            if (this.filterRefs.contains(field.fieldId())) {
                return field.type();
            }
            return null;
        }
        int fieldIndex = requestedStruct.fieldIndex(field.name());
        StructField requestedField = requestedStruct.fields()[fieldIndex];
        Preconditions.checkArgument((requestedField.nullable() || field.isRequired() ? 1 : 0) != 0, (String)"Cannot project an optional field as non-null: %s", (Object)field.name());
        this.current = requestedField.dataType();
        try {
            Type type = fieldResult.get();
            return type;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid projection for field " + field.name() + ": " + e.getMessage(), e);
        }
        finally {
            this.current = requestedStruct;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type list(Types.ListType list, Supplier<Type> elementResult) {
        Preconditions.checkArgument((boolean)(this.current instanceof ArrayType), (String)"Not an array: %s", (Object)this.current);
        ArrayType requestedArray = (ArrayType)this.current;
        Preconditions.checkArgument((requestedArray.containsNull() || !list.isElementOptional() ? 1 : 0) != 0, (String)"Cannot project an array of optional elements as required elements: %s", (Object)requestedArray);
        this.current = requestedArray.elementType();
        try {
            Type elementType = elementResult.get();
            if (list.elementType() == elementType) {
                Types.ListType listType = list;
                return listType;
            }
            if (list.isElementOptional()) {
                Types.ListType listType = Types.ListType.ofOptional((int)list.elementId(), (Type)elementType);
                return listType;
            }
            Types.ListType listType = Types.ListType.ofRequired((int)list.elementId(), (Type)elementType);
            return listType;
        }
        finally {
            this.current = requestedArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type map(Types.MapType map, Supplier<Type> keyResult, Supplier<Type> valueResult) {
        Preconditions.checkArgument((boolean)(this.current instanceof MapType), (String)"Not a map: %s", (Object)this.current);
        MapType requestedMap = (MapType)this.current;
        Preconditions.checkArgument((requestedMap.valueContainsNull() || !map.isValueOptional() ? 1 : 0) != 0, (String)"Cannot project a map of optional values as required values: %s", (Object)map);
        Preconditions.checkArgument((boolean)(requestedMap.keyType() instanceof StringType), (String)"Invalid map key type (not string): %s", (Object)requestedMap.keyType());
        this.current = requestedMap.valueType();
        try {
            Type valueType = valueResult.get();
            if (map.valueType() == valueType) {
                Types.MapType mapType = map;
                return mapType;
            }
            if (map.isValueOptional()) {
                Types.MapType mapType = Types.MapType.ofOptional((int)map.keyId(), (int)map.valueId(), (Type)map.keyType(), (Type)valueType);
                return mapType;
            }
            Types.MapType mapType = Types.MapType.ofRequired((int)map.keyId(), (int)map.valueId(), (Type)map.keyType(), (Type)valueType);
            return mapType;
        }
        finally {
            this.current = requestedMap;
        }
    }

    public Type primitive(Type.PrimitiveType primitive) {
        Set expectedType = (Set)TYPES.get((Object)primitive.typeId());
        Preconditions.checkArgument((expectedType != null && expectedType.contains(this.current.getClass()) ? 1 : 0) != 0, (String)"Cannot project %s to incompatible type: %s", (Object)primitive, (Object)this.current);
        switch (primitive.typeId()) {
            case DECIMAL: {
                Types.DecimalType decimal = (Types.DecimalType)primitive;
                DecimalType requestedDecimal = (DecimalType)this.current;
                Preconditions.checkArgument((requestedDecimal.scale() == decimal.scale() ? 1 : 0) != 0, (String)"Cannot project decimal with incompatible scale: %s != %s", (int)requestedDecimal.scale(), (int)decimal.scale());
                Preconditions.checkArgument((requestedDecimal.precision() >= decimal.precision() ? 1 : 0) != 0, (String)"Cannot project decimal with incompatible precision: %s < %s", (int)requestedDecimal.precision(), (int)decimal.precision());
                break;
            }
            case TIMESTAMP: {
                Types.TimestampType timestamp = (Types.TimestampType)primitive;
                Preconditions.checkArgument((boolean)timestamp.shouldAdjustToUTC(), (Object)"Cannot project timestamp (without time zone) as timestamptz (with time zone)");
                break;
            }
        }
        return primitive;
    }
}

