/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;

class JavaUtils {
    private static final Map<String, TimeUnit> TIME_SUFFIXES = ImmutableMap.builder().put((Object)"us", (Object)TimeUnit.MICROSECONDS).put((Object)"ms", (Object)TimeUnit.MILLISECONDS).put((Object)"s", (Object)TimeUnit.SECONDS).put((Object)"m", (Object)TimeUnit.MINUTES).put((Object)"min", (Object)TimeUnit.MINUTES).put((Object)"h", (Object)TimeUnit.HOURS).put((Object)"d", (Object)TimeUnit.DAYS).build();

    private JavaUtils() {
    }

    public static long timeStringAsSec(String str) {
        return JavaUtils.timeStringAs(str, TimeUnit.SECONDS);
    }

    public static long timeStringAs(String str, TimeUnit unit) {
        String lower = str.toLowerCase(Locale.ROOT).trim();
        try {
            Matcher matcher = Pattern.compile("(-?[0-9]+)([a-z]+)?").matcher(lower);
            if (!matcher.matches()) {
                throw new NumberFormatException("Failed to parse time string: " + str);
            }
            long val = Long.parseLong(matcher.group(1));
            String suffix = matcher.group(2);
            if (suffix != null && !TIME_SUFFIXES.containsKey(suffix)) {
                throw new NumberFormatException("Invalid suffix: \"" + suffix + "\"");
            }
            return unit.convert(val, suffix != null ? TIME_SUFFIXES.get(suffix) : unit);
        }
        catch (NumberFormatException e) {
            String timeError = "Time must be specified as seconds (s), milliseconds (ms), microseconds (us), minutes (m or min), hour (h), or day (d). E.g. 50s, 100ms, or 250us.";
            throw new NumberFormatException(timeError + "\n" + e.getMessage());
        }
    }
}

