/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.util.function.Function;
import org.apache.iceberg.spark.SparkTypeToType;
import org.apache.iceberg.spark.SparkValueConverter;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.util.SerializableFunction;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;

public class IcebergSpark {
    private IcebergSpark() {
    }

    public static void registerBucketUDF(SparkSession session, String funcName, DataType sourceType, int numBuckets) {
        SparkTypeToType typeConverter = new SparkTypeToType();
        Type sourceIcebergType = typeConverter.atomic(sourceType);
        SerializableFunction bucket = Transforms.bucket((int)numBuckets).bind(sourceIcebergType);
        session.udf().register(funcName, arg_0 -> IcebergSpark.lambda$registerBucketUDF$5dd06d70$1((Function)bucket, sourceIcebergType, arg_0), DataTypes.IntegerType);
    }

    public static void registerTruncateUDF(SparkSession session, String funcName, DataType sourceType, int width) {
        SparkTypeToType typeConverter = new SparkTypeToType();
        Type sourceIcebergType = typeConverter.atomic(sourceType);
        SerializableFunction truncate = Transforms.truncate((int)width).bind(sourceIcebergType);
        session.udf().register(funcName, arg_0 -> IcebergSpark.lambda$registerTruncateUDF$64c84435$1((Function)truncate, sourceIcebergType, arg_0), sourceType);
    }

    private static /* synthetic */ Object lambda$registerTruncateUDF$64c84435$1(Function truncate, Type sourceIcebergType, Object value) throws Exception {
        return truncate.apply(SparkValueConverter.convert(sourceIcebergType, value));
    }

    private static /* synthetic */ Object lambda$registerBucketUDF$5dd06d70$1(Function bucket, Type sourceIcebergType, Object value) throws Exception {
        return bucket.apply(SparkValueConverter.convert(sourceIcebergType, value));
    }
}

