/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.sql;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.spark.SparkCatalogTestBase;
import org.apache.iceberg.spark.SparkSessionCatalog;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.joda.time.DateTime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runners.Parameterized;

public class TestTimestampWithoutZone
extends SparkCatalogTestBase {
    private static final String newTableName = "created_table";
    private final Map<String, String> config;
    private static final Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"ts", (Type)Types.TimestampType.withoutZone()), Types.NestedField.required((int)3, (String)"tsz", (Type)Types.TimestampType.withZone())});
    private final List<Object[]> values = ImmutableList.of((Object)this.row(1L, this.toLocalDateTime("2021-01-01T00:00:00.0"), this.toTimestamp("2021-02-01T00:00:00.0")), (Object)this.row(2L, this.toLocalDateTime("2021-01-01T00:00:00.0"), this.toTimestamp("2021-02-01T00:00:00.0")), (Object)this.row(3L, this.toLocalDateTime("2021-01-01T00:00:00.0"), this.toTimestamp("2021-02-01T00:00:00.0")));

    @Parameterized.Parameters(name="catalogName = {0}, implementation = {1}, config = {2}")
    public static Object[][] parameters() {
        return new Object[][]{{"spark_catalog", SparkSessionCatalog.class.getName(), ImmutableMap.of((Object)"type", (Object)"hive", (Object)"default-namespace", (Object)"default", (Object)"parquet-enabled", (Object)"true", (Object)"cache-enabled", (Object)"false")}};
    }

    public TestTimestampWithoutZone(String catalogName, String implementation, Map<String, String> config) {
        super(catalogName, implementation, config);
        this.config = config;
    }

    @Before
    public void createTables() {
        this.validationCatalog.createTable(this.tableIdent, schema);
    }

    @After
    public void removeTables() {
        this.validationCatalog.dropTable(this.tableIdent, true);
        this.sql("DROP TABLE IF EXISTS %s", newTableName);
    }

    @Test
    public void testDeprecatedTimezoneProperty() {
        this.withSQLConf((Map<String, String>)ImmutableMap.of((Object)"spark.sql.iceberg.use-timestamp-without-timezone-in-new-tables", (Object)"true"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> spark.sessionState().catalogManager().currentCatalog().initialize(catalog.name(), new CaseInsensitiveStringMap(this.config))).isInstanceOf(UnsupportedOperationException.class)).hasMessage("Spark configuration spark.sql.iceberg.use-timestamp-without-timezone-in-new-tables is not supported in Spark 3.4 due to the introduction of native support for timestamp without timezone."));
    }

    @Test
    public void testReadWithDeprecatedTimezoneProperty() {
        this.withSQLConf((Map<String, String>)ImmutableMap.of((Object)"spark.sql.iceberg.handle-timestamp-without-timezone", (Object)"true"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("SELECT count(*) FROM %s", this.tableName)).isInstanceOf(UnsupportedOperationException.class)).hasMessage("Spark configuration spark.sql.iceberg.handle-timestamp-without-timezone is not supported in Spark 3.4 due to the introduction of native support for timestamp without timezone."));
    }

    @Test
    public void testReadWithDeprecatedTimezonePropertyReadOption() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> spark.read().option("handle-timestamp-without-timezone", "true").table(this.tableName).count()).isInstanceOf(UnsupportedOperationException.class)).hasMessage("Option handle-timestamp-without-timezone is not supported in Spark 3.4 due to the introduction of native support for timestamp without timezone.");
    }

    @Test
    public void testWriteWithDeprecatedTimezoneProperty() {
        this.withSQLConf((Map<String, String>)ImmutableMap.of((Object)"spark.sql.iceberg.handle-timestamp-without-timezone", (Object)"true", (Object)"spark.sql.legacy.createHiveTableByDefault", (Object)"false"), () -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CREATE OR REPLACE TABLE %s USING ICEBERG AS SELECT * FROM %s", newTableName, this.tableName)).isInstanceOf(UnsupportedOperationException.class)).hasMessage("Spark configuration spark.sql.iceberg.handle-timestamp-without-timezone is not supported in Spark 3.4 due to the introduction of native support for timestamp without timezone."));
    }

    @Test
    public void testWriteWithDeprecatedTimezonePropertyReadOption() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.withSQLConf((Map<String, String>)ImmutableMap.of((Object)"spark.sql.legacy.createHiveTableByDefault", (Object)"false"), () -> spark.read().table(this.tableName).writeTo(newTableName).option("handle-timestamp-without-timezone", "true").using("iceberg").createOrReplace())).isInstanceOf(UnsupportedOperationException.class)).hasMessage("Option handle-timestamp-without-timezone is not supported in Spark 3.4 due to the introduction of native support for timestamp without timezone.");
    }

    @Test
    public void testAppendTimestampWithoutZone() {
        this.sql("INSERT INTO %s VALUES %s", this.tableName, this.rowToSqlValues((List<Object[]>)ImmutableList.of((Object)this.row(1L, this.toLocalDateTime("2021-01-01T00:00:00.0"), this.toLocalDateTime("2021-02-01T00:00:00.0")))));
    }

    @Test
    public void testAppendTimestampWithZone() {
        this.sql("INSERT INTO %s VALUES %s", this.tableName, this.rowToSqlValues((List<Object[]>)ImmutableList.of((Object)this.row(1L, this.toTimestamp("2021-01-01T00:00:00.0"), this.toTimestamp("2021-02-01T00:00:00.0")))));
    }

    @Test
    public void testCreateAsSelectWithTimestampWithoutZone() {
        this.sql("INSERT INTO %s VALUES %s", this.tableName, this.rowToSqlValues(this.values));
        this.sql("CREATE TABLE %s USING iceberg AS SELECT * FROM %s", newTableName, this.tableName);
        Assert.assertEquals((String)("Should have " + this.values.size() + " row"), (Object)this.values.size(), (Object)this.scalarSql("SELECT count(*) FROM %s", newTableName));
        this.assertEquals("Row data should match expected", this.sql("SELECT * FROM %s ORDER BY id", this.tableName), this.sql("SELECT * FROM %s ORDER BY id", newTableName));
    }

    @Test
    public void testCreateNewTableShouldHaveTimestampWithZoneIcebergType() {
        this.sql("INSERT INTO %s VALUES %s", this.tableName, this.rowToSqlValues(this.values));
        this.sql("CREATE TABLE %s USING iceberg AS SELECT * FROM %s", newTableName, this.tableName);
        Assert.assertEquals((String)("Should have " + this.values.size() + " row"), (Object)this.values.size(), (Object)this.scalarSql("SELECT count(*) FROM %s", newTableName));
        this.assertEquals("Data from created table should match data from base table", this.sql("SELECT * FROM %s ORDER BY id", this.tableName), this.sql("SELECT * FROM %s ORDER BY id", newTableName));
        Table createdTable = this.validationCatalog.loadTable(TableIdentifier.of((String[])new String[]{"default", newTableName}));
        this.assertFieldsType(createdTable.schema(), (Type.PrimitiveType)Types.TimestampType.withoutZone(), "ts");
        this.assertFieldsType(createdTable.schema(), (Type.PrimitiveType)Types.TimestampType.withZone(), "tsz");
    }

    @Test
    public void testCreateNewTableShouldHaveTimestampWithoutZoneIcebergType() {
        spark.sessionState().catalogManager().currentCatalog().initialize(catalog.name(), new CaseInsensitiveStringMap(this.config));
        this.sql("INSERT INTO %s VALUES %s", this.tableName, this.rowToSqlValues(this.values));
        this.sql("CREATE TABLE %s USING iceberg AS SELECT * FROM %s", newTableName, this.tableName);
        Assert.assertEquals((String)("Should have " + this.values.size() + " row"), (Object)this.values.size(), (Object)this.scalarSql("SELECT count(*) FROM %s", newTableName));
        this.assertEquals("Row data should match expected", this.sql("SELECT * FROM %s ORDER BY id", this.tableName), this.sql("SELECT * FROM %s ORDER BY id", newTableName));
        Table createdTable = this.validationCatalog.loadTable(TableIdentifier.of((String[])new String[]{"default", newTableName}));
        this.assertFieldsType(createdTable.schema(), (Type.PrimitiveType)Types.TimestampType.withoutZone(), "ts");
        this.assertFieldsType(createdTable.schema(), (Type.PrimitiveType)Types.TimestampType.withZone(), "tsz");
    }

    private Timestamp toTimestamp(String value) {
        return new Timestamp(DateTime.parse((String)value).getMillis());
    }

    private LocalDateTime toLocalDateTime(String value) {
        return LocalDateTime.parse(value);
    }

    private String rowToSqlValues(List<Object[]> rows) {
        List rowValues = rows.stream().map(row -> {
            List columns = Arrays.stream(row).map(value -> {
                if (value instanceof Long) {
                    return value.toString();
                }
                if (value instanceof Timestamp) {
                    return String.format("timestamp '%s'", value);
                }
                if (value instanceof LocalDateTime) {
                    return String.format("timestamp_ntz '%s'", value);
                }
                throw new RuntimeException("Type is not supported");
            }).collect(Collectors.toList());
            return "(" + Joiner.on((String)",").join(columns) + ")";
        }).collect(Collectors.toList());
        return Joiner.on((String)",").join(rowValues);
    }

    private void assertFieldsType(Schema actual, Type.PrimitiveType expected, String ... fields) {
        actual.select(fields).asStruct().fields().forEach(field -> Assert.assertEquals((Object)expected, (Object)field.type()));
    }
}

