/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.sql;

import java.util.Map;
import org.apache.iceberg.Table;
import org.apache.iceberg.spark.sql.PartitionedWritesTestBase;
import org.junit.Before;

public class TestPartitionedWritesToBranch
extends PartitionedWritesTestBase {
    private static final String BRANCH = "test";

    public TestPartitionedWritesToBranch(String catalogName, String implementation, Map<String, String> config) {
        super(catalogName, implementation, config);
    }

    @Override
    @Before
    public void createTables() {
        super.createTables();
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.manageSnapshots().createBranch(BRANCH, table.currentSnapshot().snapshotId()).commit();
        this.sql("REFRESH TABLE " + this.tableName, new Object[0]);
    }

    @Override
    protected String commitTarget() {
        return String.format("%s.branch_%s", this.tableName, BRANCH);
    }

    @Override
    protected String selectTarget() {
        return String.format("%s VERSION AS OF '%s'", this.tableName, BRANCH);
    }
}

