/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.sql;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Streams;
import org.apache.iceberg.spark.SparkCatalogTestBase;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class TestDropTable
extends SparkCatalogTestBase {
    public TestDropTable(String catalogName, String implementation, Map<String, String> config) {
        super(catalogName, implementation, config);
    }

    @Before
    public void createTable() {
        this.sql("CREATE TABLE %s (id INT, name STRING) USING iceberg", this.tableName);
        this.sql("INSERT INTO %s VALUES (1, 'test')", this.tableName);
    }

    @After
    public void removeTable() throws IOException {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName);
    }

    @Test
    public void testDropTable() throws IOException {
        this.dropTableInternal();
    }

    @Test
    public void testDropTableGCDisabled() throws IOException {
        this.sql("ALTER TABLE %s SET TBLPROPERTIES (gc.enabled = false)", this.tableName);
        this.dropTableInternal();
    }

    private void dropTableInternal() throws IOException {
        this.assertEquals("Should have expected rows", (List<Object[]>)ImmutableList.of((Object)this.row(1, "test")), this.sql("SELECT * FROM %s", this.tableName));
        List<String> manifestAndFiles = this.manifestsAndFiles();
        Assert.assertEquals((String)"There should be 2 files for manifests and files", (long)2L, (long)manifestAndFiles.size());
        Assert.assertTrue((String)"All files should be existed", (boolean)this.checkFilesExist(manifestAndFiles, true));
        this.sql("DROP TABLE %s", this.tableName);
        Assert.assertFalse((String)"Table should not exist", (boolean)this.validationCatalog.tableExists(this.tableIdent));
        if (this.catalogName.equals("testhadoop")) {
            Assert.assertTrue((String)"All files should be deleted", (boolean)this.checkFilesExist(manifestAndFiles, false));
        } else {
            Assert.assertTrue((String)"All files should not be deleted", (boolean)this.checkFilesExist(manifestAndFiles, true));
        }
    }

    @Ignore
    public void testPurgeTable() throws IOException {
        this.assertEquals("Should have expected rows", (List<Object[]>)ImmutableList.of((Object)this.row(1, "test")), this.sql("SELECT * FROM %s", this.tableName));
        List<String> manifestAndFiles = this.manifestsAndFiles();
        Assert.assertEquals((String)"There should be 2 files for manifests and files", (long)2L, (long)manifestAndFiles.size());
        Assert.assertTrue((String)"All files should exist", (boolean)this.checkFilesExist(manifestAndFiles, true));
        this.sql("DROP TABLE %s PURGE", this.tableName);
        Assert.assertFalse((String)"Table should not exist", (boolean)this.validationCatalog.tableExists(this.tableIdent));
        Assert.assertTrue((String)"All files should be deleted", (boolean)this.checkFilesExist(manifestAndFiles, false));
    }

    @Ignore
    public void testPurgeTableGCDisabled() throws IOException {
        this.sql("ALTER TABLE %s SET TBLPROPERTIES (gc.enabled = false)", this.tableName);
        this.assertEquals("Should have expected rows", (List<Object[]>)ImmutableList.of((Object)this.row(1, "test")), this.sql("SELECT * FROM %s", this.tableName));
        List<String> manifestAndFiles = this.manifestsAndFiles();
        Assert.assertEquals((String)"There totally should have 2 files for manifests and files", (long)2L, (long)manifestAndFiles.size());
        Assert.assertTrue((String)"All files should be existed", (boolean)this.checkFilesExist(manifestAndFiles, true));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("DROP TABLE %s PURGE", this.tableName)).isInstanceOf(ValidationException.class)).hasMessageContaining("Cannot purge table: GC is disabled (deleting files may corrupt other tables");
        Assert.assertTrue((String)"Table should not been dropped", (boolean)this.validationCatalog.tableExists(this.tableIdent));
        Assert.assertTrue((String)"All files should not be deleted", (boolean)this.checkFilesExist(manifestAndFiles, true));
    }

    private List<String> manifestsAndFiles() {
        List<Object[]> files = this.sql("SELECT file_path FROM %s.%s", this.tableName, MetadataTableType.FILES);
        List<Object[]> manifests = this.sql("SELECT path FROM %s.%s", this.tableName, MetadataTableType.MANIFESTS);
        return Streams.concat((Stream[])new Stream[]{files.stream(), manifests.stream()}).map(row -> (String)row[0]).collect(Collectors.toList());
    }

    private boolean checkFilesExist(List<String> files, boolean shouldExist) throws IOException {
        boolean mask;
        boolean bl = mask = !shouldExist;
        if (files.isEmpty()) {
            return mask;
        }
        FileSystem fs = new Path(files.get(0)).getFileSystem((Configuration)hiveConf);
        return files.stream().allMatch(file -> {
            try {
                return fs.exists(new Path(file)) ^ mask;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

