/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.sql;

import java.util.Map;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.spark.SparkCatalogTestBase;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.functions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestCreateTableAsSelect
extends SparkCatalogTestBase {
    private final String sourceName = this.tableName("source");

    public TestCreateTableAsSelect(String catalogName, String implementation, Map<String, String> config) {
        super(catalogName, implementation, config);
        this.sql("CREATE TABLE IF NOT EXISTS %s (id bigint NOT NULL, data string) USING iceberg PARTITIONED BY (truncate(id, 3))", this.sourceName);
        this.sql("INSERT INTO %s VALUES (1, 'a'), (2, 'b'), (3, 'c')", this.sourceName);
    }

    @After
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName);
    }

    @Test
    public void testUnpartitionedCTAS() {
        this.sql("CREATE TABLE %s USING iceberg AS SELECT * FROM %s", this.tableName, this.sourceName);
        Schema expectedSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});
        Table ctasTable = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertEquals((String)"Should have expected nullable schema", (Object)expectedSchema.asStruct(), (Object)ctasTable.schema().asStruct());
        Assert.assertEquals((String)"Should be an unpartitioned table", (long)0L, (long)ctasTable.spec().fields().size());
        this.assertEquals("Should have rows matching the source table", this.sql("SELECT * FROM %s ORDER BY id", this.sourceName), this.sql("SELECT * FROM %s ORDER BY id", this.tableName));
    }

    @Test
    public void testPartitionedCTAS() {
        this.sql("CREATE TABLE %s USING iceberg PARTITIONED BY (id) AS SELECT * FROM %s ORDER BY id", this.tableName, this.sourceName);
        Schema expectedSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});
        PartitionSpec expectedSpec = PartitionSpec.builderFor((Schema)expectedSchema).identity("id").build();
        Table ctasTable = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertEquals((String)"Should have expected nullable schema", (Object)expectedSchema.asStruct(), (Object)ctasTable.schema().asStruct());
        Assert.assertEquals((String)"Should be partitioned by id", (Object)expectedSpec, (Object)ctasTable.spec());
        this.assertEquals("Should have rows matching the source table", this.sql("SELECT * FROM %s ORDER BY id", this.sourceName), this.sql("SELECT * FROM %s ORDER BY id", this.tableName));
    }

    @Test
    public void testRTAS() {
        this.sql("CREATE TABLE %s USING iceberg TBLPROPERTIES ('prop1'='val1', 'prop2'='val2')AS SELECT * FROM %s", this.tableName, this.sourceName);
        this.assertEquals("Should have rows matching the source table", this.sql("SELECT * FROM %s ORDER BY id", this.sourceName), this.sql("SELECT * FROM %s ORDER BY id", this.tableName));
        this.sql("REPLACE TABLE %s USING iceberg PARTITIONED BY (part) TBLPROPERTIES ('prop1'='newval1', 'prop3'='val3') AS SELECT id, data, CASE WHEN (id %% 2) = 0 THEN 'even' ELSE 'odd' END AS part FROM %s ORDER BY 3, 1", this.tableName, this.sourceName);
        Schema expectedSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"part", (Type)Types.StringType.get())});
        PartitionSpec expectedSpec = PartitionSpec.builderFor((Schema)expectedSchema).identity("part").withSpecId(1).build();
        Table rtasTable = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertEquals((String)"Should have expected nullable schema", (Object)expectedSchema.asStruct(), (Object)rtasTable.schema().asStruct());
        Assert.assertEquals((String)"Should be partitioned by part", (Object)expectedSpec, (Object)rtasTable.spec());
        this.assertEquals("Should have rows matching the source table", this.sql("SELECT id, data, CASE WHEN (id %% 2) = 0 THEN 'even' ELSE 'odd' END AS part FROM %s ORDER BY id", this.sourceName), this.sql("SELECT * FROM %s ORDER BY id", this.tableName));
        Assert.assertEquals((String)"Table should have expected snapshots", (long)2L, (long)Iterables.size((Iterable)rtasTable.snapshots()));
        Assert.assertEquals((String)"Should have updated table property", (Object)"newval1", rtasTable.properties().get("prop1"));
        Assert.assertEquals((String)"Should have preserved table property", (Object)"val2", rtasTable.properties().get("prop2"));
        Assert.assertEquals((String)"Should have new table property", (Object)"val3", rtasTable.properties().get("prop3"));
    }

    @Test
    public void testCreateRTAS() {
        this.sql("CREATE OR REPLACE TABLE %s USING iceberg PARTITIONED BY (part) AS SELECT id, data, CASE WHEN (id %% 2) = 0 THEN 'even' ELSE 'odd' END AS part FROM %s ORDER BY 3, 1", this.tableName, this.sourceName);
        this.assertEquals("Should have rows matching the source table", this.sql("SELECT id, data, CASE WHEN (id %% 2) = 0 THEN 'even' ELSE 'odd' END AS part FROM %s ORDER BY id", this.sourceName), this.sql("SELECT * FROM %s ORDER BY id", this.tableName));
        this.sql("CREATE OR REPLACE TABLE %s USING iceberg PARTITIONED BY (part) AS SELECT 2 * id as id, data, CASE WHEN ((2 * id) %% 2) = 0 THEN 'even' ELSE 'odd' END AS part FROM %s ORDER BY 3, 1", this.tableName, this.sourceName);
        Schema expectedSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"part", (Type)Types.StringType.get())});
        PartitionSpec expectedSpec = PartitionSpec.builderFor((Schema)expectedSchema).identity("part").withSpecId(0).build();
        Table rtasTable = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertEquals((String)"Should have expected nullable schema", (Object)expectedSchema.asStruct(), (Object)rtasTable.schema().asStruct());
        Assert.assertEquals((String)"Should be partitioned by part", (Object)expectedSpec, (Object)rtasTable.spec());
        this.assertEquals("Should have rows matching the source table", this.sql("SELECT 2 * id, data, CASE WHEN ((2 * id) %% 2) = 0 THEN 'even' ELSE 'odd' END AS part FROM %s ORDER BY id", this.sourceName), this.sql("SELECT * FROM %s ORDER BY id", this.tableName));
        Assert.assertEquals((String)"Table should have expected snapshots", (long)2L, (long)Iterables.size((Iterable)rtasTable.snapshots()));
    }

    @Test
    public void testDataFrameV2Create() throws Exception {
        spark.table(this.sourceName).writeTo(this.tableName).using("iceberg").create();
        Schema expectedSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});
        Table ctasTable = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertEquals((String)"Should have expected nullable schema", (Object)expectedSchema.asStruct(), (Object)ctasTable.schema().asStruct());
        Assert.assertEquals((String)"Should be an unpartitioned table", (long)0L, (long)ctasTable.spec().fields().size());
        this.assertEquals("Should have rows matching the source table", this.sql("SELECT * FROM %s ORDER BY id", this.sourceName), this.sql("SELECT * FROM %s ORDER BY id", this.tableName));
    }

    @Test
    public void testDataFrameV2Replace() throws Exception {
        spark.table(this.sourceName).writeTo(this.tableName).using("iceberg").create();
        this.assertEquals("Should have rows matching the source table", this.sql("SELECT * FROM %s ORDER BY id", this.sourceName), this.sql("SELECT * FROM %s ORDER BY id", this.tableName));
        spark.table(this.sourceName).select(new Column[]{functions.col((String)"id"), functions.col((String)"data"), functions.when((Column)functions.col((String)"id").mod((Object)functions.lit((Object)2)).equalTo((Object)functions.lit((Object)0)), (Object)functions.lit((Object)"even")).otherwise((Object)"odd").as("part")}).orderBy("part", new String[]{"id"}).writeTo(this.tableName).partitionedBy(functions.col((String)"part"), new Column[0]).using("iceberg").replace();
        Schema expectedSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"part", (Type)Types.StringType.get())});
        PartitionSpec expectedSpec = PartitionSpec.builderFor((Schema)expectedSchema).identity("part").withSpecId(1).build();
        Table rtasTable = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertEquals((String)"Should have expected nullable schema", (Object)expectedSchema.asStruct(), (Object)rtasTable.schema().asStruct());
        Assert.assertEquals((String)"Should be partitioned by part", (Object)expectedSpec, (Object)rtasTable.spec());
        this.assertEquals("Should have rows matching the source table", this.sql("SELECT id, data, CASE WHEN (id %% 2) = 0 THEN 'even' ELSE 'odd' END AS part FROM %s ORDER BY id", this.sourceName), this.sql("SELECT * FROM %s ORDER BY id", this.tableName));
        Assert.assertEquals((String)"Table should have expected snapshots", (long)2L, (long)Iterables.size((Iterable)rtasTable.snapshots()));
    }

    @Test
    public void testDataFrameV2CreateOrReplace() {
        spark.table(this.sourceName).select(new Column[]{functions.col((String)"id"), functions.col((String)"data"), functions.when((Column)functions.col((String)"id").mod((Object)functions.lit((Object)2)).equalTo((Object)functions.lit((Object)0)), (Object)functions.lit((Object)"even")).otherwise((Object)"odd").as("part")}).orderBy("part", new String[]{"id"}).writeTo(this.tableName).partitionedBy(functions.col((String)"part"), new Column[0]).using("iceberg").createOrReplace();
        this.assertEquals("Should have rows matching the source table", this.sql("SELECT id, data, CASE WHEN (id %% 2) = 0 THEN 'even' ELSE 'odd' END AS part FROM %s ORDER BY id", this.sourceName), this.sql("SELECT * FROM %s ORDER BY id", this.tableName));
        spark.table(this.sourceName).select(new Column[]{functions.col((String)"id").multiply((Object)functions.lit((Object)2)).as("id"), functions.col((String)"data")}).select(new Column[]{functions.col((String)"id"), functions.col((String)"data"), functions.when((Column)functions.col((String)"id").mod((Object)functions.lit((Object)2)).equalTo((Object)functions.lit((Object)0)), (Object)functions.lit((Object)"even")).otherwise((Object)"odd").as("part")}).orderBy("part", new String[]{"id"}).writeTo(this.tableName).partitionedBy(functions.col((String)"part"), new Column[0]).using("iceberg").createOrReplace();
        Schema expectedSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"part", (Type)Types.StringType.get())});
        PartitionSpec expectedSpec = PartitionSpec.builderFor((Schema)expectedSchema).identity("part").withSpecId(0).build();
        Table rtasTable = this.validationCatalog.loadTable(this.tableIdent);
        Assert.assertEquals((String)"Should have expected nullable schema", (Object)expectedSchema.asStruct(), (Object)rtasTable.schema().asStruct());
        Assert.assertEquals((String)"Should be partitioned by part", (Object)expectedSpec, (Object)rtasTable.spec());
        this.assertEquals("Should have rows matching the source table", this.sql("SELECT 2 * id, data, CASE WHEN ((2 * id) %% 2) = 0 THEN 'even' ELSE 'odd' END AS part FROM %s ORDER BY id", this.sourceName), this.sql("SELECT * FROM %s ORDER BY id", this.tableName));
        Assert.assertEquals((String)"Table should have expected snapshots", (long)2L, (long)Iterables.size((Iterable)rtasTable.snapshots()));
    }

    @Test
    public void testCreateRTASWithPartitionSpecChanging() {
        this.sql("CREATE OR REPLACE TABLE %s USING iceberg PARTITIONED BY (part) AS SELECT id, data, CASE WHEN (id %% 2) = 0 THEN 'even' ELSE 'odd' END AS part FROM %s ORDER BY 3, 1", this.tableName, this.sourceName);
        Table rtasTable = this.validationCatalog.loadTable(this.tableIdent);
        this.assertEquals("Should have rows matching the source table", this.sql("SELECT id, data, CASE WHEN (id %% 2) = 0 THEN 'even' ELSE 'odd' END AS part FROM %s ORDER BY id", this.sourceName), this.sql("SELECT * FROM %s ORDER BY id", this.tableName));
        rtasTable.updateSpec().removeField("part").commit();
        this.sql("CREATE OR REPLACE TABLE %s USING iceberg PARTITIONED BY (part, id) AS SELECT 2 * id as id, data, CASE WHEN ((2 * id) %% 2) = 0 THEN 'even' ELSE 'odd' END AS part FROM %s ORDER BY 3, 1", this.tableName, this.sourceName);
        Schema expectedSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"part", (Type)Types.StringType.get())});
        PartitionSpec expectedSpec = PartitionSpec.builderFor((Schema)expectedSchema).identity("part").identity("id").withSpecId(2).build();
        Assert.assertEquals((String)"Should be partitioned by part and id", (Object)expectedSpec, (Object)rtasTable.spec());
        Assert.assertEquals((String)"Should have expected nullable schema", (Object)expectedSchema.asStruct(), (Object)rtasTable.schema().asStruct());
        this.assertEquals("Should have rows matching the source table", this.sql("SELECT 2 * id, data, CASE WHEN ((2 * id) %% 2) = 0 THEN 'even' ELSE 'odd' END AS part FROM %s ORDER BY id", this.sourceName), this.sql("SELECT * FROM %s ORDER BY id", this.tableName));
        Assert.assertEquals((String)"Table should have expected snapshots", (long)2L, (long)Iterables.size((Iterable)rtasTable.snapshots()));
    }
}

