/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.sql;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.hive.HiveCatalog;
import org.apache.iceberg.hive.TestHiveMetastore;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.SparkCatalogTestBase;
import org.apache.iceberg.spark.SparkTestBase;
import org.apache.spark.sql.SparkSession;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestAggregatePushDown
extends SparkCatalogTestBase {
    public TestAggregatePushDown(String catalogName, String implementation, Map<String, String> config) {
        super(catalogName, implementation, config);
    }

    @BeforeClass
    public static void startMetastoreAndSpark() {
        SparkTestBase.metastore = new TestHiveMetastore();
        metastore.start();
        SparkTestBase.hiveConf = metastore.hiveConf();
        SparkTestBase.spark = SparkSession.builder().master("local[2]").config("spark.sql.iceberg.aggregate_pushdown", "true").enableHiveSupport().getOrCreate();
        SparkTestBase.catalog = (HiveCatalog)CatalogUtil.loadCatalog((String)HiveCatalog.class.getName(), (String)"hive", (Map)ImmutableMap.of(), (Object)hiveConf);
        try {
            catalog.createNamespace(Namespace.of((String[])new String[]{"default"}));
        }
        catch (AlreadyExistsException alreadyExistsException) {
            // empty catch block
        }
    }

    @After
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName);
    }

    @Test
    public void testDifferentDataTypesAggregatePushDownInPartitionedTable() {
        this.testDifferentDataTypesAggregatePushDown(true);
    }

    @Test
    public void testDifferentDataTypesAggregatePushDownInNonPartitionedTable() {
        this.testDifferentDataTypesAggregatePushDown(false);
    }

    private void testDifferentDataTypesAggregatePushDown(boolean hasPartitionCol) {
        String createTable = hasPartitionCol ? "CREATE TABLE %s (id LONG, int_data INT, boolean_data BOOLEAN, float_data FLOAT, double_data DOUBLE, decimal_data DECIMAL(14, 2), binary_data binary) USING iceberg PARTITIONED BY (id)" : "CREATE TABLE %s (id LONG, int_data INT, boolean_data BOOLEAN, float_data FLOAT, double_data DOUBLE, decimal_data DECIMAL(14, 2), binary_data binary) USING iceberg";
        this.sql(createTable, this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, null, false, null, null, 11.11, X'1111'), (1, null, true, 2.222, 2.222222, 22.22, X'2222'), (2, 33, false, 3.333, 3.333333, 33.33, X'3333'), (2, 44, true, null, 4.444444, 44.44, X'4444'), (3, 55, false, 5.555, 5.555555, 55.55, X'5555'), (3, null, true, null, 6.666666, 66.66, null) ", this.tableName);
        String select = "SELECT count(*), max(id), min(id), count(id), max(int_data), min(int_data), count(int_data), max(boolean_data), min(boolean_data), count(boolean_data), max(float_data), min(float_data), count(float_data), max(double_data), min(double_data), count(double_data), max(decimal_data), min(decimal_data), count(decimal_data), max(binary_data), min(binary_data), count(binary_data) FROM %s";
        List<Object[]> explain = this.sql("EXPLAIN " + select, this.tableName);
        String explainString = explain.get(0)[0].toString().toLowerCase(Locale.ROOT);
        boolean explainContainsPushDownAggregates = false;
        if (explainString.contains("count(*)") && explainString.contains("max(id)") && explainString.contains("min(id)") && explainString.contains("count(id)") && explainString.contains("max(int_data)") && explainString.contains("min(int_data)") && explainString.contains("count(int_data)") && explainString.contains("max(boolean_data)") && explainString.contains("min(boolean_data)") && explainString.contains("count(boolean_data)") && explainString.contains("max(float_data)") && explainString.contains("min(float_data)") && explainString.contains("count(float_data)") && explainString.contains("max(double_data)") && explainString.contains("min(double_data)") && explainString.contains("count(double_data)") && explainString.contains("max(decimal_data)") && explainString.contains("min(decimal_data)") && explainString.contains("count(decimal_data)") && explainString.contains("max(binary_data)") && explainString.contains("min(binary_data)") && explainString.contains("count(binary_data)")) {
            explainContainsPushDownAggregates = true;
        }
        Assert.assertTrue((String)"explain should contain the pushed down aggregates", (boolean)explainContainsPushDownAggregates);
        List<Object[]> actual = this.sql(select, this.tableName);
        ArrayList expected = Lists.newArrayList();
        expected.add(new Object[]{6L, 3L, 1L, 6L, 55, 33, 3L, true, false, 6L, Float.valueOf(5.555f), Float.valueOf(2.222f), 3L, 6.666666, 2.222222, 5L, new BigDecimal("66.66"), new BigDecimal("11.11"), 6L, new byte[]{85, 85}, new byte[]{17, 17}, 5L});
        this.assertEquals("min/max/count push down", expected, actual);
    }

    @Test
    public void testDateAndTimestampWithPartition() {
        this.sql("CREATE TABLE %s (id bigint, data string, d date, ts timestamp) USING iceberg PARTITIONED BY (id)", this.tableName);
        this.sql("INSERT INTO %s VALUES (1, '1', date('2021-11-10'), null),(1, '2', date('2021-11-11'), timestamp('2021-11-11 22:22:22')), (2, '3', date('2021-11-12'), timestamp('2021-11-12 22:22:22')), (2, '4', date('2021-11-13'), timestamp('2021-11-13 22:22:22')), (3, '5', null, timestamp('2021-11-14 22:22:22')), (3, '6', date('2021-11-14'), null)", this.tableName);
        String select = "SELECT max(d), min(d), count(d), max(ts), min(ts), count(ts) FROM %s";
        List<Object[]> explain = this.sql("EXPLAIN " + select, this.tableName);
        String explainString = explain.get(0)[0].toString().toLowerCase(Locale.ROOT);
        boolean explainContainsPushDownAggregates = false;
        if (explainString.contains("max(d)") && explainString.contains("min(d)") && explainString.contains("count(d)") && explainString.contains("max(ts)") && explainString.contains("min(ts)") && explainString.contains("count(ts)")) {
            explainContainsPushDownAggregates = true;
        }
        Assert.assertTrue((String)"explain should contain the pushed down aggregates", (boolean)explainContainsPushDownAggregates);
        List<Object[]> actual = this.sql(select, this.tableName);
        ArrayList expected = Lists.newArrayList();
        expected.add(new Object[]{Date.valueOf("2021-11-14"), Date.valueOf("2021-11-10"), 5L, Timestamp.valueOf("2021-11-14 22:22:22.0"), Timestamp.valueOf("2021-11-11 22:22:22.0"), 4L});
        this.assertEquals("min/max/count push down", expected, actual);
    }

    @Test
    public void testAggregateNotPushDownIfOneCantPushDown() {
        this.sql("CREATE TABLE %s (id LONG, data DOUBLE) USING iceberg", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 1111), (1, 2222), (2, 3333), (2, 4444), (3, 5555), (3, 6666) ", this.tableName);
        String select = "SELECT COUNT(data), SUM(data) FROM %s";
        List<Object[]> explain = this.sql("EXPLAIN " + select, this.tableName);
        String explainString = explain.get(0)[0].toString().toLowerCase(Locale.ROOT);
        boolean explainContainsPushDownAggregates = false;
        if (explainString.contains("count(data)")) {
            explainContainsPushDownAggregates = true;
        }
        Assert.assertFalse((String)"explain should not contain the pushed down aggregates", (boolean)explainContainsPushDownAggregates);
        List<Object[]> actual = this.sql(select, this.tableName);
        ArrayList expected = Lists.newArrayList();
        expected.add(new Object[]{6L, 23331.0});
        this.assertEquals("expected and actual should equal", expected, actual);
    }

    @Test
    public void testAggregatePushDownWithMetricsMode() {
        this.sql("CREATE TABLE %s (id LONG, data DOUBLE) USING iceberg", this.tableName);
        this.sql("ALTER TABLE %s SET TBLPROPERTIES('%s' '%s')", this.tableName, "write.metadata.metrics.default", "none");
        this.sql("ALTER TABLE %s SET TBLPROPERTIES('%s' '%s')", this.tableName, "write.metadata.metrics.column.id", "counts");
        this.sql("ALTER TABLE %s SET TBLPROPERTIES('%s' '%s')", this.tableName, "write.metadata.metrics.column.data", "none");
        this.sql("INSERT INTO TABLE %s VALUES (1, 1111), (1, 2222), (2, 3333), (2, 4444), (3, 5555), (3, 6666)", this.tableName);
        String select1 = "SELECT COUNT(data) FROM %s";
        List<Object[]> explain1 = this.sql("EXPLAIN " + select1, this.tableName);
        String explainString1 = explain1.get(0)[0].toString().toLowerCase(Locale.ROOT);
        boolean explainContainsPushDownAggregates = false;
        if (explainString1.contains("count(data)")) {
            explainContainsPushDownAggregates = true;
        }
        Assert.assertFalse((String)"explain should not contain the pushed down aggregates", (boolean)explainContainsPushDownAggregates);
        List<Object[]> actual1 = this.sql(select1, this.tableName);
        ArrayList expected1 = Lists.newArrayList();
        expected1.add(new Object[]{6L});
        this.assertEquals("expected and actual should equal", expected1, actual1);
        String select2 = "SELECT COUNT(id) FROM %s";
        List<Object[]> explain2 = this.sql("EXPLAIN " + select2, this.tableName);
        String explainString2 = explain2.get(0)[0].toString().toLowerCase(Locale.ROOT);
        if (explainString2.contains("count(id)")) {
            explainContainsPushDownAggregates = true;
        }
        Assert.assertTrue((String)"explain should contain the pushed down aggregates", (boolean)explainContainsPushDownAggregates);
        List<Object[]> actual2 = this.sql(select2, this.tableName);
        ArrayList expected2 = Lists.newArrayList();
        expected2.add(new Object[]{6L});
        this.assertEquals("expected and actual should equal", expected2, actual2);
        String select3 = "SELECT COUNT(id), MAX(id) FROM %s";
        explainContainsPushDownAggregates = false;
        List<Object[]> explain3 = this.sql("EXPLAIN " + select3, this.tableName);
        String explainString3 = explain3.get(0)[0].toString().toLowerCase(Locale.ROOT);
        if (explainString3.contains("count(id)")) {
            explainContainsPushDownAggregates = true;
        }
        Assert.assertFalse((String)"explain should not contain the pushed down aggregates", (boolean)explainContainsPushDownAggregates);
        List<Object[]> actual3 = this.sql(select3, this.tableName);
        ArrayList expected3 = Lists.newArrayList();
        expected3.add(new Object[]{6L, 3L});
        this.assertEquals("expected and actual should equal", expected3, actual3);
    }

    @Test
    public void testAggregateNotPushDownForStringType() {
        this.sql("CREATE TABLE %s (id LONG, data STRING) USING iceberg", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, '1111'), (1, '2222'), (2, '3333'), (2, '4444'), (3, '5555'), (3, '6666') ", this.tableName);
        this.sql("ALTER TABLE %s SET TBLPROPERTIES('%s' '%s')", this.tableName, "write.metadata.metrics.default", "truncate(16)");
        String select1 = "SELECT MAX(id), MAX(data) FROM %s";
        List<Object[]> explain1 = this.sql("EXPLAIN " + select1, this.tableName);
        String explainString1 = explain1.get(0)[0].toString().toLowerCase(Locale.ROOT);
        boolean explainContainsPushDownAggregates = false;
        if (explainString1.contains("max(id)")) {
            explainContainsPushDownAggregates = true;
        }
        Assert.assertFalse((String)"explain should not contain the pushed down aggregates", (boolean)explainContainsPushDownAggregates);
        List<Object[]> actual1 = this.sql(select1, this.tableName);
        ArrayList expected1 = Lists.newArrayList();
        expected1.add(new Object[]{3L, "6666"});
        this.assertEquals("expected and actual should equal", expected1, actual1);
        String select2 = "SELECT COUNT(data) FROM %s";
        List<Object[]> explain2 = this.sql("EXPLAIN " + select2, this.tableName);
        String explainString2 = explain2.get(0)[0].toString().toLowerCase(Locale.ROOT);
        if (explainString2.contains("count(data)")) {
            explainContainsPushDownAggregates = true;
        }
        Assert.assertTrue((String)"explain should contain the pushed down aggregates", (boolean)explainContainsPushDownAggregates);
        List<Object[]> actual2 = this.sql(select2, this.tableName);
        ArrayList expected2 = Lists.newArrayList();
        expected2.add(new Object[]{6L});
        this.assertEquals("expected and actual should equal", expected2, actual2);
        explainContainsPushDownAggregates = false;
        this.sql("ALTER TABLE %s SET TBLPROPERTIES('%s' '%s')", this.tableName, "write.metadata.metrics.default", "full");
        String select3 = "SELECT count(data), max(data) FROM %s";
        List<Object[]> explain3 = this.sql("EXPLAIN " + select3, this.tableName);
        String explainString3 = explain3.get(0)[0].toString().toLowerCase(Locale.ROOT);
        if (explainString3.contains("count(data)") && explainString3.contains("max(data)")) {
            explainContainsPushDownAggregates = true;
        }
        Assert.assertTrue((String)"explain should contain the pushed down aggregates", (boolean)explainContainsPushDownAggregates);
        List<Object[]> actual3 = this.sql(select3, this.tableName);
        ArrayList expected3 = Lists.newArrayList();
        expected3.add(new Object[]{6L, "6666"});
        this.assertEquals("expected and actual should equal", expected3, actual3);
    }

    @Test
    public void testAggregatePushDownWithDataFilter() {
        this.testAggregatePushDownWithFilter(false);
    }

    @Test
    public void testAggregatePushDownWithPartitionFilter() {
        this.testAggregatePushDownWithFilter(true);
    }

    private void testAggregatePushDownWithFilter(boolean partitionFilerOnly) {
        String createTable = !partitionFilerOnly ? "CREATE TABLE %s (id LONG, data INT) USING iceberg" : "CREATE TABLE %s (id LONG, data INT) USING iceberg PARTITIONED BY (id)";
        this.sql(createTable, this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 11), (1, 22), (2, 33), (2, 44), (3, 55), (3, 66) ", this.tableName);
        String select = "SELECT MIN(data) FROM %s WHERE id > 1";
        List<Object[]> explain = this.sql("EXPLAIN " + select, this.tableName);
        String explainString = explain.get(0)[0].toString().toLowerCase(Locale.ROOT);
        boolean explainContainsPushDownAggregates = false;
        if (explainString.contains("min(data)")) {
            explainContainsPushDownAggregates = true;
        }
        if (!partitionFilerOnly) {
            Assert.assertFalse((String)"explain should not contain the pushed down aggregates", (boolean)explainContainsPushDownAggregates);
        } else {
            Assert.assertTrue((String)"explain should contain the pushed down aggregates", (boolean)explainContainsPushDownAggregates);
        }
        List<Object[]> actual = this.sql(select, this.tableName);
        ArrayList expected = Lists.newArrayList();
        expected.add(new Object[]{33});
        this.assertEquals("expected and actual should equal", expected, actual);
    }

    @Test
    public void testAggregateWithComplexType() {
        this.sql("CREATE TABLE %s (id INT, complex STRUCT<c1:INT,c2:STRING>) USING iceberg", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, named_struct(\"c1\", 3, \"c2\", \"v1\")),(2, named_struct(\"c1\", 2, \"c2\", \"v2\")), (3, null)", this.tableName);
        String select1 = "SELECT count(complex), count(id) FROM %s";
        List<Object[]> explain = this.sql("EXPLAIN " + select1, this.tableName);
        String explainString = explain.get(0)[0].toString().toLowerCase(Locale.ROOT);
        boolean explainContainsPushDownAggregates = false;
        if (explainString.contains("count(complex)")) {
            explainContainsPushDownAggregates = true;
        }
        Assert.assertFalse((String)"count not pushed down for complex types", (boolean)explainContainsPushDownAggregates);
        List<Object[]> actual = this.sql(select1, this.tableName);
        ArrayList expected = Lists.newArrayList();
        expected.add(new Object[]{2L, 3L});
        this.assertEquals("count not push down", actual, expected);
        String select2 = "SELECT max(complex) FROM %s";
        explain = this.sql("EXPLAIN " + select2, this.tableName);
        explainString = explain.get(0)[0].toString().toLowerCase(Locale.ROOT);
        explainContainsPushDownAggregates = false;
        if (explainString.contains("max(complex)")) {
            explainContainsPushDownAggregates = true;
        }
        Assert.assertFalse((String)"max not pushed down for complex types", (boolean)explainContainsPushDownAggregates);
    }

    @Test
    public void testAggregatePushDownInDeleteCopyOnWrite() {
        this.sql("CREATE TABLE %s (id LONG, data INT) USING iceberg", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 1111), (1, 2222), (2, 3333), (2, 4444), (3, 5555), (3, 6666) ", this.tableName);
        this.sql("DELETE FROM %s WHERE data = 1111", this.tableName);
        String select = "SELECT max(data), min(data), count(data) FROM %s";
        List<Object[]> explain = this.sql("EXPLAIN " + select, this.tableName);
        String explainString = explain.get(0)[0].toString().toLowerCase(Locale.ROOT);
        boolean explainContainsPushDownAggregates = false;
        if (explainString.contains("max(data)") && explainString.contains("min(data)") && explainString.contains("count(data)")) {
            explainContainsPushDownAggregates = true;
        }
        Assert.assertTrue((String)"min/max/count pushed down for deleted", (boolean)explainContainsPushDownAggregates);
        List<Object[]> actual = this.sql(select, this.tableName);
        ArrayList expected = Lists.newArrayList();
        expected.add(new Object[]{6666, 2222, 5L});
        this.assertEquals("min/max/count push down", expected, actual);
    }

    @Test
    public void testAggregatePushDownForTimeTravel() {
        this.sql("CREATE TABLE %s (id LONG, data INT) USING iceberg", this.tableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, 1111), (1, 2222), (2, 3333), (2, 4444), (3, 5555), (3, 6666) ", this.tableName);
        long snapshotId = this.validationCatalog.loadTable(this.tableIdent).currentSnapshot().snapshotId();
        List<Object[]> expected1 = this.sql("SELECT count(id) FROM %s", this.tableName);
        this.sql("INSERT INTO %s VALUES (4, 7777), (5, 8888)", this.tableName);
        List<Object[]> expected2 = this.sql("SELECT count(id) FROM %s", this.tableName);
        List<Object[]> explain1 = this.sql("EXPLAIN SELECT count(id) FROM %s VERSION AS OF %s", this.tableName, snapshotId);
        String explainString1 = explain1.get(0)[0].toString().toLowerCase(Locale.ROOT);
        boolean explainContainsPushDownAggregates1 = false;
        if (explainString1.contains("count(id)")) {
            explainContainsPushDownAggregates1 = true;
        }
        Assert.assertTrue((String)"count pushed down", (boolean)explainContainsPushDownAggregates1);
        List<Object[]> actual1 = this.sql("SELECT count(id) FROM %s VERSION AS OF %s", this.tableName, snapshotId);
        this.assertEquals("count push down", expected1, actual1);
        List<Object[]> explain2 = this.sql("EXPLAIN SELECT count(id) FROM %s", this.tableName);
        String explainString2 = explain2.get(0)[0].toString().toLowerCase(Locale.ROOT);
        boolean explainContainsPushDownAggregates2 = false;
        if (explainString2.contains("count(id)")) {
            explainContainsPushDownAggregates2 = true;
        }
        Assert.assertTrue((String)"count pushed down", (boolean)explainContainsPushDownAggregates2);
        List<Object[]> actual2 = this.sql("SELECT count(id) FROM %s", this.tableName);
        this.assertEquals("count push down", expected2, actual2);
    }

    @Test
    public void testAllNull() {
        this.sql("CREATE TABLE %s (id int, data int) USING iceberg PARTITIONED BY (id)", this.tableName);
        this.sql("INSERT INTO %s VALUES (1, null),(1, null), (2, null), (2, null), (3, null), (3, null)", this.tableName);
        String select = "SELECT count(*), max(data), min(data), count(data) FROM %s";
        List<Object[]> explain = this.sql("EXPLAIN " + select, this.tableName);
        String explainString = explain.get(0)[0].toString().toLowerCase(Locale.ROOT);
        boolean explainContainsPushDownAggregates = false;
        if (explainString.contains("max(data)") && explainString.contains("min(data)") && explainString.contains("count(data)")) {
            explainContainsPushDownAggregates = true;
        }
        Assert.assertTrue((String)"explain should contain the pushed down aggregates", (boolean)explainContainsPushDownAggregates);
        List<Object[]> actual = this.sql(select, this.tableName);
        ArrayList expected = Lists.newArrayList();
        expected.add(new Object[]{6L, null, null, 0L});
        this.assertEquals("min/max/count push down", expected, actual);
    }

    @Test
    public void testAllNaN() {
        this.sql("CREATE TABLE %s (id int, data float) USING iceberg PARTITIONED BY (id)", this.tableName);
        this.sql("INSERT INTO %s VALUES (1, float('nan')),(1, float('nan')), (2, float('nan')), (2, float('nan')), (3, float('nan')), (3, float('nan'))", this.tableName);
        String select = "SELECT count(*), max(data), min(data), count(data) FROM %s";
        List<Object[]> explain = this.sql("EXPLAIN " + select, this.tableName);
        String explainString = explain.get(0)[0].toString().toLowerCase(Locale.ROOT);
        boolean explainContainsPushDownAggregates = false;
        if (explainString.contains("max(data)") || explainString.contains("min(data)") || explainString.contains("count(data)")) {
            explainContainsPushDownAggregates = true;
        }
        Assert.assertFalse((String)"explain should not contain the pushed down aggregates", (boolean)explainContainsPushDownAggregates);
        List<Object[]> actual = this.sql(select, this.tableName);
        ArrayList expected = Lists.newArrayList();
        expected.add(new Object[]{6L, Float.valueOf(Float.NaN), Float.valueOf(Float.NaN), 6L});
        this.assertEquals("expected and actual should equal", expected, actual);
    }

    @Test
    public void testNaN() {
        this.sql("CREATE TABLE %s (id int, data float) USING iceberg PARTITIONED BY (id)", this.tableName);
        this.sql("INSERT INTO %s VALUES (1, float('nan')),(1, float('nan')), (2, 2), (2, float('nan')), (3, float('nan')), (3, 1)", this.tableName);
        String select = "SELECT count(*), max(data), min(data), count(data) FROM %s";
        List<Object[]> explain = this.sql("EXPLAIN " + select, this.tableName);
        String explainString = explain.get(0)[0].toString().toLowerCase(Locale.ROOT);
        boolean explainContainsPushDownAggregates = false;
        if (explainString.contains("max(data)") || explainString.contains("min(data)") || explainString.contains("count(data)")) {
            explainContainsPushDownAggregates = true;
        }
        Assert.assertFalse((String)"explain should not contain the pushed down aggregates", (boolean)explainContainsPushDownAggregates);
        List<Object[]> actual = this.sql(select, this.tableName);
        ArrayList expected = Lists.newArrayList();
        expected.add(new Object[]{6L, Float.valueOf(Float.NaN), Float.valueOf(1.0f), 6L});
        this.assertEquals("expected and actual should equal", expected, actual);
    }

    @Test
    public void testInfinity() {
        this.sql("CREATE TABLE %s (id int, data1 float, data2 double, data3 double) USING iceberg PARTITIONED BY (id)", this.tableName);
        this.sql("INSERT INTO %s VALUES (1, float('-infinity'), double('infinity'), 1.23), (1, float('-infinity'), double('infinity'), -1.23), (1, float('-infinity'), double('infinity'), double('infinity')), (1, float('-infinity'), double('infinity'), 2.23), (1, float('-infinity'), double('infinity'), double('-infinity')), (1, float('-infinity'), double('infinity'), -2.23)", this.tableName);
        String select = "SELECT count(*), max(data1), min(data1), count(data1), max(data2), min(data2), count(data2), max(data3), min(data3), count(data3) FROM %s";
        List<Object[]> explain = this.sql("EXPLAIN " + select, this.tableName);
        String explainString = explain.get(0)[0].toString().toLowerCase(Locale.ROOT);
        boolean explainContainsPushDownAggregates = false;
        if (explainString.contains("max(data1)") && explainString.contains("min(data1)") && explainString.contains("count(data1)") && explainString.contains("max(data2)") && explainString.contains("min(data2)") && explainString.contains("count(data2)") && explainString.contains("max(data3)") && explainString.contains("min(data3)") && explainString.contains("count(data3)")) {
            explainContainsPushDownAggregates = true;
        }
        Assert.assertTrue((String)"explain should contain the pushed down aggregates", (boolean)explainContainsPushDownAggregates);
        List<Object[]> actual = this.sql(select, this.tableName);
        ArrayList expected = Lists.newArrayList();
        expected.add(new Object[]{6L, Float.valueOf(Float.NEGATIVE_INFINITY), Float.valueOf(Float.NEGATIVE_INFINITY), 6L, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 6L, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 6L});
        this.assertEquals("min/max/count push down", expected, actual);
    }
}

