/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.Map;
import org.apache.iceberg.spark.SparkCatalogTestBase;
import org.apache.iceberg.spark.source.SparkTable;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.connector.catalog.CatalogManager;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSparkTable
extends SparkCatalogTestBase {
    public TestSparkTable(String catalogName, String implementation, Map<String, String> config) {
        super(catalogName, implementation, config);
    }

    @Before
    public void createTable() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", this.tableName);
    }

    @After
    public void removeTable() {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName);
    }

    @Test
    public void testTableEquality() throws NoSuchTableException {
        CatalogManager catalogManager = spark.sessionState().catalogManager();
        TableCatalog catalog = (TableCatalog)catalogManager.catalog(this.catalogName);
        Identifier identifier = Identifier.of((String[])this.tableIdent.namespace().levels(), (String)this.tableIdent.name());
        SparkTable table1 = (SparkTable)catalog.loadTable(identifier);
        SparkTable table2 = (SparkTable)catalog.loadTable(identifier);
        Assert.assertNotSame((String)"References must be different", (Object)table1, (Object)table2);
        Assert.assertEquals((String)"Tables must be equivalent", (Object)table1, (Object)table2);
    }
}

