/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.ManifestReader;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.spark.SparkDataFile;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.data.RandomData;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.ColumnName;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestSparkDataFile {
    private static final HadoopTables TABLES = new HadoopTables(new Configuration());
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)100, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)101, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)102, (String)"b", (Type)Types.BooleanType.get()), Types.NestedField.optional((int)103, (String)"i", (Type)Types.IntegerType.get()), Types.NestedField.required((int)104, (String)"l", (Type)Types.LongType.get()), Types.NestedField.optional((int)105, (String)"f", (Type)Types.FloatType.get()), Types.NestedField.required((int)106, (String)"d", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)107, (String)"date", (Type)Types.DateType.get()), Types.NestedField.required((int)108, (String)"ts", (Type)Types.TimestampType.withZone()), Types.NestedField.required((int)109, (String)"tsntz", (Type)Types.TimestampType.withoutZone()), Types.NestedField.required((int)110, (String)"s", (Type)Types.StringType.get()), Types.NestedField.optional((int)113, (String)"bytes", (Type)Types.BinaryType.get()), Types.NestedField.required((int)114, (String)"dec_9_0", (Type)Types.DecimalType.of((int)9, (int)0)), Types.NestedField.required((int)115, (String)"dec_11_2", (Type)Types.DecimalType.of((int)11, (int)2)), Types.NestedField.required((int)116, (String)"dec_38_10", (Type)Types.DecimalType.of((int)38, (int)10))});
    private static final PartitionSpec SPEC = PartitionSpec.builderFor((Schema)SCHEMA).identity("b").bucket("i", 2).identity("l").identity("f").identity("d").identity("date").hour("ts").identity("ts").identity("tsntz").truncate("s", 2).identity("bytes").bucket("dec_9_0", 2).bucket("dec_11_2", 2).bucket("dec_38_10", 2).build();
    private static SparkSession spark;
    private static JavaSparkContext sparkContext;
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private String tableLocation = null;

    @BeforeClass
    public static void startSpark() {
        spark = SparkSession.builder().master("local[2]").getOrCreate();
        sparkContext = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
    }

    @AfterClass
    public static void stopSpark() {
        SparkSession currentSpark = spark;
        spark = null;
        sparkContext = null;
        currentSpark.stop();
    }

    @Before
    public void setupTableLocation() throws Exception {
        File tableDir = this.temp.newFolder();
        this.tableLocation = tableDir.toURI().toString();
    }

    @Test
    public void testValueConversion() throws IOException {
        Table table = TABLES.create(SCHEMA, PartitionSpec.unpartitioned(), (Map)Maps.newHashMap(), this.tableLocation);
        this.checkSparkDataFile(table);
    }

    @Test
    public void testValueConversionPartitionedTable() throws IOException {
        Table table = TABLES.create(SCHEMA, SPEC, (Map)Maps.newHashMap(), this.tableLocation);
        this.checkSparkDataFile(table);
    }

    @Test
    public void testValueConversionWithEmptyStats() throws IOException {
        HashMap props = Maps.newHashMap();
        props.put("write.metadata.metrics.default", "none");
        Table table = TABLES.create(SCHEMA, SPEC, (Map)props, this.tableLocation);
        this.checkSparkDataFile(table);
    }

    private void checkSparkDataFile(Table table) throws IOException {
        Iterable<InternalRow> rows = RandomData.generateSpark(table.schema(), 200, 0L);
        JavaRDD rdd = sparkContext.parallelize((List)Lists.newArrayList(rows));
        Dataset df = spark.internalCreateDataFrame(JavaRDD.toRDD((JavaRDD)rdd), SparkSchemaUtil.convert((Schema)table.schema()), false);
        df.write().format("iceberg").mode("append").save(this.tableLocation);
        table.refresh();
        List manifests = table.currentSnapshot().allManifests(table.io());
        Assert.assertEquals((String)"Should have 1 manifest", (long)1L, (long)manifests.size());
        ArrayList dataFiles = Lists.newArrayList();
        try (ManifestReader reader = ManifestFiles.read((ManifestFile)((ManifestFile)manifests.get(0)), (FileIO)table.io());){
            for (DataFile dataFile : reader) {
                this.checkDataFile((DataFile)dataFile.copy(), DataFiles.builder((PartitionSpec)table.spec()).copy(dataFile).build());
                dataFiles.add((DataFile)dataFile.copy());
            }
        }
        Dataset dataFileDF = spark.read().format("iceberg").load(this.tableLocation + "#files");
        List columns = Arrays.stream(dataFileDF.columns()).map(ColumnName::new).collect(Collectors.toList());
        Collections.shuffle(columns);
        List sparkDataFiles = dataFileDF.select((Column[])Iterables.toArray(columns, Column.class)).collectAsList();
        Assert.assertEquals((String)"The number of files should match", (long)dataFiles.size(), (long)sparkDataFiles.size());
        Types.StructType dataFileType = DataFile.getType((Types.StructType)table.spec().partitionType());
        StructType sparkDataFileType = ((Row)sparkDataFiles.get(0)).schema();
        SparkDataFile wrapper = new SparkDataFile(dataFileType, sparkDataFileType);
        for (int i = 0; i < dataFiles.size(); ++i) {
            this.checkDataFile((DataFile)dataFiles.get(i), (DataFile)wrapper.wrap((Row)sparkDataFiles.get(i)));
        }
    }

    private void checkDataFile(DataFile expected, DataFile actual) {
        Assert.assertEquals((String)"Path must match", (Object)expected.path(), (Object)actual.path());
        Assert.assertEquals((String)"Format must match", (Object)expected.format(), (Object)actual.format());
        Assert.assertEquals((String)"Record count must match", (long)expected.recordCount(), (long)actual.recordCount());
        Assert.assertEquals((String)"Size must match", (long)expected.fileSizeInBytes(), (long)actual.fileSizeInBytes());
        Assert.assertEquals((String)"Record value counts must match", (Object)expected.valueCounts(), (Object)actual.valueCounts());
        Assert.assertEquals((String)"Record null value counts must match", (Object)expected.nullValueCounts(), (Object)actual.nullValueCounts());
        Assert.assertEquals((String)"Record nan value counts must match", (Object)expected.nanValueCounts(), (Object)actual.nanValueCounts());
        Assert.assertEquals((String)"Lower bounds must match", (Object)expected.lowerBounds(), (Object)actual.lowerBounds());
        Assert.assertEquals((String)"Upper bounds must match", (Object)expected.upperBounds(), (Object)actual.upperBounds());
        Assert.assertEquals((String)"Key metadata must match", (Object)expected.keyMetadata(), (Object)actual.keyMetadata());
        Assert.assertEquals((String)"Split offsets must match", (Object)expected.splitOffsets(), (Object)actual.splitOffsets());
        Assert.assertEquals((String)"Sort order id must match", (Object)expected.sortOrderId(), (Object)actual.sortOrderId());
        this.checkStructLike(expected.partition(), actual.partition());
    }

    private void checkStructLike(StructLike expected, StructLike actual) {
        Assert.assertEquals((String)"Struct size should match", (long)expected.size(), (long)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            Assert.assertEquals((String)"Struct values must match", (Object)expected.get(i, Object.class), (Object)actual.get(i, Object.class));
        }
    }

    static {
        sparkContext = null;
    }
}

