/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.List;
import java.util.Map;
import org.apache.iceberg.ReplaceSortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.spark.SparkCatalogTestBase;
import org.apache.iceberg.spark.source.ThreeColumnRecord;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Test;

public class TestRequiredDistributionAndOrdering
extends SparkCatalogTestBase {
    public TestRequiredDistributionAndOrdering(String catalogName, String implementation, Map<String, String> config) {
        super(catalogName, implementation, config);
    }

    @After
    public void dropTestTable() {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName);
    }

    @Test
    public void testDefaultLocalSort() throws NoSuchTableException {
        this.sql("CREATE TABLE %s (c1 INT, c2 STRING, c3 STRING) USING iceberg PARTITIONED BY (c3)", this.tableName);
        ImmutableList data = ImmutableList.of((Object)new ThreeColumnRecord(1, null, "A"), (Object)new ThreeColumnRecord(2, "BBBBBBBBBB", "B"), (Object)new ThreeColumnRecord(3, "BBBBBBBBBB", "A"), (Object)new ThreeColumnRecord(4, "BBBBBBBBBB", "B"), (Object)new ThreeColumnRecord(5, "BBBBBBBBBB", "A"), (Object)new ThreeColumnRecord(6, "BBBBBBBBBB", "B"), (Object)new ThreeColumnRecord(7, "BBBBBBBBBB", "A"));
        Dataset ds = spark.createDataFrame((List)data, ThreeColumnRecord.class);
        Dataset inputDF = ds.coalesce(1).sortWithinPartitions("c1", new String[0]);
        inputDF.writeTo(this.tableName).append();
        this.assertEquals("Row count must match", (List<Object[]>)ImmutableList.of((Object)this.row(7L)), this.sql("SELECT count(*) FROM %s", this.tableName));
    }

    @Test
    public void testPartitionColumnsArePrependedForRangeDistribution() throws NoSuchTableException {
        this.sql("CREATE TABLE %s (c1 INT, c2 STRING, c3 STRING) USING iceberg PARTITIONED BY (c3)", this.tableName);
        ImmutableList data = ImmutableList.of((Object)new ThreeColumnRecord(1, null, "A"), (Object)new ThreeColumnRecord(2, "BBBBBBBBBB", "B"), (Object)new ThreeColumnRecord(3, "BBBBBBBBBB", "A"), (Object)new ThreeColumnRecord(4, "BBBBBBBBBB", "B"), (Object)new ThreeColumnRecord(5, "BBBBBBBBBB", "A"), (Object)new ThreeColumnRecord(6, "BBBBBBBBBB", "B"), (Object)new ThreeColumnRecord(7, "BBBBBBBBBB", "A"));
        Dataset ds = spark.createDataFrame((List)data, ThreeColumnRecord.class);
        Dataset inputDF = ds.coalesce(1).sortWithinPartitions("c1", new String[0]);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.distribution-mode", "range").commit();
        ((ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc("c1")).asc("c2")).commit();
        inputDF.writeTo(this.tableName).append();
        this.assertEquals("Row count must match", (List<Object[]>)ImmutableList.of((Object)this.row(7L)), this.sql("SELECT count(*) FROM %s", this.tableName));
    }

    @Test
    public void testSortOrderIncludesPartitionColumns() throws NoSuchTableException {
        this.sql("CREATE TABLE %s (c1 INT, c2 STRING, c3 STRING) USING iceberg PARTITIONED BY (c3)", this.tableName);
        ImmutableList data = ImmutableList.of((Object)new ThreeColumnRecord(1, null, "A"), (Object)new ThreeColumnRecord(2, "BBBBBBBBBB", "B"), (Object)new ThreeColumnRecord(3, "BBBBBBBBBB", "A"), (Object)new ThreeColumnRecord(4, "BBBBBBBBBB", "B"), (Object)new ThreeColumnRecord(5, "BBBBBBBBBB", "A"), (Object)new ThreeColumnRecord(6, "BBBBBBBBBB", "B"), (Object)new ThreeColumnRecord(7, "BBBBBBBBBB", "A"));
        Dataset ds = spark.createDataFrame((List)data, ThreeColumnRecord.class);
        Dataset inputDF = ds.coalesce(1).sortWithinPartitions("c1", new String[0]);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((ReplaceSortOrder)((ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc("c3")).asc("c1")).asc("c2")).commit();
        inputDF.writeTo(this.tableName).append();
        this.assertEquals("Row count must match", (List<Object[]>)ImmutableList.of((Object)this.row(7L)), this.sql("SELECT count(*) FROM %s", this.tableName));
    }

    @Test
    public void testDisabledDistributionAndOrdering() {
        this.sql("CREATE TABLE %s (c1 INT, c2 STRING, c3 STRING) USING iceberg PARTITIONED BY (c3)", this.tableName);
        ImmutableList data = ImmutableList.of((Object)new ThreeColumnRecord(1, null, "A"), (Object)new ThreeColumnRecord(2, "BBBBBBBBBB", "B"), (Object)new ThreeColumnRecord(3, "BBBBBBBBBB", "A"), (Object)new ThreeColumnRecord(4, "BBBBBBBBBB", "B"), (Object)new ThreeColumnRecord(5, "BBBBBBBBBB", "A"), (Object)new ThreeColumnRecord(6, "BBBBBBBBBB", "B"), (Object)new ThreeColumnRecord(7, "BBBBBBBBBB", "A"));
        Dataset ds = spark.createDataFrame((List)data, ThreeColumnRecord.class);
        Dataset inputDF = ds.coalesce(1).sortWithinPartitions("c1", new String[0]);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> inputDF.writeTo(this.tableName).option("use-table-distribution-and-ordering", "false").append()).cause().isInstanceOf(IllegalStateException.class)).hasMessageStartingWith("Incoming records violate the writer assumption that records are clustered by spec and by partition within each spec. Either cluster the incoming records or switch to fanout writers.");
    }

    @Test
    public void testHashDistribution() throws NoSuchTableException {
        this.sql("CREATE TABLE %s (c1 INT, c2 STRING, c3 STRING) USING iceberg PARTITIONED BY (c3)", this.tableName);
        ImmutableList data = ImmutableList.of((Object)new ThreeColumnRecord(1, null, "A"), (Object)new ThreeColumnRecord(2, "BBBBBBBBBB", "B"), (Object)new ThreeColumnRecord(3, "BBBBBBBBBB", "A"), (Object)new ThreeColumnRecord(4, "BBBBBBBBBB", "B"), (Object)new ThreeColumnRecord(5, "BBBBBBBBBB", "A"), (Object)new ThreeColumnRecord(6, "BBBBBBBBBB", "B"), (Object)new ThreeColumnRecord(7, "BBBBBBBBBB", "A"));
        Dataset ds = spark.createDataFrame((List)data, ThreeColumnRecord.class);
        Dataset inputDF = ds.coalesce(1).sortWithinPartitions("c1", new String[0]);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.distribution-mode", "hash").commit();
        ((ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc("c1")).asc("c2")).commit();
        inputDF.writeTo(this.tableName).append();
        this.assertEquals("Row count must match", (List<Object[]>)ImmutableList.of((Object)this.row(7L)), this.sql("SELECT count(*) FROM %s", this.tableName));
    }

    @Test
    public void testSortBucketTransformsWithoutExtensions() throws NoSuchTableException {
        this.sql("CREATE TABLE %s (c1 INT, c2 STRING, c3 STRING) USING iceberg PARTITIONED BY (bucket(2, c1))", this.tableName);
        ImmutableList data = ImmutableList.of((Object)new ThreeColumnRecord(1, null, "A"), (Object)new ThreeColumnRecord(2, "BBBB", "B"), (Object)new ThreeColumnRecord(3, "BBBB", "B"), (Object)new ThreeColumnRecord(4, "BBBB", "B"));
        Dataset ds = spark.createDataFrame((List)data, ThreeColumnRecord.class);
        Dataset inputDF = ds.coalesce(1).sortWithinPartitions("c1", new String[0]);
        inputDF.writeTo(this.tableName).append();
        ImmutableList expected = ImmutableList.of((Object)this.row(1, null, "A"), (Object)this.row(2, "BBBB", "B"), (Object)this.row(3, "BBBB", "B"), (Object)this.row(4, "BBBB", "B"));
        this.assertEquals("Rows must match", (List<Object[]>)expected, this.sql("SELECT * FROM %s ORDER BY c1", this.tableName));
    }

    @Test
    public void testRangeDistributionWithQuotedColumnsNames() throws NoSuchTableException {
        this.sql("CREATE TABLE %s (c1 INT, c2 STRING, `c.3` STRING) USING iceberg PARTITIONED BY (`c.3`)", this.tableName);
        ImmutableList data = ImmutableList.of((Object)new ThreeColumnRecord(1, null, "A"), (Object)new ThreeColumnRecord(2, "BBBBBBBBBB", "B"), (Object)new ThreeColumnRecord(3, "BBBBBBBBBB", "A"), (Object)new ThreeColumnRecord(4, "BBBBBBBBBB", "B"), (Object)new ThreeColumnRecord(5, "BBBBBBBBBB", "A"), (Object)new ThreeColumnRecord(6, "BBBBBBBBBB", "B"), (Object)new ThreeColumnRecord(7, "BBBBBBBBBB", "A"));
        Dataset ds = spark.createDataFrame((List)data, ThreeColumnRecord.class);
        Dataset inputDF = ds.selectExpr(new String[]{"c1", "c2", "c3 as `c.3`"}).coalesce(1).sortWithinPartitions("c1", new String[0]);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.distribution-mode", "range").commit();
        ((ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc("c1")).asc("c2")).commit();
        inputDF.writeTo(this.tableName).append();
        this.assertEquals("Row count must match", (List<Object[]>)ImmutableList.of((Object)this.row(7L)), this.sql("SELECT count(*) FROM %s", this.tableName));
    }

    @Test
    public void testHashDistributionWithQuotedColumnsNames() throws NoSuchTableException {
        this.sql("CREATE TABLE %s (c1 INT, c2 STRING, `c``3` STRING) USING iceberg PARTITIONED BY (`c``3`)", this.tableName);
        ImmutableList data = ImmutableList.of((Object)new ThreeColumnRecord(1, null, "A"), (Object)new ThreeColumnRecord(2, "BBBBBBBBBB", "B"), (Object)new ThreeColumnRecord(3, "BBBBBBBBBB", "A"), (Object)new ThreeColumnRecord(4, "BBBBBBBBBB", "B"), (Object)new ThreeColumnRecord(5, "BBBBBBBBBB", "A"), (Object)new ThreeColumnRecord(6, "BBBBBBBBBB", "B"), (Object)new ThreeColumnRecord(7, "BBBBBBBBBB", "A"));
        Dataset ds = spark.createDataFrame((List)data, ThreeColumnRecord.class);
        Dataset inputDF = ds.selectExpr(new String[]{"c1", "c2", "c3 as `c``3`"}).coalesce(1).sortWithinPartitions("c1", new String[0]);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.distribution-mode", "hash").commit();
        ((ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc("c1")).asc("c2")).commit();
        inputDF.writeTo(this.tableName).append();
        this.assertEquals("Row count must match", (List<Object[]>)ImmutableList.of((Object)this.row(7L)), this.sql("SELECT count(*) FROM %s", this.tableName));
    }
}

