/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.AvroFSInput;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.ManifestReader;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.RowLevelOperationMode;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.spark.SparkCatalogConfig;
import org.apache.iceberg.spark.SparkCatalogTestBase;
import org.apache.iceberg.spark.actions.RewritePositionDeleteFilesSparkAction;
import org.apache.iceberg.spark.actions.SparkActions;
import org.apache.iceberg.spark.source.SimpleRecord;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.assertj.core.api.Assertions;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestCompressionSettings
extends SparkCatalogTestBase {
    private static final Configuration CONF = new Configuration();
    private static final String tableName = "testWriteData";
    private static SparkSession spark = null;
    private final FileFormat format;
    private final ImmutableMap<String, String> properties;
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    @Parameterized.Parameters(name="format = {0}, properties = {1}")
    public static Object[][] parameters() {
        return new Object[][]{{"parquet", ImmutableMap.of((Object)"spark.sql.iceberg.compression-codec", (Object)"zstd", (Object)"spark.sql.iceberg.compression-level", (Object)"1")}, {"parquet", ImmutableMap.of((Object)"spark.sql.iceberg.compression-codec", (Object)"gzip")}, {"orc", ImmutableMap.of((Object)"spark.sql.iceberg.compression-codec", (Object)"zstd", (Object)"spark.sql.iceberg.compression-strategy", (Object)"speed")}, {"orc", ImmutableMap.of((Object)"spark.sql.iceberg.compression-codec", (Object)"zstd", (Object)"spark.sql.iceberg.compression-strategy", (Object)"compression")}, {"avro", ImmutableMap.of((Object)"spark.sql.iceberg.compression-codec", (Object)"snappy", (Object)"spark.sql.iceberg.compression-level", (Object)"3")}};
    }

    @BeforeClass
    public static void startSpark() {
        spark = SparkSession.builder().master("local[2]").getOrCreate();
    }

    @Parameterized.AfterParam
    public static void clearSourceCache() {
        spark.sql(String.format("DROP TABLE IF EXISTS %s", tableName));
    }

    @AfterClass
    public static void stopSpark() {
        SparkSession currentSpark = spark;
        spark = null;
        currentSpark.stop();
    }

    public TestCompressionSettings(String format, ImmutableMap properties) {
        super(SparkCatalogConfig.SPARK.catalogName(), SparkCatalogConfig.SPARK.implementation(), SparkCatalogConfig.SPARK.properties());
        this.format = FileFormat.fromString((String)format);
        this.properties = properties;
    }

    @Test
    public void testWriteDataWithDifferentSetting() throws Exception {
        InputFile inputFile;
        DeleteFile file;
        this.sql("CREATE TABLE %s (id int, data string) USING iceberg", tableName);
        HashMap tableProperties = Maps.newHashMap();
        tableProperties.put("write.parquet.compression-codec", "gzip");
        tableProperties.put("write.avro.compression-codec", "gzip");
        tableProperties.put("write.orc.compression-codec", "zlib");
        tableProperties.put("write.delete.parquet.compression-codec", "gzip");
        tableProperties.put("write.delete.avro.compression-codec", "gzip");
        tableProperties.put("write.delete.orc.compression-codec", "zlib");
        tableProperties.put("write.delete.mode", RowLevelOperationMode.MERGE_ON_READ.modeName());
        tableProperties.put("format-version", "2");
        this.sql("ALTER TABLE %s SET TBLPROPERTIES ('%s' '%s')", tableName, "write.format.default", this.format);
        this.sql("ALTER TABLE %s SET TBLPROPERTIES ('%s' '%s')", tableName, "write.delete.format.default", this.format);
        for (Map.Entry entry : tableProperties.entrySet()) {
            this.sql("ALTER TABLE %s SET TBLPROPERTIES ('%s' '%s')", tableName, entry.getKey(), entry.getValue());
        }
        ArrayList expectedOrigin = Lists.newArrayList();
        for (int i = 0; i < 1000; ++i) {
            expectedOrigin.add(new SimpleRecord(i, "hello world" + i));
        }
        Dataset df = spark.createDataFrame((List)expectedOrigin, SimpleRecord.class);
        for (Map.Entry entry : this.properties.entrySet()) {
            spark.conf().set((String)entry.getKey(), (String)entry.getValue());
        }
        df.select("id", new String[]{"data"}).writeTo(tableName).option("write-format", this.format.toString()).append();
        Table table = catalog.loadTable(TableIdentifier.of((String[])new String[]{"default", tableName}));
        List manifestFiles = table.currentSnapshot().dataManifests(table.io());
        try (ManifestReader reader = ManifestFiles.read((ManifestFile)((ManifestFile)manifestFiles.get(0)), (FileIO)table.io());){
            DataFile file2 = (DataFile)reader.iterator().next();
            InputFile inputFile2 = table.io().newInputFile(file2.path().toString());
            Assertions.assertThat((String)this.getCompressionType(inputFile2)).isEqualToIgnoringCase((CharSequence)this.properties.get((Object)"spark.sql.iceberg.compression-codec"));
        }
        this.sql("DELETE from %s where id < 100", tableName);
        table.refresh();
        List deleteManifestFiles = table.currentSnapshot().deleteManifests(table.io());
        HashMap specMap = Maps.newHashMap();
        specMap.put(0, PartitionSpec.unpartitioned());
        try (ManifestReader reader = ManifestFiles.readDeleteManifest((ManifestFile)((ManifestFile)deleteManifestFiles.get(0)), (FileIO)table.io(), (Map)specMap);){
            file = (DeleteFile)reader.iterator().next();
            inputFile = table.io().newInputFile(file.path().toString());
            Assertions.assertThat((String)this.getCompressionType(inputFile)).isEqualToIgnoringCase((CharSequence)this.properties.get((Object)"spark.sql.iceberg.compression-codec"));
        }
        ((RewritePositionDeleteFilesSparkAction)SparkActions.get((SparkSession)spark).rewritePositionDeletes(table).option("rewrite-all", "true")).execute();
        table.refresh();
        deleteManifestFiles = table.currentSnapshot().deleteManifests(table.io());
        reader = ManifestFiles.readDeleteManifest((ManifestFile)((ManifestFile)deleteManifestFiles.get(0)), (FileIO)table.io(), (Map)specMap);
        var9_12 = null;
        try {
            file = (DeleteFile)reader.iterator().next();
            inputFile = table.io().newInputFile(file.path().toString());
            Assertions.assertThat((String)this.getCompressionType(inputFile)).isEqualToIgnoringCase((CharSequence)this.properties.get((Object)"spark.sql.iceberg.compression-codec"));
        }
        catch (Throwable throwable) {
            var9_12 = throwable;
            throw throwable;
        }
        finally {
            if (reader != null) {
                TestCompressionSettings.$closeResource(var9_12, (AutoCloseable)reader);
            }
        }
    }

    private String getCompressionType(InputFile inputFile) throws Exception {
        switch (this.format) {
            case ORC: {
                OrcFile.ReaderOptions readerOptions = OrcFile.readerOptions((Configuration)CONF).useUTCTimestamp(true);
                Reader orcReader = OrcFile.createReader((Path)new Path(inputFile.location()), (OrcFile.ReaderOptions)readerOptions);
                return orcReader.getCompressionKind().name();
            }
            case PARQUET: {
                ParquetMetadata footer = ParquetFileReader.readFooter((Configuration)CONF, (Path)new Path(inputFile.location()), (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
                return ((ColumnChunkMetaData)((BlockMetaData)footer.getBlocks().get(0)).getColumns().get(0)).getCodec().name();
            }
        }
        FileContext fc = FileContext.getFileContext((Configuration)CONF);
        GenericDatumReader reader = new GenericDatumReader();
        DataFileReader fileReader = (DataFileReader)DataFileReader.openReader((SeekableInput)new AvroFSInput(fc, new Path(inputFile.location())), (DatumReader)reader);
        return fileReader.getMetaString("avro.codec");
    }
}

