/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.avro.generic.GenericData;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Files;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.spark.data.AvroDataTest;
import org.apache.iceberg.spark.data.RandomData;
import org.apache.iceberg.spark.data.TestHelpers;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;

public class TestAvroScan
extends AvroDataTest {
    private static final Configuration CONF = new Configuration();
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private static SparkSession spark = null;

    @BeforeClass
    public static void startSpark() {
        spark = SparkSession.builder().master("local[2]").getOrCreate();
    }

    @AfterClass
    public static void stopSpark() {
        SparkSession currentSpark = spark;
        spark = null;
        currentSpark.stop();
    }

    @Override
    protected void writeAndValidate(Schema schema) throws IOException {
        File parent = this.temp.newFolder("avro");
        File location = new File(parent, "test");
        File dataFolder = new File(location, "data");
        dataFolder.mkdirs();
        File avroFile = new File(dataFolder, FileFormat.AVRO.addExtension(UUID.randomUUID().toString()));
        HadoopTables tables = new HadoopTables(CONF);
        Table table = tables.create(schema, PartitionSpec.unpartitioned(), location.toString());
        Schema tableSchema = table.schema();
        List<GenericData.Record> expected = RandomData.generateList(tableSchema, 100, 1L);
        try (FileAppender writer = Avro.write((OutputFile)Files.localOutput((File)avroFile)).schema(tableSchema).build();){
            writer.addAll(expected);
        }
        DataFile file = DataFiles.builder((PartitionSpec)PartitionSpec.unpartitioned()).withRecordCount(100L).withFileSizeInBytes(avroFile.length()).withPath(avroFile.toString()).build();
        table.newAppend().appendFile(file).commit();
        Dataset df = spark.read().format("iceberg").load(location.toString());
        List rows = df.collectAsList();
        Assert.assertEquals((String)"Should contain 100 rows", (long)100L, (long)rows.size());
        for (int i = 0; i < expected.size(); ++i) {
            TestHelpers.assertEqualsSafe(tableSchema.asStruct(), expected.get(i), (Row)rows.get(i));
        }
    }
}

