/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.ui.SQLAppStatusStore;
import org.apache.spark.sql.execution.ui.SQLExecutionUIData;
import org.apache.spark.sql.execution.ui.SQLPlanMetric;
import org.junit.Assert;
import scala.Option;

public class SparkSQLExecutionHelper {
    private SparkSQLExecutionHelper() {
    }

    public static String lastExecutedMetricValue(SparkSession spark, String metricName) {
        SQLAppStatusStore statusStore = spark.sharedState().statusStore();
        SQLExecutionUIData lastExecution = (SQLExecutionUIData)statusStore.executionsList().last();
        Option sqlPlanMetric = lastExecution.metrics().find(metric -> metric.name().equals(metricName));
        Assert.assertTrue((String)String.format("Metric '%s' not found in last execution", metricName), (boolean)sqlPlanMetric.isDefined());
        long metricId = ((SQLPlanMetric)sqlPlanMetric.get()).accumulatorId();
        for (int attempts = 3; lastExecution.metricValues() == null && attempts > 0; --attempts) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            lastExecution = (SQLExecutionUIData)statusStore.execution(lastExecution.executionId()).get();
        }
        Assert.assertNotNull((String)"Metric values were not finalized", (Object)lastExecution.metricValues());
        String metricValue = (String)lastExecution.metricValues().get((Object)metricId).getOrElse(null);
        Assert.assertNotNull((String)String.format("Metric '%s' was not finalized", metricName), (Object)metricValue);
        return metricValue;
    }
}

