/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.iceberg.Files;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.RandomGenericData;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.orc.GenericOrcReader;
import org.apache.iceberg.data.orc.GenericOrcWriter;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.data.AvroDataTest;
import org.apache.iceberg.spark.data.GenericsHelpers;
import org.apache.iceberg.spark.data.SparkOrcReader;
import org.apache.iceberg.spark.data.SparkOrcWriter;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.orc.TypeDescription;
import org.apache.spark.sql.catalyst.InternalRow;
import org.junit.Assert;
import org.junit.Test;

public class TestSparkRecordOrcReaderWriter
extends AvroDataTest {
    private static final int NUM_RECORDS = 200;

    private void writeAndValidate(Schema schema, List<Record> expectedRecords) throws IOException {
        File originalFile = this.temp.newFile();
        Assert.assertTrue((String)"Delete should succeed", (boolean)originalFile.delete());
        try (FileAppender writer = ORC.write((OutputFile)Files.localOutput((File)originalFile)).createWriterFunc(GenericOrcWriter::buildWriter).schema(schema).build();){
            writer.addAll(expectedRecords);
        }
        ArrayList internalRows = Lists.newArrayList();
        try (CloseableIterable reader = ORC.read((InputFile)Files.localInput((File)originalFile)).project(schema).createReaderFunc(readOrcSchema -> new SparkOrcReader(schema, readOrcSchema)).build();){
            reader.forEach(internalRows::add);
            TestSparkRecordOrcReaderWriter.assertEqualsUnsafe(schema.asStruct(), expectedRecords, (Iterable<InternalRow>)reader, expectedRecords.size());
        }
        File anotherFile = this.temp.newFile();
        Assert.assertTrue((String)"Delete should succeed", (boolean)anotherFile.delete());
        try (FileAppender writer = ORC.write((OutputFile)Files.localOutput((File)anotherFile)).createWriterFunc(SparkOrcWriter::new).schema(schema).build();){
            writer.addAll((Iterable)internalRows);
        }
        var7_10 = null;
        try (CloseableIterable reader = ORC.read((InputFile)Files.localInput((File)anotherFile)).project(schema).createReaderFunc(readOrcSchema -> new SparkOrcReader(schema, readOrcSchema)).build();){
            TestSparkRecordOrcReaderWriter.assertEqualsUnsafe(schema.asStruct(), expectedRecords, (Iterable<InternalRow>)reader, expectedRecords.size());
        }
        catch (Throwable throwable) {
            var7_10 = throwable;
            throw throwable;
        }
        reader = ORC.read((InputFile)Files.localInput((File)anotherFile)).createReaderFunc(typeDesc -> GenericOrcReader.buildReader((Schema)schema, (TypeDescription)typeDesc)).project(schema).build();
        var7_10 = null;
        try {
            TestSparkRecordOrcReaderWriter.assertRecordEquals(expectedRecords, (Iterable<Record>)reader, expectedRecords.size());
        }
        catch (Throwable throwable) {
            var7_10 = throwable;
            throw throwable;
        }
        finally {
            if (reader != null) {
                TestSparkRecordOrcReaderWriter.$closeResource(var7_10, (AutoCloseable)reader);
            }
        }
    }

    @Override
    protected void writeAndValidate(Schema schema) throws IOException {
        List expectedRecords = RandomGenericData.generate((Schema)schema, (int)200, (long)1992L);
        this.writeAndValidate(schema, expectedRecords);
    }

    @Test
    public void testDecimalWithTrailingZero() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"d1", (Type)Types.DecimalType.of((int)10, (int)2)), Types.NestedField.required((int)2, (String)"d2", (Type)Types.DecimalType.of((int)20, (int)5)), Types.NestedField.required((int)3, (String)"d3", (Type)Types.DecimalType.of((int)38, (int)20))});
        ArrayList expected = Lists.newArrayList();
        GenericRecord record = GenericRecord.create((Schema)schema);
        record.set(0, (Object)new BigDecimal("101.00"));
        record.set(1, (Object)new BigDecimal("10.00E-3"));
        record.set(2, (Object)new BigDecimal("1001.0000E-16"));
        expected.add(record.copy());
        this.writeAndValidate(schema, expected);
    }

    private static void assertRecordEquals(Iterable<Record> expected, Iterable<Record> actual, int size) {
        Iterator<Record> expectedIter = expected.iterator();
        Iterator<Record> actualIter = actual.iterator();
        for (int i = 0; i < size; ++i) {
            Assert.assertTrue((String)"Expected iterator should have more rows", (boolean)expectedIter.hasNext());
            Assert.assertTrue((String)"Actual iterator should have more rows", (boolean)actualIter.hasNext());
            Assert.assertEquals((String)"Should have same rows.", (Object)expectedIter.next(), (Object)actualIter.next());
        }
        Assert.assertFalse((String)"Expected iterator should not have any extra rows.", (boolean)expectedIter.hasNext());
        Assert.assertFalse((String)"Actual iterator should not have any extra rows.", (boolean)actualIter.hasNext());
    }

    private static void assertEqualsUnsafe(Types.StructType struct, Iterable<Record> expected, Iterable<InternalRow> actual, int size) {
        Iterator<Record> expectedIter = expected.iterator();
        Iterator<InternalRow> actualIter = actual.iterator();
        for (int i = 0; i < size; ++i) {
            Assert.assertTrue((String)"Expected iterator should have more rows", (boolean)expectedIter.hasNext());
            Assert.assertTrue((String)"Actual iterator should have more rows", (boolean)actualIter.hasNext());
            GenericsHelpers.assertEqualsUnsafe(struct, expectedIter.next(), actualIter.next());
        }
        Assert.assertFalse((String)"Expected iterator should not have any extra rows.", (boolean)expectedIter.hasNext());
        Assert.assertFalse((String)"Actual iterator should not have any extra rows.", (boolean)actualIter.hasNext());
    }
}

