/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.avro.generic.GenericData;
import org.apache.iceberg.ContentScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.relocated.com.google.common.collect.Streams;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.orc.storage.serde2.io.DateWritable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericRow;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.DateTimeUtils;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.unsafe.types.UTF8String;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Assert;
import scala.collection.JavaConverters;
import scala.collection.Map;
import scala.collection.Seq;

public class TestHelpers {
    private static final OffsetDateTime EPOCH = Instant.ofEpochMilli(0L).atOffset(ZoneOffset.UTC);
    private static final LocalDate EPOCH_DAY = EPOCH.toLocalDate();

    private TestHelpers() {
    }

    public static void assertEqualsSafe(Types.StructType struct, List<GenericData.Record> recs, List<Row> rows) {
        Streams.forEachPair(recs.stream(), rows.stream(), (rec, row) -> TestHelpers.assertEqualsSafe(struct, rec, row));
    }

    public static void assertEqualsSafe(Types.StructType struct, GenericData.Record rec, Row row) {
        List fields = struct.fields();
        for (int i = 0; i < fields.size(); ++i) {
            Type fieldType = ((Types.NestedField)fields.get(i)).type();
            Object expectedValue = rec.get(i);
            Object actualValue = row.get(i);
            TestHelpers.assertEqualsSafe(fieldType, expectedValue, actualValue);
        }
    }

    public static void assertEqualsBatch(Types.StructType struct, Iterator<GenericData.Record> expected, ColumnarBatch batch) {
        for (int rowId = 0; rowId < batch.numRows(); ++rowId) {
            List fields = struct.fields();
            InternalRow row = batch.getRow(rowId);
            GenericData.Record rec = expected.next();
            for (int i = 0; i < fields.size(); ++i) {
                Type fieldType = ((Types.NestedField)fields.get(i)).type();
                Object expectedValue = rec.get(i);
                Object actualValue = row.isNullAt(i) ? null : row.get(i, SparkSchemaUtil.convert((Type)fieldType));
                TestHelpers.assertEqualsUnsafe(fieldType, expectedValue, actualValue);
            }
        }
    }

    private static void assertEqualsSafe(Types.ListType list, Collection<?> expected, List actual) {
        Type elementType = list.elementType();
        ArrayList expectedElements = Lists.newArrayList(expected);
        for (int i = 0; i < expectedElements.size(); ++i) {
            Object expectedValue = expectedElements.get(i);
            Object actualValue = actual.get(i);
            TestHelpers.assertEqualsSafe(elementType, expectedValue, actualValue);
        }
    }

    private static void assertEqualsSafe(Types.MapType map, java.util.Map<?, ?> expected, java.util.Map<?, ?> actual) {
        Type keyType = map.keyType();
        Type valueType = map.valueType();
        for (Object expectedKey : expected.keySet()) {
            Object matchingKey = null;
            for (Object actualKey : actual.keySet()) {
                try {
                    TestHelpers.assertEqualsSafe(keyType, expectedKey, actualKey);
                    matchingKey = actualKey;
                }
                catch (AssertionError assertionError) {}
            }
            Assert.assertNotNull((String)"Should have a matching key", matchingKey);
            TestHelpers.assertEqualsSafe(valueType, expected.get(expectedKey), actual.get(matchingKey));
        }
    }

    private static void assertEqualsSafe(Type type, Object expected, Object actual) {
        if (expected == null && actual == null) {
            return;
        }
        switch (type.typeId()) {
            case BOOLEAN: 
            case INTEGER: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                Assert.assertEquals((String)"Primitive value should be equal to expected", (Object)expected, (Object)actual);
                break;
            }
            case DATE: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should be an int", new Object[0])).isInstanceOf(Integer.class);
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Should be a Date", new Object[0])).isInstanceOf(Date.class);
                int daysFromEpoch = (Integer)expected;
                LocalDate date = ChronoUnit.DAYS.addTo(EPOCH_DAY, daysFromEpoch);
                Assert.assertEquals((String)"ISO-8601 date should be equal", (Object)date.toString(), (Object)actual.toString());
                break;
            }
            case TIMESTAMP: {
                Types.TimestampType timestampType = (Types.TimestampType)type;
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should be a long", new Object[0])).isInstanceOf(Long.class);
                if (timestampType.shouldAdjustToUTC()) {
                    ((ObjectAssert)Assertions.assertThat((Object)actual).as("Should be a Timestamp", new Object[0])).isInstanceOf(Timestamp.class);
                    Timestamp ts = (Timestamp)actual;
                    long tsMicros = ts.getTime() * 1000L + (long)(ts.getNanos() / 1000 % 1000);
                    Assert.assertEquals((String)"Timestamp micros should be equal", (Object)expected, (Object)tsMicros);
                    break;
                }
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Should be a LocalDateTime", new Object[0])).isInstanceOf(LocalDateTime.class);
                LocalDateTime ts = (LocalDateTime)actual;
                Instant instant = ts.toInstant(ZoneOffset.UTC);
                long tsMicros = instant.toEpochMilli() * 1000L + (long)(ts.getNano() / 1000 % 1000);
                Assert.assertEquals((String)"Timestamp micros should be equal", (Object)expected, (Object)tsMicros);
                break;
            }
            case STRING: {
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Should be a String", new Object[0])).isInstanceOf(String.class);
                Assert.assertEquals((String)"Strings should be equal", (Object)String.valueOf(expected), (Object)actual);
                break;
            }
            case UUID: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a UUID", new Object[0])).isInstanceOf(UUID.class);
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Should be a String", new Object[0])).isInstanceOf(String.class);
                Assert.assertEquals((String)"UUID string representation should match", (Object)expected.toString(), (Object)actual);
                break;
            }
            case FIXED: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a Fixed", new Object[0])).isInstanceOf(GenericData.Fixed.class);
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Should be a byte[]", new Object[0])).isInstanceOf(byte[].class);
                Assert.assertArrayEquals((String)"Bytes should match", (byte[])((GenericData.Fixed)expected).bytes(), (byte[])((byte[])actual));
                break;
            }
            case BINARY: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a ByteBuffer", new Object[0])).isInstanceOf(ByteBuffer.class);
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Should be a byte[]", new Object[0])).isInstanceOf(byte[].class);
                Assert.assertArrayEquals((String)"Bytes should match", (byte[])((ByteBuffer)expected).array(), (byte[])((byte[])actual));
                break;
            }
            case DECIMAL: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a BigDecimal", new Object[0])).isInstanceOf(BigDecimal.class);
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Should be a BigDecimal", new Object[0])).isInstanceOf(BigDecimal.class);
                Assert.assertEquals((String)"BigDecimals should be equal", (Object)expected, (Object)actual);
                break;
            }
            case STRUCT: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a Record", new Object[0])).isInstanceOf(GenericData.Record.class);
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Should be a Row", new Object[0])).isInstanceOf(Row.class);
                TestHelpers.assertEqualsSafe(type.asNestedType().asStructType(), (GenericData.Record)expected, (Row)actual);
                break;
            }
            case LIST: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a Collection", new Object[0])).isInstanceOf(Collection.class);
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Should be a Seq", new Object[0])).isInstanceOf(Seq.class);
                List asList = (List)JavaConverters.seqAsJavaListConverter((Seq)((Seq)actual)).asJava();
                TestHelpers.assertEqualsSafe(type.asNestedType().asListType(), (Collection)expected, asList);
                break;
            }
            case MAP: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a Collection", new Object[0])).isInstanceOf(java.util.Map.class);
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Should be a Map", new Object[0])).isInstanceOf(Map.class);
                java.util.Map asMap = (java.util.Map)JavaConverters.mapAsJavaMapConverter((Map)((Map)actual)).asJava();
                TestHelpers.assertEqualsSafe(type.asNestedType().asMapType(), (java.util.Map)expected, asMap);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a supported type: " + type);
            }
        }
    }

    public static void assertEqualsUnsafe(Types.StructType struct, GenericData.Record rec, InternalRow row) {
        List fields = struct.fields();
        for (int i = 0; i < fields.size(); ++i) {
            Type fieldType = ((Types.NestedField)fields.get(i)).type();
            Object expectedValue = rec.get(i);
            Object actualValue = row.isNullAt(i) ? null : row.get(i, SparkSchemaUtil.convert((Type)fieldType));
            TestHelpers.assertEqualsUnsafe(fieldType, expectedValue, actualValue);
        }
    }

    private static void assertEqualsUnsafe(Types.ListType list, Collection<?> expected, ArrayData actual) {
        Type elementType = list.elementType();
        ArrayList expectedElements = Lists.newArrayList(expected);
        for (int i = 0; i < expectedElements.size(); ++i) {
            Object expectedValue = expectedElements.get(i);
            Object actualValue = actual.get(i, SparkSchemaUtil.convert((Type)elementType));
            TestHelpers.assertEqualsUnsafe(elementType, expectedValue, actualValue);
        }
    }

    private static void assertEqualsUnsafe(Types.MapType map, java.util.Map<?, ?> expected, MapData actual) {
        Type keyType = map.keyType();
        Type valueType = map.valueType();
        ArrayList expectedElements = Lists.newArrayList(expected.entrySet());
        ArrayData actualKeys = actual.keyArray();
        ArrayData actualValues = actual.valueArray();
        for (int i = 0; i < expectedElements.size(); ++i) {
            Map.Entry expectedPair = (Map.Entry)expectedElements.get(i);
            Object actualKey = actualKeys.get(i, SparkSchemaUtil.convert((Type)keyType));
            Object actualValue = actualValues.get(i, SparkSchemaUtil.convert((Type)keyType));
            TestHelpers.assertEqualsUnsafe(keyType, expectedPair.getKey(), actualKey);
            TestHelpers.assertEqualsUnsafe(valueType, expectedPair.getValue(), actualValue);
        }
    }

    private static void assertEqualsUnsafe(Type type, Object expected, Object actual) {
        if (expected == null && actual == null) {
            return;
        }
        switch (type.typeId()) {
            case LONG: {
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Should be a long", new Object[0])).isInstanceOf(Long.class);
                if (expected instanceof Integer) {
                    Assert.assertEquals((String)"Values didn't match", (Object)((Number)expected).longValue(), (Object)actual);
                    break;
                }
                Assert.assertEquals((String)"Primitive value should be equal to expected", (Object)expected, (Object)actual);
                break;
            }
            case DOUBLE: {
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Should be a double", new Object[0])).isInstanceOf(Double.class);
                if (expected instanceof Float) {
                    Assert.assertEquals((String)"Values didn't match", (long)Double.doubleToLongBits(((Number)expected).doubleValue()), (long)Double.doubleToLongBits((Double)actual));
                    break;
                }
                Assert.assertEquals((String)"Primitive value should be equal to expected", (Object)expected, (Object)actual);
                break;
            }
            case BOOLEAN: 
            case INTEGER: 
            case FLOAT: 
            case DATE: 
            case TIMESTAMP: {
                Assert.assertEquals((String)"Primitive value should be equal to expected", (Object)expected, (Object)actual);
                break;
            }
            case STRING: {
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Should be a UTF8String", new Object[0])).isInstanceOf(UTF8String.class);
                Assert.assertEquals((String)"Strings should be equal", (Object)expected, (Object)actual.toString());
                break;
            }
            case UUID: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a UUID", new Object[0])).isInstanceOf(UUID.class);
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Should be a UTF8String", new Object[0])).isInstanceOf(UTF8String.class);
                Assert.assertEquals((String)"UUID string representation should match", (Object)expected.toString(), (Object)actual.toString());
                break;
            }
            case FIXED: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a Fixed", new Object[0])).isInstanceOf(GenericData.Fixed.class);
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Should be a byte[]", new Object[0])).isInstanceOf(byte[].class);
                Assert.assertArrayEquals((String)"Bytes should match", (byte[])((GenericData.Fixed)expected).bytes(), (byte[])((byte[])actual));
                break;
            }
            case BINARY: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a ByteBuffer", new Object[0])).isInstanceOf(ByteBuffer.class);
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Should be a byte[]", new Object[0])).isInstanceOf(byte[].class);
                Assert.assertArrayEquals((String)"Bytes should match", (byte[])((ByteBuffer)expected).array(), (byte[])((byte[])actual));
                break;
            }
            case DECIMAL: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a BigDecimal", new Object[0])).isInstanceOf(BigDecimal.class);
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Should be a Decimal", new Object[0])).isInstanceOf(Decimal.class);
                Assert.assertEquals((String)"BigDecimals should be equal", (Object)expected, (Object)((Decimal)actual).toJavaBigDecimal());
                break;
            }
            case STRUCT: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a Record", new Object[0])).isInstanceOf(GenericData.Record.class);
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Should be an InternalRow", new Object[0])).isInstanceOf(InternalRow.class);
                TestHelpers.assertEqualsUnsafe(type.asNestedType().asStructType(), (GenericData.Record)expected, (InternalRow)actual);
                break;
            }
            case LIST: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a Collection", new Object[0])).isInstanceOf(Collection.class);
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Should be an ArrayData", new Object[0])).isInstanceOf(ArrayData.class);
                TestHelpers.assertEqualsUnsafe(type.asNestedType().asListType(), (Collection)expected, (ArrayData)actual);
                break;
            }
            case MAP: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a Map", new Object[0])).isInstanceOf(java.util.Map.class);
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Should be an ArrayBasedMapData", new Object[0])).isInstanceOf(MapData.class);
                TestHelpers.assertEqualsUnsafe(type.asNestedType().asMapType(), (java.util.Map)expected, (MapData)actual);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a supported type: " + type);
            }
        }
    }

    public static void assertEquals(String prefix, Types.StructType type, InternalRow expected, Row actual) {
        if (expected == null || actual == null) {
            Assert.assertEquals((String)prefix, (Object)expected, (Object)actual);
        } else {
            List fields = type.fields();
            block7: for (int c = 0; c < fields.size(); ++c) {
                String fieldName = ((Types.NestedField)fields.get(c)).name();
                Type childType = ((Types.NestedField)fields.get(c)).type();
                switch (childType.typeId()) {
                    case BOOLEAN: 
                    case INTEGER: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: 
                    case DATE: 
                    case TIMESTAMP: 
                    case STRING: 
                    case DECIMAL: {
                        Assert.assertEquals((String)(prefix + "." + fieldName + " - " + childType), (Object)TestHelpers.getValue((SpecializedGetters)expected, c, childType), (Object)TestHelpers.getPrimitiveValue(actual, c, childType));
                        continue block7;
                    }
                    case UUID: 
                    case FIXED: 
                    case BINARY: {
                        TestHelpers.assertEqualBytes(prefix + "." + fieldName, (byte[])TestHelpers.getValue((SpecializedGetters)expected, c, childType), (byte[])actual.get(c));
                        continue block7;
                    }
                    case STRUCT: {
                        Types.StructType st = (Types.StructType)childType;
                        TestHelpers.assertEquals(prefix + "." + fieldName, st, expected.getStruct(c, st.fields().size()), actual.getStruct(c));
                        continue block7;
                    }
                    case LIST: {
                        TestHelpers.assertEqualsLists(prefix + "." + fieldName, childType.asListType(), expected.getArray(c), TestHelpers.toList((Seq)actual.get(c)));
                        continue block7;
                    }
                    case MAP: {
                        TestHelpers.assertEqualsMaps(prefix + "." + fieldName, childType.asMapType(), expected.getMap(c), TestHelpers.toJavaMap(actual.getMap(c)));
                        continue block7;
                    }
                    default: {
                        throw new IllegalArgumentException("Unhandled type " + childType);
                    }
                }
            }
        }
    }

    private static void assertEqualsLists(String prefix, Types.ListType type, ArrayData expected, List actual) {
        if (expected == null || actual == null) {
            Assert.assertEquals((String)prefix, (Object)expected, (Object)actual);
        } else {
            Assert.assertEquals((String)(prefix + " length"), (long)expected.numElements(), (long)actual.size());
            Type childType = type.elementType();
            block7: for (int e = 0; e < expected.numElements(); ++e) {
                switch (childType.typeId()) {
                    case BOOLEAN: 
                    case INTEGER: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: 
                    case DATE: 
                    case TIMESTAMP: 
                    case STRING: 
                    case DECIMAL: {
                        Assert.assertEquals((String)(prefix + ".elem " + e + " - " + childType), (Object)TestHelpers.getValue((SpecializedGetters)expected, e, childType), actual.get(e));
                        continue block7;
                    }
                    case UUID: 
                    case FIXED: 
                    case BINARY: {
                        TestHelpers.assertEqualBytes(prefix + ".elem " + e, (byte[])TestHelpers.getValue((SpecializedGetters)expected, e, childType), (byte[])actual.get(e));
                        continue block7;
                    }
                    case STRUCT: {
                        Types.StructType st = (Types.StructType)childType;
                        TestHelpers.assertEquals(prefix + ".elem " + e, st, expected.getStruct(e, st.fields().size()), (Row)actual.get(e));
                        continue block7;
                    }
                    case LIST: {
                        TestHelpers.assertEqualsLists(prefix + ".elem " + e, childType.asListType(), expected.getArray(e), TestHelpers.toList((Seq)actual.get(e)));
                        continue block7;
                    }
                    case MAP: {
                        TestHelpers.assertEqualsMaps(prefix + ".elem " + e, childType.asMapType(), expected.getMap(e), TestHelpers.toJavaMap((Map)actual.get(e)));
                        continue block7;
                    }
                    default: {
                        throw new IllegalArgumentException("Unhandled type " + childType);
                    }
                }
            }
        }
    }

    private static void assertEqualsMaps(String prefix, Types.MapType type, MapData expected, java.util.Map<?, ?> actual) {
        if (expected == null || actual == null) {
            Assert.assertEquals((String)prefix, (Object)expected, actual);
        } else {
            Type keyType = type.keyType();
            Type valueType = type.valueType();
            ArrayData expectedKeyArray = expected.keyArray();
            ArrayData expectedValueArray = expected.valueArray();
            Assert.assertEquals((String)(prefix + " length"), (long)expected.numElements(), (long)actual.size());
            block7: for (int e = 0; e < expected.numElements(); ++e) {
                Object expectedKey = TestHelpers.getValue((SpecializedGetters)expectedKeyArray, e, keyType);
                Object actualValue = actual.get(expectedKey);
                if (actualValue == null) {
                    Assert.assertEquals((String)(prefix + ".key=" + expectedKey + " has null"), (Object)true, (Object)expected.valueArray().isNullAt(e));
                    continue;
                }
                switch (valueType.typeId()) {
                    case BOOLEAN: 
                    case INTEGER: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: 
                    case DATE: 
                    case TIMESTAMP: 
                    case STRING: 
                    case DECIMAL: {
                        Assert.assertEquals((String)(prefix + ".key=" + expectedKey + " - " + valueType), (Object)TestHelpers.getValue((SpecializedGetters)expectedValueArray, e, valueType), actual.get(expectedKey));
                        continue block7;
                    }
                    case UUID: 
                    case FIXED: 
                    case BINARY: {
                        TestHelpers.assertEqualBytes(prefix + ".key=" + expectedKey, (byte[])TestHelpers.getValue((SpecializedGetters)expectedValueArray, e, valueType), (byte[])actual.get(expectedKey));
                        continue block7;
                    }
                    case STRUCT: {
                        Types.StructType st = (Types.StructType)valueType;
                        TestHelpers.assertEquals(prefix + ".key=" + expectedKey, st, expectedValueArray.getStruct(e, st.fields().size()), (Row)actual.get(expectedKey));
                        continue block7;
                    }
                    case LIST: {
                        TestHelpers.assertEqualsLists(prefix + ".key=" + expectedKey, valueType.asListType(), expectedValueArray.getArray(e), TestHelpers.toList((Seq)actual.get(expectedKey)));
                        continue block7;
                    }
                    case MAP: {
                        TestHelpers.assertEqualsMaps(prefix + ".key=" + expectedKey, valueType.asMapType(), expectedValueArray.getMap(e), TestHelpers.toJavaMap((Map)actual.get(expectedKey)));
                        continue block7;
                    }
                    default: {
                        throw new IllegalArgumentException("Unhandled type " + valueType);
                    }
                }
            }
        }
    }

    private static Object getValue(SpecializedGetters container, int ord, Type type) {
        if (container.isNullAt(ord)) {
            return null;
        }
        switch (type.typeId()) {
            case BOOLEAN: {
                return container.getBoolean(ord);
            }
            case INTEGER: {
                return container.getInt(ord);
            }
            case LONG: {
                return container.getLong(ord);
            }
            case FLOAT: {
                return Float.valueOf(container.getFloat(ord));
            }
            case DOUBLE: {
                return container.getDouble(ord);
            }
            case STRING: {
                return container.getUTF8String(ord).toString();
            }
            case UUID: 
            case FIXED: 
            case BINARY: {
                return container.getBinary(ord);
            }
            case DATE: {
                return new DateWritable(container.getInt(ord)).get();
            }
            case TIMESTAMP: {
                return DateTimeUtils.toJavaTimestamp((long)container.getLong(ord));
            }
            case DECIMAL: {
                Types.DecimalType dt = (Types.DecimalType)type;
                return container.getDecimal(ord, dt.precision(), dt.scale()).toJavaBigDecimal();
            }
            case STRUCT: {
                Types.StructType struct = type.asStructType();
                InternalRow internalRow = container.getStruct(ord, struct.fields().size());
                Object[] data = new Object[struct.fields().size()];
                for (int i = 0; i < data.length; ++i) {
                    data[i] = internalRow.isNullAt(i) ? null : TestHelpers.getValue((SpecializedGetters)internalRow, i, ((Types.NestedField)struct.fields().get(i)).type());
                }
                return new GenericRow(data);
            }
        }
        throw new IllegalArgumentException("Unhandled type " + type);
    }

    private static Object getPrimitiveValue(Row row, int ord, Type type) {
        if (row.isNullAt(ord)) {
            return null;
        }
        switch (type.typeId()) {
            case BOOLEAN: {
                return row.getBoolean(ord);
            }
            case INTEGER: {
                return row.getInt(ord);
            }
            case LONG: {
                return row.getLong(ord);
            }
            case FLOAT: {
                return Float.valueOf(row.getFloat(ord));
            }
            case DOUBLE: {
                return row.getDouble(ord);
            }
            case STRING: {
                return row.getString(ord);
            }
            case UUID: 
            case FIXED: 
            case BINARY: {
                return row.get(ord);
            }
            case DATE: {
                return row.getDate(ord);
            }
            case TIMESTAMP: {
                return row.getTimestamp(ord);
            }
            case DECIMAL: {
                return row.getDecimal(ord);
            }
        }
        throw new IllegalArgumentException("Unhandled type " + type);
    }

    private static <K, V> java.util.Map<K, V> toJavaMap(Map<K, V> map) {
        return map == null ? null : (java.util.Map)JavaConverters.mapAsJavaMapConverter(map).asJava();
    }

    private static List toList(Seq<?> val) {
        return val == null ? null : (List)JavaConverters.seqAsJavaListConverter(val).asJava();
    }

    private static void assertEqualBytes(String context, byte[] expected, byte[] actual) {
        if (expected == null || actual == null) {
            Assert.assertEquals((String)context, (Object)expected, (Object)actual);
        } else {
            Assert.assertArrayEquals((String)context, (byte[])expected, (byte[])actual);
        }
    }

    static void assertEquals(Schema schema, Object expected, Object actual) {
        TestHelpers.assertEquals("schema", (DataType)SparkSchemaUtil.convert((Schema)schema), expected, actual);
    }

    private static void assertEquals(String context, DataType type, Object expected, Object actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (type instanceof StructType) {
            ((ObjectAssert)Assertions.assertThat((Object)expected).as("Expected should be an InternalRow: " + context, new Object[0])).isInstanceOf(InternalRow.class);
            ((ObjectAssert)Assertions.assertThat((Object)actual).as("Actual should be an InternalRow: " + context, new Object[0])).isInstanceOf(InternalRow.class);
            TestHelpers.assertEquals(context, (StructType)type, (InternalRow)expected, (InternalRow)actual);
        } else if (type instanceof ArrayType) {
            ((ObjectAssert)Assertions.assertThat((Object)expected).as("Expected should be an ArrayData: " + context, new Object[0])).isInstanceOf(ArrayData.class);
            ((ObjectAssert)Assertions.assertThat((Object)actual).as("Actual should be an ArrayData: " + context, new Object[0])).isInstanceOf(ArrayData.class);
            TestHelpers.assertEquals(context, (ArrayType)type, (ArrayData)expected, (ArrayData)actual);
        } else if (type instanceof MapType) {
            ((ObjectAssert)Assertions.assertThat((Object)expected).as("Expected should be a MapData: " + context, new Object[0])).isInstanceOf(MapData.class);
            ((ObjectAssert)Assertions.assertThat((Object)actual).as("Actual should be a MapData: " + context, new Object[0])).isInstanceOf(MapData.class);
            TestHelpers.assertEquals(context, (MapType)type, (MapData)expected, (MapData)actual);
        } else if (type instanceof BinaryType) {
            TestHelpers.assertEqualBytes(context, (byte[])expected, (byte[])actual);
        } else {
            Assert.assertEquals((String)("Value should match expected: " + context), (Object)expected, (Object)actual);
        }
    }

    private static void assertEquals(String context, StructType struct, InternalRow expected, InternalRow actual) {
        Assert.assertEquals((String)"Should have correct number of fields", (long)struct.size(), (long)actual.numFields());
        for (int i = 0; i < actual.numFields(); ++i) {
            StructField field = struct.fields()[i];
            DataType type = field.dataType();
            TestHelpers.assertEquals(context + "." + field.name(), type, expected.isNullAt(i) ? null : expected.get(i, type), actual.isNullAt(i) ? null : actual.get(i, type));
        }
    }

    private static void assertEquals(String context, ArrayType array, ArrayData expected, ArrayData actual) {
        Assert.assertEquals((String)"Should have the same number of elements", (long)expected.numElements(), (long)actual.numElements());
        DataType type = array.elementType();
        for (int i = 0; i < actual.numElements(); ++i) {
            TestHelpers.assertEquals(context + ".element", type, expected.isNullAt(i) ? null : expected.get(i, type), actual.isNullAt(i) ? null : actual.get(i, type));
        }
    }

    private static void assertEquals(String context, MapType map, MapData expected, MapData actual) {
        Assert.assertEquals((String)"Should have the same number of elements", (long)expected.numElements(), (long)actual.numElements());
        DataType keyType = map.keyType();
        ArrayData expectedKeys = expected.keyArray();
        ArrayData expectedValues = expected.valueArray();
        DataType valueType = map.valueType();
        ArrayData actualKeys = actual.keyArray();
        ArrayData actualValues = actual.valueArray();
        for (int i = 0; i < actual.numElements(); ++i) {
            TestHelpers.assertEquals(context + ".key", keyType, expectedKeys.isNullAt(i) ? null : expectedKeys.get(i, keyType), actualKeys.isNullAt(i) ? null : actualKeys.get(i, keyType));
            TestHelpers.assertEquals(context + ".value", valueType, expectedValues.isNullAt(i) ? null : expectedValues.get(i, valueType), actualValues.isNullAt(i) ? null : actualValues.get(i, valueType));
        }
    }

    public static List<ManifestFile> dataManifests(Table table) {
        return table.currentSnapshot().dataManifests(table.io());
    }

    public static List<ManifestFile> deleteManifests(Table table) {
        return table.currentSnapshot().deleteManifests(table.io());
    }

    public static List<DataFile> dataFiles(Table table) {
        return TestHelpers.dataFiles(table, null);
    }

    public static List<DataFile> dataFiles(Table table, String branch) {
        TableScan scan = table.newScan();
        if (branch != null) {
            scan.useRef(branch);
        }
        CloseableIterable tasks = ((TableScan)scan.includeColumnStats()).planFiles();
        return Lists.newArrayList((Iterable)CloseableIterable.transform((CloseableIterable)tasks, ContentScanTask::file));
    }

    public static Set<DeleteFile> deleteFiles(Table table) {
        HashSet deleteFiles = Sets.newHashSet();
        for (FileScanTask task : table.newScan().planFiles()) {
            deleteFiles.addAll(task.deletes());
        }
        return deleteFiles;
    }

    public static Set<String> reachableManifestPaths(Table table) {
        return StreamSupport.stream(table.snapshots().spliterator(), false).flatMap(s -> s.allManifests(table.io()).stream()).map(ManifestFile::path).collect(Collectors.toSet());
    }

    public static void asMetadataRecord(GenericData.Record file, FileContent content) {
        file.put(0, (Object)content.id());
        file.put(3, (Object)0);
    }

    public static void asMetadataRecord(GenericData.Record file) {
        file.put(0, (Object)FileContent.DATA.id());
        file.put(3, (Object)0);
    }

    public static Dataset<Row> selectNonDerived(Dataset<Row> metadataTable) {
        StructField[] fields = metadataTable.schema().fields();
        return metadataTable.select((Column[])Stream.of(fields).filter(f -> !f.name().equals("readable_metrics")).map(f -> new Column(f.name())).toArray(Column[]::new));
    }

    public static Types.StructType nonDerivedSchema(Dataset<Row> metadataTable) {
        return SparkSchemaUtil.convert((StructType)TestHelpers.selectNonDerived(metadataTable).schema()).asStruct();
    }
}

