/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.util.List;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.spark.SparkCachedTableCatalog;
import org.apache.iceberg.spark.SparkCatalogConfig;
import org.apache.iceberg.spark.SparkTableCache;
import org.apache.iceberg.spark.SparkTestBaseWithCatalog;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestSparkCachedTableCatalog
extends SparkTestBaseWithCatalog {
    private static final SparkTableCache TABLE_CACHE = SparkTableCache.get();

    @BeforeClass
    public static void setupCachedTableCatalog() {
        spark.conf().set("spark.sql.catalog.testcache", SparkCachedTableCatalog.class.getName());
    }

    @AfterClass
    public static void unsetCachedTableCatalog() {
        spark.conf().unset("spark.sql.catalog.testcache");
    }

    public TestSparkCachedTableCatalog() {
        super(SparkCatalogConfig.HIVE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimeTravel() {
        this.sql("CREATE TABLE %s (id INT, dep STRING) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        this.sql("INSERT INTO TABLE %s VALUES (1, 'hr')", this.tableName);
        table.refresh();
        Snapshot firstSnapshot = table.currentSnapshot();
        this.waitUntilAfter(firstSnapshot.timestampMillis());
        this.sql("INSERT INTO TABLE %s VALUES (2, 'hr')", this.tableName);
        table.refresh();
        Snapshot secondSnapshot = table.currentSnapshot();
        this.waitUntilAfter(secondSnapshot.timestampMillis());
        this.sql("INSERT INTO TABLE %s VALUES (3, 'hr')", this.tableName);
        table.refresh();
        try {
            TABLE_CACHE.add("key", table);
            this.assertEquals("Should have expected rows in 3rd snapshot", (List<Object[]>)ImmutableList.of((Object)this.row(1, "hr"), (Object)this.row(2, "hr"), (Object)this.row(3, "hr")), this.sql("SELECT * FROM testcache.key ORDER BY id", new Object[0]));
            this.assertEquals("Should have expected rows in 2nd snapshot", (List<Object[]>)ImmutableList.of((Object)this.row(1, "hr"), (Object)this.row(2, "hr")), this.sql("SELECT * FROM testcache.`key#at_timestamp_%s` ORDER BY id", secondSnapshot.timestampMillis()));
            this.assertEquals("Should have expected rows in 1st snapshot", (List<Object[]>)ImmutableList.of((Object)this.row(1, "hr")), this.sql("SELECT * FROM testcache.`key#snapshot_id_%d` ORDER BY id", firstSnapshot.snapshotId()));
        }
        finally {
            TABLE_CACHE.remove("key");
        }
    }
}

