/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.KryoHelpers;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.MetadataTableUtils;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.spark.source.SerializableTableWithSize;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestTableSerialization {
    private static final HadoopTables TABLES = new HadoopTables();
    private final String isObjectStoreEnabled;
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)3, (String)"date", (Type)Types.StringType.get()), Types.NestedField.optional((int)4, (String)"double", (Type)Types.DoubleType.get())});
    private static final PartitionSpec SPEC = PartitionSpec.builderFor((Schema)SCHEMA).identity("date").build();
    private static final SortOrder SORT_ORDER = ((SortOrder.Builder)SortOrder.builderFor((Schema)SCHEMA).asc("id")).build();
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private Table table;

    public TestTableSerialization(String isObjectStoreEnabled) {
        this.isObjectStoreEnabled = isObjectStoreEnabled;
    }

    @Parameterized.Parameters(name="isObjectStoreEnabled = {0}")
    public static Object[] parameters() {
        return new Object[]{"true", "false"};
    }

    @Before
    public void initTable() throws IOException {
        ImmutableMap props = ImmutableMap.of((Object)"k1", (Object)"v1", (Object)"write.object-storage.enabled", (Object)this.isObjectStoreEnabled);
        File tableLocation = this.temp.newFolder();
        Assert.assertTrue((boolean)tableLocation.delete());
        this.table = TABLES.create(SCHEMA, SPEC, SORT_ORDER, (Map)props, tableLocation.toString());
    }

    @Test
    public void testSerializableTableKryoSerialization() throws IOException {
        Table serializableTable = SerializableTableWithSize.copyOf((Table)this.table);
        TestHelpers.assertSerializedAndLoadedMetadata((Table)this.table, (Table)KryoHelpers.roundTripSerialize(serializableTable));
    }

    @Test
    public void testSerializableMetadataTableKryoSerialization() throws IOException {
        for (MetadataTableType type : MetadataTableType.values()) {
            TableOperations ops = ((HasTableOperations)this.table).operations();
            Table metadataTable = MetadataTableUtils.createMetadataTableInstance((TableOperations)ops, (String)this.table.name(), (String)"meta", (MetadataTableType)type);
            Table serializableMetadataTable = SerializableTableWithSize.copyOf((Table)metadataTable);
            TestHelpers.assertSerializedAndLoadedMetadata((Table)metadataTable, (Table)KryoHelpers.roundTripSerialize(serializableMetadataTable));
        }
    }

    @Test
    public void testSerializableTransactionTableKryoSerialization() throws IOException {
        Transaction txn = this.table.newTransaction();
        txn.updateProperties().set("k1", "v1").commit();
        Table txnTable = txn.table();
        Table serializableTxnTable = SerializableTableWithSize.copyOf((Table)txnTable);
        TestHelpers.assertSerializedMetadata((Table)txnTable, (Table)KryoHelpers.roundTripSerialize(serializableTxnTable));
    }
}

