/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Map;
import org.apache.iceberg.BatchScan;
import org.apache.iceberg.DeleteFileIndexTestBase;
import org.apache.iceberg.PlanningMode;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.SparkDistributedDataScan;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.spark.SparkReadConf;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.internal.SQLConf;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestSparkDistributedDataScanDeletes
extends DeleteFileIndexTestBase<BatchScan, ScanTask, ScanTaskGroup<ScanTask>> {
    private static SparkSession spark = null;
    private final PlanningMode dataMode;
    private final PlanningMode deleteMode;

    @Parameterized.Parameters(name="dataMode = {0}, deleteMode = {1}")
    public static Object[] parameters() {
        return new Object[][]{{PlanningMode.LOCAL, PlanningMode.LOCAL}, {PlanningMode.LOCAL, PlanningMode.DISTRIBUTED}, {PlanningMode.DISTRIBUTED, PlanningMode.LOCAL}, {PlanningMode.DISTRIBUTED, PlanningMode.DISTRIBUTED}};
    }

    public TestSparkDistributedDataScanDeletes(PlanningMode dataPlanningMode, PlanningMode deletePlanningMode) {
        this.dataMode = dataPlanningMode;
        this.deleteMode = deletePlanningMode;
    }

    @Before
    public void configurePlanningModes() {
        this.table.updateProperties().set("read.data-planning-mode", this.dataMode.modeName()).set("read.delete-planning-mode", this.deleteMode.modeName()).commit();
    }

    @BeforeClass
    public static void startSpark() {
        spark = SparkSession.builder().master("local[2]").config("spark.serializer", "org.apache.spark.serializer.KryoSerializer").config(SQLConf.SHUFFLE_PARTITIONS().key(), "4").getOrCreate();
    }

    @AfterClass
    public static void stopSpark() {
        SparkSession currentSpark = spark;
        spark = null;
        currentSpark.stop();
    }

    protected BatchScan newScan(Table table) {
        SparkReadConf readConf = new SparkReadConf(spark, table, (Map)ImmutableMap.of());
        return new SparkDistributedDataScan(spark, table, readConf);
    }
}

