/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.GenericManifestFile;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.ManifestWriter;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.hadoop.HadoopFileIO;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.spark.SparkConf;
import org.apache.spark.serializer.KryoSerializer;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestManifestFileSerialization {
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)3, (String)"date", (Type)Types.StringType.get()), Types.NestedField.required((int)4, (String)"double", (Type)Types.DoubleType.get())});
    private static final PartitionSpec SPEC = PartitionSpec.builderFor((Schema)SCHEMA).identity("double").build();
    private static final DataFile FILE_A = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-1.parquet").withFileSizeInBytes(0L).withPartition((StructLike)TestHelpers.Row.of((Object[])new Object[]{1.0})).withPartitionPath("double=1").withMetrics(new Metrics(Long.valueOf(5L), null, (Map)ImmutableMap.of((Object)1, (Object)5L, (Object)2, (Object)3L), (Map)ImmutableMap.of((Object)1, (Object)0L, (Object)2, (Object)2L), (Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)1, (Object)TestManifestFileSerialization.longToBuffer(0L)), (Map)ImmutableMap.of((Object)1, (Object)TestManifestFileSerialization.longToBuffer(4L)))).build();
    private static final DataFile FILE_B = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-2.parquet").withFileSizeInBytes(0L).withPartition((StructLike)TestHelpers.Row.of((Object[])new Object[]{Double.NaN})).withPartitionPath("double=NaN").withMetrics(new Metrics(Long.valueOf(1L), null, (Map)ImmutableMap.of((Object)1, (Object)1L, (Object)4, (Object)1L), (Map)ImmutableMap.of((Object)1, (Object)0L, (Object)2, (Object)0L), (Map)ImmutableMap.of((Object)4, (Object)1L), (Map)ImmutableMap.of((Object)1, (Object)TestManifestFileSerialization.longToBuffer(0L)), (Map)ImmutableMap.of((Object)1, (Object)TestManifestFileSerialization.longToBuffer(1L)))).build();
    private static final FileIO FILE_IO = new HadoopFileIO(new Configuration());
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    @Test
    public void testManifestFileKryoSerialization() throws IOException {
        File data = this.temp.newFile();
        Assert.assertTrue((boolean)data.delete());
        Kryo kryo = new KryoSerializer(new SparkConf()).newKryo();
        ManifestFile manifest = this.writeManifest(FILE_A, FILE_B);
        try (Output out = new Output((OutputStream)new FileOutputStream(data));){
            kryo.writeClassAndObject(out, (Object)manifest);
            kryo.writeClassAndObject(out, (Object)manifest.copy());
            kryo.writeClassAndObject(out, (Object)GenericManifestFile.copyOf((ManifestFile)manifest).build());
        }
        var5_5 = null;
        try (Input in = new Input((InputStream)new FileInputStream(data));){
            for (int i = 0; i < 3; ++i) {
                Object obj = kryo.readClassAndObject(in);
                ((ObjectAssert)Assertions.assertThat((Object)obj).as("Should be a ManifestFile", new Object[0])).isInstanceOf(ManifestFile.class);
                this.checkManifestFile(manifest, (ManifestFile)obj);
            }
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testManifestFileJavaSerialization() throws Exception {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        ManifestFile manifest = this.writeManifest(FILE_A, FILE_B);
        try (ObjectOutputStream out = new ObjectOutputStream(bytes);){
            out.writeObject(manifest);
            out.writeObject(manifest.copy());
            out.writeObject(GenericManifestFile.copyOf((ManifestFile)manifest).build());
        }
        var4_4 = null;
        try (ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes.toByteArray()));){
            for (int i = 0; i < 3; ++i) {
                Object obj = in.readObject();
                ((ObjectAssert)Assertions.assertThat((Object)obj).as("Should be a ManifestFile", new Object[0])).isInstanceOf(ManifestFile.class);
                this.checkManifestFile(manifest, (ManifestFile)obj);
            }
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }

    private void checkManifestFile(ManifestFile expected, ManifestFile actual) {
        Assert.assertEquals((String)"Path must match", (Object)expected.path(), (Object)actual.path());
        Assert.assertEquals((String)"Length must match", (long)expected.length(), (long)actual.length());
        Assert.assertEquals((String)"Spec id must match", (long)expected.partitionSpecId(), (long)actual.partitionSpecId());
        Assert.assertEquals((String)"Snapshot id must match", (Object)expected.snapshotId(), (Object)actual.snapshotId());
        Assert.assertEquals((String)"Added files flag must match", (Object)expected.hasAddedFiles(), (Object)actual.hasAddedFiles());
        Assert.assertEquals((String)"Added files count must match", (Object)expected.addedFilesCount(), (Object)actual.addedFilesCount());
        Assert.assertEquals((String)"Added rows count must match", (Object)expected.addedRowsCount(), (Object)actual.addedRowsCount());
        Assert.assertEquals((String)"Existing files flag must match", (Object)expected.hasExistingFiles(), (Object)actual.hasExistingFiles());
        Assert.assertEquals((String)"Existing files count must match", (Object)expected.existingFilesCount(), (Object)actual.existingFilesCount());
        Assert.assertEquals((String)"Existing rows count must match", (Object)expected.existingRowsCount(), (Object)actual.existingRowsCount());
        Assert.assertEquals((String)"Deleted files flag must match", (Object)expected.hasDeletedFiles(), (Object)actual.hasDeletedFiles());
        Assert.assertEquals((String)"Deleted files count must match", (Object)expected.deletedFilesCount(), (Object)actual.deletedFilesCount());
        Assert.assertEquals((String)"Deleted rows count must match", (Object)expected.deletedRowsCount(), (Object)actual.deletedRowsCount());
        ManifestFile.PartitionFieldSummary expectedPartition = (ManifestFile.PartitionFieldSummary)expected.partitions().get(0);
        ManifestFile.PartitionFieldSummary actualPartition = (ManifestFile.PartitionFieldSummary)actual.partitions().get(0);
        Assert.assertEquals((String)"Null flag in partition must match", (Object)expectedPartition.containsNull(), (Object)actualPartition.containsNull());
        Assert.assertEquals((String)"NaN flag in partition must match", (Object)expectedPartition.containsNaN(), (Object)actualPartition.containsNaN());
        Assert.assertEquals((String)"Lower bounds in partition must match", (Object)expectedPartition.lowerBound(), (Object)actualPartition.lowerBound());
        Assert.assertEquals((String)"Upper bounds in partition must match", (Object)expectedPartition.upperBound(), (Object)actualPartition.upperBound());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManifestFile writeManifest(DataFile ... files) throws IOException {
        File manifestFile = this.temp.newFile("input.m0.avro");
        Assert.assertTrue((boolean)manifestFile.delete());
        OutputFile outputFile = FILE_IO.newOutputFile(manifestFile.getCanonicalPath());
        try (ManifestWriter writer = ManifestFiles.write((PartitionSpec)SPEC, (OutputFile)outputFile);){
            for (DataFile file : files) {
                writer.add((ContentFile)file);
            }
        }
        return writer.toManifestFile();
    }

    private static ByteBuffer longToBuffer(long value) {
        return ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(0, value);
    }
}

