/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.KryoHelpers;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.hadoop.HadoopFileIO;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.spark.source.SerializableTableWithSize;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestFileIOSerialization {
    private static final Configuration CONF = new Configuration();
    private static final HadoopTables TABLES = new HadoopTables(CONF);
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)3, (String)"date", (Type)Types.StringType.get()), Types.NestedField.optional((int)4, (String)"double", (Type)Types.DoubleType.get())});
    private static final PartitionSpec SPEC = PartitionSpec.builderFor((Schema)SCHEMA).identity("date").build();
    private static final SortOrder SORT_ORDER = ((SortOrder.Builder)SortOrder.builderFor((Schema)SCHEMA).asc("id")).build();
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private Table table;

    @Before
    public void initTable() throws IOException {
        ImmutableMap props = ImmutableMap.of((Object)"k1", (Object)"v1", (Object)"k2", (Object)"v2");
        File tableLocation = this.temp.newFolder();
        Assert.assertTrue((boolean)tableLocation.delete());
        this.table = TABLES.create(SCHEMA, SPEC, SORT_ORDER, (Map)props, tableLocation.toString());
    }

    @Test
    public void testHadoopFileIOKryoSerialization() throws IOException {
        FileIO io = this.table.io();
        Configuration expectedConf = ((HadoopFileIO)io).conf();
        Table serializableTable = SerializableTableWithSize.copyOf((Table)this.table);
        FileIO deserializedIO = KryoHelpers.roundTripSerialize(serializableTable.io());
        Configuration actualConf = ((HadoopFileIO)deserializedIO).conf();
        Assert.assertEquals((String)"Conf pairs must match", this.toMap(expectedConf), this.toMap(actualConf));
        Assert.assertEquals((String)"Conf values must be present", (Object)"v1", (Object)actualConf.get("k1"));
        Assert.assertEquals((String)"Conf values must be present", (Object)"v2", (Object)actualConf.get("k2"));
    }

    @Test
    public void testHadoopFileIOJavaSerialization() throws IOException, ClassNotFoundException {
        FileIO io = this.table.io();
        Configuration expectedConf = ((HadoopFileIO)io).conf();
        Table serializableTable = SerializableTableWithSize.copyOf((Table)this.table);
        FileIO deserializedIO = (FileIO)TestHelpers.roundTripSerialize((Object)serializableTable.io());
        Configuration actualConf = ((HadoopFileIO)deserializedIO).conf();
        Assert.assertEquals((String)"Conf pairs must match", this.toMap(expectedConf), this.toMap(actualConf));
        Assert.assertEquals((String)"Conf values must be present", (Object)"v1", (Object)actualConf.get("k1"));
        Assert.assertEquals((String)"Conf values must be present", (Object)"v2", (Object)actualConf.get("k2"));
    }

    private Map<String, String> toMap(Configuration conf) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)conf.size());
        conf.forEach(entry -> map.put((String)entry.getKey(), (String)entry.getValue()));
        return map;
    }

    static {
        CONF.set("k1", "v1");
        CONF.set("k2", "v2");
    }
}

