/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Files;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.TaskCheckHelper;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.data.RandomData;
import org.apache.iceberg.spark.data.SparkParquetWriters;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.SparkConf;
import org.apache.spark.serializer.KryoSerializer;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestDataFileSerialization {
    private static final Schema DATE_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)3, (String)"date", (Type)Types.StringType.get()), Types.NestedField.optional((int)4, (String)"double", (Type)Types.DoubleType.get())});
    private static final PartitionSpec PARTITION_SPEC = PartitionSpec.builderFor((Schema)DATE_SCHEMA).identity("date").build();
    private static final Map<Integer, Long> VALUE_COUNTS = Maps.newHashMap();
    private static final Map<Integer, Long> NULL_VALUE_COUNTS = Maps.newHashMap();
    private static final Map<Integer, Long> NAN_VALUE_COUNTS = Maps.newHashMap();
    private static final Map<Integer, ByteBuffer> LOWER_BOUNDS = Maps.newHashMap();
    private static final Map<Integer, ByteBuffer> UPPER_BOUNDS = Maps.newHashMap();
    private static final DataFile DATA_FILE;
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    @Test
    public void testDataFileKryoSerialization() throws Exception {
        File data = this.temp.newFile();
        Assert.assertTrue((boolean)data.delete());
        Kryo kryo = new KryoSerializer(new SparkConf()).newKryo();
        try (Output out = new Output((OutputStream)new FileOutputStream(data));){
            kryo.writeClassAndObject(out, (Object)DATA_FILE);
            kryo.writeClassAndObject(out, DATA_FILE.copy());
        }
        var4_4 = null;
        try (Input in = new Input((InputStream)new FileInputStream(data));){
            for (int i = 0; i < 2; ++i) {
                Object obj = kryo.readClassAndObject(in);
                ((ObjectAssert)Assertions.assertThat((Object)obj).as("Should be a DataFile", new Object[0])).isInstanceOf(DataFile.class);
                TaskCheckHelper.assertEquals(DATA_FILE, (DataFile)obj);
            }
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testDataFileJavaSerialization() throws Exception {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try (ObjectOutputStream out = new ObjectOutputStream(bytes);){
            out.writeObject(DATA_FILE);
            out.writeObject(DATA_FILE.copy());
        }
        var3_3 = null;
        try (ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes.toByteArray()));){
            for (int i = 0; i < 2; ++i) {
                Object obj = in.readObject();
                ((ObjectAssert)Assertions.assertThat((Object)obj).as("Should be a DataFile", new Object[0])).isInstanceOf(DataFile.class);
                TaskCheckHelper.assertEquals(DATA_FILE, (DataFile)obj);
            }
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParquetWriterSplitOffsets() throws IOException {
        Iterable<InternalRow> records = RandomData.generateSpark(DATE_SCHEMA, 1, 33L);
        File parquetFile = new File(this.temp.getRoot(), FileFormat.PARQUET.addExtension(UUID.randomUUID().toString()));
        try (FileAppender writer = Parquet.write((OutputFile)Files.localOutput((File)parquetFile)).schema(DATE_SCHEMA).createWriterFunc(msgType -> SparkParquetWriters.buildWriter((StructType)SparkSchemaUtil.convert((Schema)DATE_SCHEMA), (MessageType)msgType)).build();){
            writer.addAll(records);
        }
        Kryo kryo = new KryoSerializer(new SparkConf()).newKryo();
        File dataFile = this.temp.newFile();
        try (Output out = new Output((OutputStream)new FileOutputStream(dataFile));){
            kryo.writeClassAndObject(out, (Object)writer.splitOffsets());
        }
        var7_8 = null;
        try (Input in = new Input((InputStream)new FileInputStream(dataFile));){
            kryo.readClassAndObject(in);
        }
        catch (Throwable throwable) {
            var7_8 = throwable;
            throw throwable;
        }
    }

    private static ByteBuffer longToBuffer(long value) {
        return ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(0, value);
    }

    static {
        VALUE_COUNTS.put(1, 5L);
        VALUE_COUNTS.put(2, 3L);
        VALUE_COUNTS.put(4, 2L);
        NULL_VALUE_COUNTS.put(1, 0L);
        NULL_VALUE_COUNTS.put(2, 2L);
        NAN_VALUE_COUNTS.put(4, 1L);
        LOWER_BOUNDS.put(1, TestDataFileSerialization.longToBuffer(0L));
        UPPER_BOUNDS.put(1, TestDataFileSerialization.longToBuffer(4L));
        DATA_FILE = DataFiles.builder((PartitionSpec)PARTITION_SPEC).withPath("/path/to/data-1.parquet").withFileSizeInBytes(1234L).withPartitionPath("date=2018-06-08").withMetrics(new Metrics(Long.valueOf(5L), null, VALUE_COUNTS, NULL_VALUE_COUNTS, NAN_VALUE_COUNTS, LOWER_BOUNDS, UPPER_BOUNDS)).withSplitOffsets((List)ImmutableList.of((Object)4L)).withEncryptionKeyMetadata(ByteBuffer.allocate(4).putInt(34)).withSortOrder(SortOrder.unsorted()).build();
    }
}

