/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.ScanTaskGroup;
import org.junit.Assert;

public final class TaskCheckHelper {
    private TaskCheckHelper() {
    }

    public static void assertEquals(ScanTaskGroup<FileScanTask> expected, ScanTaskGroup<FileScanTask> actual) {
        List<FileScanTask> expectedTasks = TaskCheckHelper.getFileScanTasksInFilePathOrder(expected);
        List<FileScanTask> actualTasks = TaskCheckHelper.getFileScanTasksInFilePathOrder(actual);
        Assert.assertEquals((String)"The number of file scan tasks should match", (long)expectedTasks.size(), (long)actualTasks.size());
        for (int i = 0; i < expectedTasks.size(); ++i) {
            FileScanTask expectedTask = expectedTasks.get(i);
            FileScanTask actualTask = actualTasks.get(i);
            TaskCheckHelper.assertEquals(expectedTask, actualTask);
        }
    }

    public static void assertEquals(FileScanTask expected, FileScanTask actual) {
        TaskCheckHelper.assertEquals((DataFile)expected.file(), (DataFile)actual.file());
        Assert.assertEquals((String)"PartitionSpec doesn't match", (Object)expected.spec(), (Object)actual.spec());
        Assert.assertEquals((String)"starting position doesn't match", (long)expected.start(), (long)actual.start());
        Assert.assertEquals((String)"the number of bytes to scan doesn't match", (long)expected.start(), (long)actual.start());
        Assert.assertEquals((String)"Residual expression doesn't match", (Object)expected.residual().toString(), (Object)actual.residual().toString());
    }

    public static void assertEquals(DataFile expected, DataFile actual) {
        Assert.assertEquals((String)"Should match the serialized record path", (Object)expected.path(), (Object)actual.path());
        Assert.assertEquals((String)"Should match the serialized record format", (Object)expected.format(), (Object)actual.format());
        Assert.assertEquals((String)"Should match the serialized record partition", (Object)expected.partition().get(0, Object.class), (Object)actual.partition().get(0, Object.class));
        Assert.assertEquals((String)"Should match the serialized record count", (long)expected.recordCount(), (long)actual.recordCount());
        Assert.assertEquals((String)"Should match the serialized record size", (long)expected.fileSizeInBytes(), (long)actual.fileSizeInBytes());
        Assert.assertEquals((String)"Should match the serialized record value counts", (Object)expected.valueCounts(), (Object)actual.valueCounts());
        Assert.assertEquals((String)"Should match the serialized record null value counts", (Object)expected.nullValueCounts(), (Object)actual.nullValueCounts());
        Assert.assertEquals((String)"Should match the serialized record lower bounds", (Object)expected.lowerBounds(), (Object)actual.lowerBounds());
        Assert.assertEquals((String)"Should match the serialized record upper bounds", (Object)expected.upperBounds(), (Object)actual.upperBounds());
        Assert.assertEquals((String)"Should match the serialized record key metadata", (Object)expected.keyMetadata(), (Object)actual.keyMetadata());
        Assert.assertEquals((String)"Should match the serialized record offsets", (Object)expected.splitOffsets(), (Object)actual.splitOffsets());
        Assert.assertEquals((String)"Should match the serialized record offsets", (Object)expected.keyMetadata(), (Object)actual.keyMetadata());
    }

    private static List<FileScanTask> getFileScanTasksInFilePathOrder(ScanTaskGroup<FileScanTask> taskGroup) {
        return taskGroup.tasks().stream().sorted(Comparator.comparing(o -> ((DataFile)o.file()).path().toString() + "##" + o.start())).collect(Collectors.toList());
    }
}

