/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Map;
import org.apache.iceberg.BatchScan;
import org.apache.iceberg.DataTableScanTestBase;
import org.apache.iceberg.PlanningMode;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.SparkDistributedDataScan;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.spark.SparkReadConf;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.internal.SQLConf;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class SparkDistributedDataScanTestBase
extends DataTableScanTestBase<BatchScan, ScanTask, ScanTaskGroup<ScanTask>> {
    protected static SparkSession spark = null;
    private final PlanningMode dataMode;
    private final PlanningMode deleteMode;

    @Parameterized.Parameters(name="formatVersion = {0}, dataMode = {1}, deleteMode = {2}")
    public static Object[] parameters() {
        return new Object[][]{{1, PlanningMode.LOCAL, PlanningMode.LOCAL}, {1, PlanningMode.LOCAL, PlanningMode.DISTRIBUTED}, {1, PlanningMode.DISTRIBUTED, PlanningMode.LOCAL}, {1, PlanningMode.DISTRIBUTED, PlanningMode.DISTRIBUTED}, {2, PlanningMode.LOCAL, PlanningMode.LOCAL}, {2, PlanningMode.LOCAL, PlanningMode.DISTRIBUTED}, {2, PlanningMode.DISTRIBUTED, PlanningMode.LOCAL}, {2, PlanningMode.DISTRIBUTED, PlanningMode.DISTRIBUTED}};
    }

    public SparkDistributedDataScanTestBase(int formatVersion, PlanningMode dataPlanningMode, PlanningMode deletePlanningMode) {
        super(formatVersion);
        this.dataMode = dataPlanningMode;
        this.deleteMode = deletePlanningMode;
    }

    @Before
    public void configurePlanningModes() {
        this.table.updateProperties().set("read.data-planning-mode", this.dataMode.modeName()).set("read.delete-planning-mode", this.deleteMode.modeName()).commit();
    }

    protected BatchScan useRef(BatchScan scan, String ref) {
        return scan.useRef(ref);
    }

    protected BatchScan useSnapshot(BatchScan scan, long snapshotId) {
        return scan.useSnapshot(snapshotId);
    }

    protected BatchScan asOfTime(BatchScan scan, long timestampMillis) {
        return scan.asOfTime(timestampMillis);
    }

    protected BatchScan newScan() {
        SparkReadConf readConf = new SparkReadConf(spark, (Table)this.table, (Map)ImmutableMap.of());
        return new SparkDistributedDataScan(spark, (Table)this.table, readConf);
    }

    protected static SparkSession initSpark(String serializer) {
        return SparkSession.builder().master("local[2]").config("spark.serializer", serializer).config(SQLConf.SHUFFLE_PARTITIONS().key(), "4").getOrCreate();
    }
}

