/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.iceberg.InternalTestHelpers;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.parquet.InternalReader;
import org.apache.iceberg.data.parquet.InternalWriter;
import org.apache.iceberg.inmemory.InMemoryOutputFile;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.parquet.ParquetVariantUtil;
import org.apache.iceberg.parquet.VariantShreddingFunction;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.variants.ValueArray;
import org.apache.iceberg.variants.Variant;
import org.apache.iceberg.variants.VariantArray;
import org.apache.iceberg.variants.VariantMetadata;
import org.apache.iceberg.variants.VariantObject;
import org.apache.iceberg.variants.VariantTestUtil;
import org.apache.iceberg.variants.VariantValue;
import org.apache.iceberg.variants.Variants;
import org.apache.parquet.schema.MessageType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.FieldSource;

public class TestVariantWriters {
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"var", (Type)Types.VariantType.get())});
    private static final GenericRecord RECORD = GenericRecord.create((Schema)SCHEMA);
    private static final ByteBuffer TEST_METADATA_BUFFER = VariantTestUtil.createMetadata((Collection)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e"), (boolean)true);
    private static final ByteBuffer TEST_OBJECT_BUFFER = VariantTestUtil.createObject((ByteBuffer)TEST_METADATA_BUFFER, (Map)ImmutableMap.of((Object)"a", (Object)Variants.ofNull(), (Object)"d", (Object)Variants.of((String)"iceberg")));
    private static final ByteBuffer SIMILAR_OBJECT_BUFFER = VariantTestUtil.createObject((ByteBuffer)TEST_METADATA_BUFFER, (Map)ImmutableMap.of((Object)"a", (Object)Variants.of((int)123456789), (Object)"c", (Object)Variants.of((String)"string")));
    private static final ByteBuffer EMPTY_OBJECT_BUFFER = VariantTestUtil.createObject((ByteBuffer)TEST_METADATA_BUFFER, (Map)ImmutableMap.of());
    private static final ByteBuffer ARRAY_IN_OBJECT_BUFFER = VariantTestUtil.createObject((ByteBuffer)TEST_METADATA_BUFFER, (Map)ImmutableMap.of((Object)"a", (Object)Variants.of((int)123456789), (Object)"c", (Object)TestVariantWriters.array(new VariantValue[]{Variants.of((String)"string"), Variants.of((String)"iceberg")})));
    private static final VariantMetadata EMPTY_METADATA = Variants.metadata((ByteBuffer)VariantTestUtil.emptyMetadata());
    private static final VariantMetadata TEST_METADATA = Variants.metadata((ByteBuffer)TEST_METADATA_BUFFER);
    private static final VariantObject TEST_OBJECT = (VariantObject)Variants.value((VariantMetadata)TEST_METADATA, (ByteBuffer)TEST_OBJECT_BUFFER);
    private static final VariantObject SIMILAR_OBJECT = (VariantObject)Variants.value((VariantMetadata)TEST_METADATA, (ByteBuffer)SIMILAR_OBJECT_BUFFER);
    private static final VariantObject EMPTY_OBJECT = (VariantObject)Variants.value((VariantMetadata)TEST_METADATA, (ByteBuffer)EMPTY_OBJECT_BUFFER);
    private static final VariantObject ARRAY_IN_OBJECT = (VariantObject)Variants.value((VariantMetadata)TEST_METADATA, (ByteBuffer)ARRAY_IN_OBJECT_BUFFER);
    private static final ByteBuffer EMPTY_ARRAY_BUFFER = VariantTestUtil.createArray((VariantValue[])new VariantValue[0]);
    private static final ByteBuffer TEST_ARRAY_BUFFER = VariantTestUtil.createArray((VariantValue[])new VariantValue[]{Variants.of((String)"iceberg"), Variants.of((String)"string")});
    private static final ByteBuffer MIXED_TYPE_ARRAY_BUFFER = VariantTestUtil.createArray((VariantValue[])new VariantValue[]{Variants.of((String)"iceberg"), Variants.of((String)"string"), Variants.of((int)34)});
    private static final ByteBuffer NESTED_ARRAY_BUFFER = VariantTestUtil.createArray((VariantValue[])new VariantValue[]{TestVariantWriters.array(new VariantValue[]{Variants.of((String)"string"), Variants.of((String)"iceberg")}), TestVariantWriters.array(new VariantValue[]{Variants.of((String)"apple"), Variants.of((String)"banana")})});
    private static final ByteBuffer MIXED_NESTED_ARRAY_BUFFER = VariantTestUtil.createArray((VariantValue[])new VariantValue[]{TestVariantWriters.array(new VariantValue[]{Variants.of((String)"string"), Variants.of((String)"iceberg"), Variants.of((int)34)}), TestVariantWriters.array(new VariantValue[]{Variants.of((int)34), Variants.ofNull()}), TestVariantWriters.array(new VariantValue[0]), TestVariantWriters.array(new VariantValue[]{Variants.of((String)"string"), Variants.of((String)"iceberg")}), Variants.of((int)34)});
    private static final ByteBuffer OBJECT_IN_ARRAY_BUFFER = VariantTestUtil.createArray((VariantValue[])new VariantValue[]{SIMILAR_OBJECT, SIMILAR_OBJECT});
    private static final ByteBuffer MIXED_OBJECT_IN_ARRAY_BUFFER = VariantTestUtil.createArray((VariantValue[])new VariantValue[]{SIMILAR_OBJECT, SIMILAR_OBJECT, Variants.of((String)"iceberg"), Variants.of((int)34)});
    private static final VariantArray EMPTY_ARRAY = (VariantArray)Variants.value((VariantMetadata)EMPTY_METADATA, (ByteBuffer)EMPTY_ARRAY_BUFFER);
    private static final VariantArray TEST_ARRAY = (VariantArray)Variants.value((VariantMetadata)EMPTY_METADATA, (ByteBuffer)TEST_ARRAY_BUFFER);
    private static final VariantArray MIXED_TYPE_ARRAY = (VariantArray)Variants.value((VariantMetadata)EMPTY_METADATA, (ByteBuffer)MIXED_TYPE_ARRAY_BUFFER);
    private static final VariantArray NESTED_ARRAY = (VariantArray)Variants.value((VariantMetadata)EMPTY_METADATA, (ByteBuffer)NESTED_ARRAY_BUFFER);
    private static final VariantArray MIXED_NESTED_ARRAY = (VariantArray)Variants.value((VariantMetadata)EMPTY_METADATA, (ByteBuffer)MIXED_NESTED_ARRAY_BUFFER);
    private static final VariantArray OBJECT_IN_ARRAY = (VariantArray)Variants.value((VariantMetadata)TEST_METADATA, (ByteBuffer)OBJECT_IN_ARRAY_BUFFER);
    private static final VariantArray MIXED_OBJECT_IN_ARRAY = (VariantArray)Variants.value((VariantMetadata)TEST_METADATA, (ByteBuffer)MIXED_OBJECT_IN_ARRAY_BUFFER);
    private static final Variant[] VARIANTS = new Variant[]{Variant.of((VariantMetadata)EMPTY_METADATA, (VariantValue)Variants.ofNull()), Variant.of((VariantMetadata)EMPTY_METADATA, (VariantValue)Variants.of((boolean)true)), Variant.of((VariantMetadata)EMPTY_METADATA, (VariantValue)Variants.of((boolean)false)), Variant.of((VariantMetadata)EMPTY_METADATA, (VariantValue)Variants.of((byte)34)), Variant.of((VariantMetadata)EMPTY_METADATA, (VariantValue)Variants.of((byte)-34)), Variant.of((VariantMetadata)EMPTY_METADATA, (VariantValue)Variants.of((short)1234)), Variant.of((VariantMetadata)EMPTY_METADATA, (VariantValue)Variants.of((short)-1234)), Variant.of((VariantMetadata)EMPTY_METADATA, (VariantValue)Variants.of((int)12345)), Variant.of((VariantMetadata)EMPTY_METADATA, (VariantValue)Variants.of((int)-12345)), Variant.of((VariantMetadata)EMPTY_METADATA, (VariantValue)Variants.of((long)9876543210L)), Variant.of((VariantMetadata)EMPTY_METADATA, (VariantValue)Variants.of((long)-9876543210L)), Variant.of((VariantMetadata)EMPTY_METADATA, (VariantValue)Variants.of((float)10.11f)), Variant.of((VariantMetadata)EMPTY_METADATA, (VariantValue)Variants.of((float)-10.11f)), Variant.of((VariantMetadata)EMPTY_METADATA, (VariantValue)Variants.of((double)14.3)), Variant.of((VariantMetadata)EMPTY_METADATA, (VariantValue)Variants.of((double)-14.3)), Variant.of((VariantMetadata)EMPTY_METADATA, (VariantValue)EMPTY_OBJECT), Variant.of((VariantMetadata)TEST_METADATA, (VariantValue)TEST_OBJECT), Variant.of((VariantMetadata)TEST_METADATA, (VariantValue)SIMILAR_OBJECT), Variant.of((VariantMetadata)TEST_METADATA, (VariantValue)ARRAY_IN_OBJECT), Variant.of((VariantMetadata)EMPTY_METADATA, (VariantValue)EMPTY_ARRAY), Variant.of((VariantMetadata)EMPTY_METADATA, (VariantValue)TEST_ARRAY), Variant.of((VariantMetadata)EMPTY_METADATA, (VariantValue)MIXED_TYPE_ARRAY), Variant.of((VariantMetadata)EMPTY_METADATA, (VariantValue)NESTED_ARRAY), Variant.of((VariantMetadata)EMPTY_METADATA, (VariantValue)MIXED_NESTED_ARRAY), Variant.of((VariantMetadata)TEST_METADATA, (VariantValue)OBJECT_IN_ARRAY), Variant.of((VariantMetadata)TEST_METADATA, (VariantValue)MIXED_OBJECT_IN_ARRAY), Variant.of((VariantMetadata)EMPTY_METADATA, (VariantValue)Variants.ofIsoDate((String)"2024-11-07")), Variant.of((VariantMetadata)EMPTY_METADATA, (VariantValue)Variants.ofIsoDate((String)"1957-11-07")), Variant.of((VariantMetadata)EMPTY_METADATA, (VariantValue)Variants.ofIsoTimestamptz((String)"2024-11-07T12:33:54.123456+00:00")), Variant.of((VariantMetadata)EMPTY_METADATA, (VariantValue)Variants.ofIsoTimestamptz((String)"1957-11-07T12:33:54.123456+00:00")), Variant.of((VariantMetadata)EMPTY_METADATA, (VariantValue)Variants.ofIsoTimestampntz((String)"2024-11-07T12:33:54.123456")), Variant.of((VariantMetadata)EMPTY_METADATA, (VariantValue)Variants.ofIsoTimestampntz((String)"1957-11-07T12:33:54.123456")), Variant.of((VariantMetadata)EMPTY_METADATA, (VariantValue)Variants.of((BigDecimal)new BigDecimal("123456.789"))), Variant.of((VariantMetadata)EMPTY_METADATA, (VariantValue)Variants.of((BigDecimal)new BigDecimal("-123456.789"))), Variant.of((VariantMetadata)EMPTY_METADATA, (VariantValue)Variants.of((BigDecimal)new BigDecimal("123456789.987654321"))), Variant.of((VariantMetadata)EMPTY_METADATA, (VariantValue)Variants.of((BigDecimal)new BigDecimal("-123456789.987654321"))), Variant.of((VariantMetadata)EMPTY_METADATA, (VariantValue)Variants.of((BigDecimal)new BigDecimal("9876543210.123456789"))), Variant.of((VariantMetadata)EMPTY_METADATA, (VariantValue)Variants.of((BigDecimal)new BigDecimal("-9876543210.123456789"))), Variant.of((VariantMetadata)EMPTY_METADATA, (VariantValue)Variants.of((ByteBuffer)ByteBuffer.wrap(new byte[]{10, 11, 12, 13}))), Variant.of((VariantMetadata)EMPTY_METADATA, (VariantValue)Variants.of((String)"iceberg")), Variant.of((VariantMetadata)EMPTY_METADATA, (VariantValue)Variants.ofIsoTime((String)"12:33:54.123456")), Variant.of((VariantMetadata)EMPTY_METADATA, (VariantValue)Variants.ofIsoTimestamptzNanos((String)"2024-11-07T12:33:54.123456789+00:00")), Variant.of((VariantMetadata)EMPTY_METADATA, (VariantValue)Variants.ofIsoTimestamptzNanos((String)"1957-11-07T12:33:54.123456789+00:00")), Variant.of((VariantMetadata)EMPTY_METADATA, (VariantValue)Variants.ofIsoTimestampntzNanos((String)"2024-11-07T12:33:54.123456789")), Variant.of((VariantMetadata)EMPTY_METADATA, (VariantValue)Variants.ofIsoTimestampntzNanos((String)"1957-11-07T12:33:54.123456789")), Variant.of((VariantMetadata)EMPTY_METADATA, (VariantValue)Variants.ofUUID((String)"f24f9b64-81fa-49d1-b74e-8c09a6e31c56"))};

    @ParameterizedTest
    @FieldSource(value={"VARIANTS"})
    public void testUnshreddedValues(Variant variant) throws IOException {
        Record record = RECORD.copy("id", (Object)1, "var", (Object)variant);
        Record actual = TestVariantWriters.writeAndRead((id, name) -> null, record);
        InternalTestHelpers.assertEquals((Types.StructType)SCHEMA.asStruct(), (Record)record, (Record)actual);
    }

    @ParameterizedTest
    @FieldSource(value={"VARIANTS"})
    public void testShreddedValues(Variant variant) throws IOException {
        Record record = RECORD.copy("id", (Object)1, "var", (Object)variant);
        Record actual = TestVariantWriters.writeAndRead((id, name) -> ParquetVariantUtil.toParquetSchema((VariantValue)variant.value()), record);
        InternalTestHelpers.assertEquals((Types.StructType)SCHEMA.asStruct(), (Record)record, (Record)actual);
    }

    @ParameterizedTest
    @FieldSource(value={"VARIANTS"})
    public void testMixedShredding(Variant variant) throws IOException {
        List<Record> expected = IntStream.range(0, VARIANTS.length).mapToObj(i -> RECORD.copy("id", (Object)i, "var", (Object)VARIANTS[i])).collect(Collectors.toList());
        List<Record> actual = TestVariantWriters.writeAndRead((id, name) -> ParquetVariantUtil.toParquetSchema((VariantValue)variant.value()), expected);
        Assertions.assertThat(actual).hasSameSizeAs(expected);
        for (int i2 = 0; i2 < expected.size(); ++i2) {
            InternalTestHelpers.assertEquals((Types.StructType)SCHEMA.asStruct(), (Record)expected.get(i2), (Record)actual.get(i2));
        }
    }

    private static Record writeAndRead(VariantShreddingFunction shreddingFunc, Record record) throws IOException {
        return (Record)Iterables.getOnlyElement(TestVariantWriters.writeAndRead(shreddingFunc, List.of(record)));
    }

    private static List<Record> writeAndRead(VariantShreddingFunction shreddingFunc, List<Record> records) throws IOException {
        InMemoryOutputFile outputFile = new InMemoryOutputFile();
        try (FileAppender writer = Parquet.write((OutputFile)outputFile).schema(SCHEMA).variantShreddingFunc(shreddingFunc).createWriterFunc(fileSchema -> InternalWriter.create((Types.StructType)SCHEMA.asStruct(), (MessageType)fileSchema)).build();){
            for (Record record : records) {
                writer.add((Object)record);
            }
        }
        try (CloseableIterable reader = Parquet.read((InputFile)outputFile.toInputFile()).project(SCHEMA).createReaderFunc(fileSchema -> InternalReader.create((Schema)SCHEMA, (MessageType)fileSchema)).build();){
            ArrayList arrayList = Lists.newArrayList((Iterable)reader);
            return arrayList;
        }
    }

    private static ValueArray array(VariantValue ... values) {
        ValueArray arr = Variants.array();
        for (VariantValue value : values) {
            arr.add(value);
        }
        return arr;
    }
}

